/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivelanterns;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.SimpleAccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import toni.immersivelanterns.BaseLanternRenderer;
import toni.immersivelanterns.foundation.config.AllConfigs;

class AccessoriesLanternRenderer
extends BaseLanternRenderer
implements SimpleAccessoryRenderer {
    AccessoriesLanternRenderer() {
    }

    public static void register() {
        AccessoriesRendererRegistry.registerRenderer((Item)Items.LANTERN, AccessoriesLanternRenderer::new);
        AccessoriesRendererRegistry.registerRenderer((Item)Items.SOUL_LANTERN, AccessoriesLanternRenderer::new);
    }

    public static boolean isEquipped(Player player) {
        AccessoriesAPIAccess accessories = (AccessoriesAPIAccess)player;
        AccessoriesCapability capability = accessories.accessoriesCapability();
        if (capability == null) {
            return false;
        }
        return capability.isEquipped((T stack) -> stack.getItem() == Items.LANTERN || stack.getItem() == Items.SOUL_LANTERN);
    }

    public static ItemStack getEquipped(Player player) {
        AccessoriesAPIAccess accessories = (AccessoriesAPIAccess)player;
        AccessoriesCapability capability = accessories.accessoriesCapability();
        if (capability == null) {
            return null;
        }
        List equipped = capability.getEquipped((T stack) -> stack.getItem() == Items.LANTERN || stack.getItem() == Items.SOUL_LANTERN);
        if (equipped == null || equipped.isEmpty()) {
            return null;
        }
        return ((SlotEntryReference)equipped.get(0)).reference().getStack();
    }

    public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = reference.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (model instanceof PlayerModel) {
                float xOffset;
                PlayerModel playerModel = (PlayerModel)model;
                boolean isWearingArmor = false;
                for (ItemStack armor : player.getArmorSlots()) {
                    if (!armor.is(ItemTags.LEG_ARMOR) && !armor.is(ItemTags.CHEST_ARMOR)) continue;
                    isWearingArmor = true;
                    break;
                }
                float lanternTop = 0.6875f;
                float f = xOffset = (Boolean)AllConfigs.client().leftHandedLanterns.get() != false ? 0.1f : 2.0f;
                float zOffset = ((Boolean)AllConfigs.client().backLanterns.get()).booleanValue() ? (isWearingArmor ? -3.1f : -3.0f) : -1.0f;
                Vec3 hipOffset = isWearingArmor ? new Vec3((double)(xOffset + 0.05f), -1.25, (double)(zOffset + 0.05f)) : new Vec3((double)(xOffset - 0.1f), -1.25, (double)(zOffset - 0.1f));
                AccessoryRenderer.transformToModelPart((PoseStack)matrices, (ModelPart)playerModel.body, (Number)hipOffset.x, (Number)hipOffset.y, (Number)hipOffset.z);
                matrices.translate(0.5f, lanternTop, 0.5f);
                Vector4f localPosition = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
                localPosition.mulTranspose((Matrix4fc)matrices.last().pose());
                Vec3 hipPosition = new Vec3((double)localPosition.x(), (double)localPosition.y(), (double)localPosition.z());
                hipPosition = hipPosition.add(player.getPosition(partialTicks));
                Vec3 update = Minecraft.getInstance().screen == null && (Boolean)AllConfigs.client().enablePhysics.get() != false ? this.updatePendulum(player, hipPosition, partialTicks) : Vec3.ZERO;
                double xRot = update.z;
                xRot += (double)(Math.min(0.0f, playerModel.rightLeg.xRot / 3.0f) - ((Boolean)AllConfigs.client().backLanterns.get() != false ? -0.1f : 0.1f));
                matrices.mulPose(new Quaternionf().rotationZYX((float)update.x, 0.0f, (float)(xRot -= (double)playerModel.body.xRot)));
                matrices.translate(-0.5f, -lanternTop, -0.5f);
                BlockState blockstate = Block.byItem((Item)stack.getItem()).defaultBlockState();
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockstate, matrices, multiBufferSource, light, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    public <M extends LivingEntity> void align(ItemStack stack, SlotReference reference, EntityModel<M> model, PoseStack matrices) {
    }
}

