/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.IBlockGetter;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.mixin.ContraptionAccessor;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;

public class AdvancedDisplayUpdatePacket
extends BaseNetworkPacket<AdvancedDisplayUpdatePacket> {
    private BlockPos pos;
    private int entityId;
    private boolean isOnContraption;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;
    private IDisplaySettings settings;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(Level level, BlockPos pos, AbstractContraptionEntity contraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.isOnContraption = contraption != null;
        this.entityId = this.isOnContraption ? contraption.getId() : 0;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
        if (this.isOnContraption) {
            this.applyContraption(contraption, this);
        } else {
            this.apply(level, this);
        }
    }

    protected AdvancedDisplayUpdatePacket(BlockPos pos, int entityId, boolean isOnContraption, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.entityId = entityId;
        this.isOnContraption = isOnContraption;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, RegistryFriendlyByteBuf buffer) {
        CompoundTag k = new CompoundTag();
        packet.key.toNbt(k);
        buffer.writeBlockPos(packet.pos);
        buffer.writeNbt((Tag)k);
        buffer.writeBoolean(packet.doubleSided);
        buffer.writeBoolean(packet.isOnContraption);
        buffer.writeInt(packet.entityId);
        buffer.writeNbt((Tag)packet.settings.serializeNbt());
    }

    public AdvancedDisplayUpdatePacket decode(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.readNbt());
        boolean doubleSided = buffer.readBoolean();
        boolean isOnContraption = buffer.readBoolean();
        int entityId = buffer.readInt();
        IDisplaySettings settings = AdvancedDisplaysRegistry.createSettings(key);
        settings.deserializeNbt(buffer.readNbt());
        return new AdvancedDisplayUpdatePacket(pos, entityId, isOnContraption, key, doubleSided, settings);
    }

    private void apply(Level level, AdvancedDisplayUpdatePacket packet) {
        BlockEntity blockEntity;
        if (level.isLoaded(packet.pos) && (blockEntity = level.getBlockEntity(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity2 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity2.applyToAll(be -> {
                be.setDisplayType(level, packet.key, packet.settings);
                if (level.getBlockState(be.getBlockPos()).getBlock() instanceof AbstractAdvancedSidedDisplayBlock) {
                    BlockState state = level.getBlockState(be.getBlockPos());
                    state = (BlockState)state.setValue(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.setBlockAndUpdate(be.getBlockPos(), state);
                }
                be.notifyUpdate();
            }, new IBlockGetter.WorldBlockGetter(level));
        }
    }

    private void applyContraption(AbstractContraptionEntity contraptionEntity, AdvancedDisplayUpdatePacket packet) {
        Object object;
        Contraption contraption = contraptionEntity.getContraption();
        ContraptionWorld level = contraption.getContraptionWorld();
        HashSet<BlockPos> blockEntityPositions = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos pos = packet.pos.mutable();
        MutablePair rootActor = contraption.getActorAt((BlockPos)pos);
        if (rootActor == null || rootActor.right == null) {
            return;
        }
        MovementContext rootCtx = (MovementContext)rootActor.getRight();
        StructureTemplate.StructureBlockInfo rootInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos);
        Direction side = ((Direction)rootCtx.state.getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        int width = rootCtx.blockEntityData.getByte("XSize");
        int height = rootCtx.blockEntityData.getByte("YSize");
        Map<BlockPos, CompoundTag> updateTags = ((ContraptionAccessor)contraption).crn$updateTags();
        packet.key.toNbt(rootCtx.blockEntityData);
        packet.key.toNbt(rootCtx.data);
        packet.key.toNbt(rootInfo.nbt());
        rootCtx.blockEntityData.put("DisplaySettings", (Tag)packet.settings.serializeNbt());
        rootCtx.data.put("DisplaySettings", (Tag)packet.settings.serializeNbt());
        rootInfo.nbt().put("DisplaySettings", (Tag)packet.settings.serializeNbt());
        blockEntityPositions.add(new BlockPos(pos.getX(), pos.getY(), pos.getZ()));
        if (rootInfo.state().getBlock() instanceof AbstractAdvancedSidedDisplayBlock) {
            BlockState newState = (BlockState)rootInfo.state().setValue(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
            contraption.getBlocks().put(pos, new StructureTemplate.StructureBlockInfo(rootInfo.pos(), newState, rootInfo.nbt()));
            contraption.deferInvalidate = true;
        }
        if (contraption.presentBlockEntities.containsKey(pos) && (object = contraption.presentBlockEntities.get(pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)object;
            be.setDisplayType((Level)level, packet.key, packet.settings);
            be.setBlockState(((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(pos)).state());
        }
        for (int i = 0; i < width && i < 16; ++i) {
            BlockPos newPos = pos.relative(side, i);
            for (int j = 0; j < height && j < 16; ++j) {
                Object v;
                BlockPos newPos2 = newPos.relative(Direction.DOWN, j);
                MutablePair actor = contraption.getActorAt(newPos2);
                if (actor == null || actor.right == null) continue;
                blockEntityPositions.add(new BlockPos(newPos2.getX(), newPos2.getY(), newPos2.getZ()));
                MovementContext ctx = (MovementContext)actor.getRight();
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(newPos2);
                packet.key.toNbt(ctx.blockEntityData);
                packet.key.toNbt(ctx.data);
                packet.key.toNbt(info.nbt());
                ctx.blockEntityData.put("DisplaySettings", (Tag)packet.settings.serializeNbt());
                ctx.data.put("DisplaySettings", (Tag)packet.settings.serializeNbt());
                info.nbt().put("DisplaySettings", (Tag)packet.settings.serializeNbt());
                if (contraption.presentBlockEntities.containsKey(newPos2) && (v = contraption.presentBlockEntities.get(newPos2)) instanceof AdvancedDisplayBlockEntity) {
                    AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)v;
                    be.setDisplayType((Level)level, packet.key, packet.settings);
                    be.setBlockState(((StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(newPos2)).state());
                }
                if (!(info.state().getBlock() instanceof AbstractAdvancedSidedDisplayBlock)) continue;
                BlockState newState = (BlockState)info.state().setValue(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                contraption.getBlocks().put(newPos2, new StructureTemplate.StructureBlockInfo(newPos2, newState, info.nbt()));
            }
        }
        IBlockGetter.ContraptionBlockGetter getter = new IBlockGetter.ContraptionBlockGetter(contraptionEntity);
        for (MutablePair a : contraption.getActors()) {
            BlockEntity blockEntity = getter.getBlockEntity(((StructureTemplate.StructureBlockInfo)a.getLeft()).pos());
            if (!(blockEntity instanceof AdvancedDisplayBlockEntity)) continue;
            AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
            be.updateControllerStatus2(getter);
            if (level.isClientSide()) {
                be.getRenderer().update((Level)level, ((StructureTemplate.StructureBlockInfo)a.getLeft()).pos(), be.getBlockState(), (BlockEntity)be, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            if (!updateTags.containsKey(((StructureTemplate.StructureBlockInfo)a.getLeft()).pos())) continue;
            be.writeClient(updateTags.get(((StructureTemplate.StructureBlockInfo)a.getLeft()).pos()), (HolderLookup.Provider)level.registryAccess());
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Player player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                Level level = player.level();
                if (packet.isOnContraption) {
                    Entity patt0$temp = level.getEntity(packet.entityId);
                    if (patt0$temp instanceof AbstractContraptionEntity) {
                        AbstractContraptionEntity ce = (AbstractContraptionEntity)patt0$temp;
                        this.applyContraption(ce, packet);
                    }
                } else {
                    this.apply(level, packet);
                }
            }
        });
    }
}

