/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.blockentity;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.block.NavigatorLecternBlock;
import de.mrjulsen.crn.registry.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class NavigatorLecternBlockEntity
extends SmartBlockEntity {
    public NavigatorLecternBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void setNavigator(ItemStack newNavigator) {
        if (newNavigator != null) {
            this.level.playSound((Player)null, this.getBlockPos(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.8f, 1.0f);
        }
    }

    public void swapControllers(ItemStack stack, Player player, InteractionHand hand, BlockState state) {
        ItemStack newController = stack.copy();
        stack.setCount(0);
        if (player.getItemInHand(hand).isEmpty()) {
            player.setItemInHand(hand, this.createNavigator());
        } else {
            this.dropController(state);
        }
        this.setNavigator(newController);
    }

    public void dropController(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)NavigatorLecternBlock.FACING);
        double x = (double)this.worldPosition.getX() + 0.5 + 0.25 * (double)dir.getStepX();
        double y = this.worldPosition.getY() + 1;
        double z = (double)this.worldPosition.getZ() + 0.5 + 0.25 * (double)dir.getStepZ();
        ItemEntity itementity = new ItemEntity(this.level, x, y, z, this.createNavigator());
        itementity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itementity);
        this.level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    public static boolean playerInRange(Player player, Level world, BlockPos pos) {
        double reach = 5.0;
        return player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < reach * reach;
    }

    private ItemStack createNavigator() {
        ItemStack stack = ModItems.NAVIGATOR.asStack();
        return stack;
    }
}

