/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.data.SlotTypeLoader;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntitySlotLoader
extends ReplaceableJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static final EntitySlotLoader INSTANCE = new EntitySlotLoader();
    private Map<EntityType<?>, Map<String, SlotType>> server = new HashMap();
    private Map<EntityType<?>, Map<String, SlotType>> client = new HashMap();

    protected EntitySlotLoader() {
        super(GSON, LOGGER, "accessories/entity");
    }

    public static Map<String, SlotType> getEntitySlots(LivingEntity livingEntity) {
        return EntitySlotLoader.getEntitySlots(livingEntity.level(), livingEntity.getType());
    }

    public static Map<String, SlotType> getEntitySlots(Level level, EntityType<?> entityType) {
        Map<String, SlotType> map = INSTANCE.getSlotTypes(level.isClientSide, entityType);
        return map != null ? map : Map.of();
    }

    @Nullable
    public final Map<String, SlotType> getSlotTypes(boolean isClientSide, EntityType<?> entityType) {
        return this.getEntitySlotData(isClientSide).get(entityType);
    }

    @ApiStatus.Internal
    public final Map<EntityType<?>, Map<String, SlotType>> getEntitySlotData(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    @ApiStatus.Internal
    public final void setEntitySlotData(Map<EntityType<?>, Map<String, SlotType>> data) {
        this.client = ImmutableMap.copyOf(data);
    }

    protected void apply(Map<ResourceLocation, JsonObject> data, ResourceManager resourceManager, ProfilerFiller profiler) {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        HashMap<EntityType, Map> tempMap = new HashMap<EntityType, Map>();
        for (Map.Entry<ResourceLocation, JsonObject> entry : data.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonObject jsonObject = entry.getValue();
            if (!AccessoriesInternals.isValidOnConditions(jsonObject, this.directory, location, null)) continue;
            HashMap slots = new HashMap();
            JsonArray slotElements = this.safeHelper(GsonHelper::getAsJsonArray, jsonObject, "slots", new JsonArray(), location);
            this.decodeJsonArray(slotElements, "slot", location, element -> {
                String slotName = element.getAsString();
                return Pair.of((Object)slotName, (Object)((SlotType)allSlotTypes.get(slotName)));
            }, slotInfo -> {
                SlotType slotType = (SlotType)slotInfo.right();
                if (slotType != null) {
                    if (!ExtraSlotTypeProperties.getProperty((String)slotInfo.left(), false).strictMode()) {
                        slots.put(slotType.name(), slotType);
                    } else {
                        LOGGER.warn("Unable to add the given slot to the given group due to it being in strict mode! [Slot: {}]", slotInfo.left());
                    }
                } else if (slotType == null) {
                    LOGGER.warn("Unable to locate a given slot to add to a given entity('s) as it was not registered: [Slot: {}]", slotInfo.first());
                }
            });
            ArrayList entities = new ArrayList();
            JsonArray entityElements = this.safeHelper(GsonHelper::getAsJsonArray, jsonObject, "entities", new JsonArray(), location);
            this.decodeJsonArray(entityElements, "entity", location, element -> {
                String string = element.getAsString();
                if (string.contains("#")) {
                    ResourceLocation entityTypeTagLocation = ResourceLocation.tryParse((String)string.replace("#", ""));
                    TagKey entityTypeTag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)entityTypeTagLocation);
                    return AccessoriesInternals.getHolder(entityTypeTag).map(holders -> holders.stream().map(Holder::value).collect(Collectors.toSet())).orElseGet(() -> {
                        LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType Tag used within a slot entry: [Location: {}]", (Object)string);
                        return Set.of();
                    });
                }
                return Optional.ofNullable(ResourceLocation.tryParse((String)string)).map(location1 -> BuiltInRegistries.ENTITY_TYPE.getOptional(location1).map(Set::of).orElse(Set.of())).orElseGet(() -> {
                    LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType within the registries for a slot entry: [Location: {}]", (Object)string);
                    return Set.of();
                });
            }, entities::addAll);
            for (EntityType entityType : entities) {
                tempMap.computeIfAbsent(entityType, entityType1 -> new HashMap()).putAll(slots);
            }
        }
        for (Map.Entry<Object, Object> entry : UniqueSlotHandling.getSlotToEntities().entrySet()) {
            SlotType slotType = SlotTypeLoader.INSTANCE.getSlotTypes(false).get(entry.getKey());
            for (EntityType entityType : (Set)entry.getValue()) {
                tempMap.computeIfAbsent(entityType, entityType1 -> new HashMap()).put(slotType.name(), slotType);
            }
        }
        this.server = ImmutableMap.copyOf(tempMap);
    }
}

