/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.advancement;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DamagePredicate;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.DefaultBlockInteractionTrigger;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerHurtEntityTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.registry.ModEntityTypes;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class FDAdvancementGenerator
implements AdvancementProvider.AdvancementGenerator {
    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        AdvancementHolder farmersDelight = Advancement.Builder.advancement().display((ItemLike)ModItems.COOKING_POT.get(), (Component)TextUtils.getTranslation("advancement.root", new Object[0]), (Component)TextUtils.getTranslation("advancement.root.desc", new Object[0]), ResourceLocation.parse((String)"minecraft:textures/block/bricks.png"), AdvancementType.TASK, false, false, false).addCriterion("seeds", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[0])).save(consumer, this.getNameId("main/root"));
        AdvancementHolder huntAndGather = FDAdvancementGenerator.getAdvancement(farmersDelight, (ItemLike)ModItems.FLINT_KNIFE.get(), "craft_knife", AdvancementType.TASK, true, true, false).addCriterion("flint_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.FLINT_KNIFE.get()})).addCriterion("iron_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.IRON_KNIFE.get()})).addCriterion("diamond_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DIAMOND_KNIFE.get()})).addCriterion("golden_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.GOLDEN_KNIFE.get()})).addCriterion("netherite_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETHERITE_KNIFE.get()})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/craft_knife"));
        AdvancementHolder graspingAtStraws = FDAdvancementGenerator.getAdvancement(huntAndGather, (ItemLike)ModItems.STRAW.get(), "harvest_straw", AdvancementType.TASK, true, false, false).addCriterion("harvest_straw", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STRAW.get()})).save(consumer, this.getNameId("main/harvest_straw"));
        AdvancementHolder advancedComposting = FDAdvancementGenerator.getAdvancement(graspingAtStraws, (ItemLike)ModItems.ORGANIC_COMPOST.get(), "place_organic_compost", AdvancementType.TASK, true, false, false).addCriterion("place_organic_compost", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.ORGANIC_COMPOST.get())).save(consumer, this.getNameId("main/place_organic_compost"));
        AdvancementHolder plantFood = FDAdvancementGenerator.getAdvancement(advancedComposting, (ItemLike)ModItems.RICH_SOIL.get(), "get_rich_soil", AdvancementType.GOAL, true, true, false).addCriterion("get_rich_soil", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICH_SOIL.get()})).save(consumer, this.getNameId("main/get_rich_soil"));
        AdvancementHolder wildButcher = FDAdvancementGenerator.getAdvancement(huntAndGather, (ItemLike)ModItems.HAM.get(), "get_ham", AdvancementType.TASK, true, false, false).addCriterion("ham", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAM.get()})).addCriterion("smoked_ham", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SMOKED_HAM.get()})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/get_ham"));
        AdvancementHolder watchYourFingers = FDAdvancementGenerator.getAdvancement(huntAndGather, (ItemLike)ModItems.CUTTING_BOARD.get(), "use_cutting_board", AdvancementType.TASK, true, false, false).addCriterion("cutting_board", CuttingBoardTrigger.TriggerInstance.simple()).save(consumer, this.getNameId("main/use_cutting_board"));
        AdvancementHolder cantTakeTheHeat = FDAdvancementGenerator.getAdvancement(watchYourFingers, (ItemLike)ModItems.NETHERITE_KNIFE.get(), "obtain_netherite_knife", AdvancementType.CHALLENGE, true, true, false).addCriterion("obtain_netherite_knife", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.NETHERITE_KNIFE.get()})).rewards(AdvancementRewards.Builder.experience((int)200)).save(consumer, this.getNameId("main/obtain_netherite_knife"));
        AdvancementHolder cropsOfTheWild = FDAdvancementGenerator.getAdvancement(farmersDelight, (ItemLike)ModItems.WILD_ONIONS.get(), "get_fd_seed", AdvancementType.TASK, true, true, false).addCriterion("cabbage_seeds", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CABBAGE_SEEDS.get()})).addCriterion("tomato_seeds", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.TOMATO_SEEDS.get()})).addCriterion("onion", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ONION.get()})).addCriterion("rice", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RICE.get()})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/get_fd_seed"));
        AdvancementHolder fungusAmongUs = FDAdvancementGenerator.getAdvancement(cropsOfTheWild, (ItemLike)ModItems.RED_MUSHROOM_COLONY.get(), "get_mushroom_colony", AdvancementType.TASK, true, false, false).addCriterion("brown_mushroom_colony", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BROWN_MUSHROOM_COLONY.get()})).addCriterion("red_mushroom_colony", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.RED_MUSHROOM_COLONY.get()})).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/get_mushroom_colony"));
        AdvancementHolder dippingYourRoots = FDAdvancementGenerator.getAdvancement(cropsOfTheWild, (ItemLike)ModItems.RICE.get(), "plant_rice", AdvancementType.TASK, true, false, false).addCriterion("plant_rice", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.RICE_CROP.get())).save(consumer, this.getNameId("main/plant_rice"));
        AdvancementHolder tallmato = FDAdvancementGenerator.getAdvancement(cropsOfTheWild, (ItemLike)ModItems.TOMATO.get(), "harvest_ropelogged_tomato", AdvancementType.TASK, true, false, false).addCriterion("harvest_ropelogged_tomato", CriteriaTriggers.DEFAULT_BLOCK_USE.createCriterion((CriterionTriggerInstance)new DefaultBlockInteractionTrigger.TriggerInstance(Optional.empty(), Optional.of(ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{ModBlocks.TOMATO_CROP.get()}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TomatoVineBlock.VINE_AGE, 0).hasProperty((Property)TomatoVineBlock.ROPELOGGED, true)))).build()}))))).save(consumer, this.getNameId("main/harvest_ropelogged_tomato"));
        AdvancementHolder booHiss = FDAdvancementGenerator.getAdvancement(tallmato, (ItemLike)ModItems.ROTTEN_TOMATO.get(), "hit_raider_with_rotten_tomato", AdvancementType.TASK, true, true, false).addCriterion("hit_raider_with_rotten_tomato", PlayerHurtEntityTrigger.TriggerInstance.playerHurtEntity(Optional.of(DamagePredicate.Builder.damageInstance().type(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).direct(EntityPredicate.Builder.entity().of(ModEntityTypes.ROTTEN_TOMATO.get()))).build()), Optional.of(EntityPredicate.Builder.entity().of(EntityTypeTags.RAIDERS).build()))).save(consumer, this.getNameId("main/hit_raider_with_rotten_tomato"));
        AdvancementHolder cropRotation = FDAdvancementGenerator.getAdvancement(dippingYourRoots, (ItemLike)ModItems.CABBAGE.get(), "plant_all_crops", AdvancementType.CHALLENGE, true, true, false).addCriterion("wheat", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.WHEAT)).addCriterion("beetroot", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.BEETROOTS)).addCriterion("carrot", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.CARROTS)).addCriterion("potato", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.POTATOES)).addCriterion("cabbage", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.CABBAGE_CROP.get())).addCriterion("tomato", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.BUDDING_TOMATO_CROP.get())).addCriterion("onion", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.ONION_CROP.get())).addCriterion("rice", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.RICE_CROP.get())).addCriterion("melon", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.MELON_STEM)).addCriterion("pumpkin", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.PUMPKIN_STEM)).addCriterion("sweet_berries", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.SWEET_BERRY_BUSH)).addCriterion("sugar_cane", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.SUGAR_CANE)).addCriterion("kelp", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.KELP)).addCriterion("cocoa", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.COCOA)).addCriterion("nether_wart", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.NETHER_WART)).addCriterion("chorus_flower", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.CHORUS_FLOWER)).addCriterion("brown_mushroom", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.BROWN_MUSHROOM)).addCriterion("red_mushroom", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.RED_MUSHROOM)).addCriterion("glow_berries", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.CAVE_VINES)).rewards(AdvancementRewards.Builder.experience((int)100)).save(consumer, this.getNameId("main/plant_all_crops"));
        AdvancementHolder bonfireLit = FDAdvancementGenerator.getAdvancement(farmersDelight, (ItemLike)Blocks.CAMPFIRE, "place_campfire", AdvancementType.TASK, true, true, false).addCriterion("campfire", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.CAMPFIRE)).addCriterion("soul_campfire", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)Blocks.SOUL_CAMPFIRE)).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/place_campfire"));
        AdvancementHolder portableCooking = FDAdvancementGenerator.getAdvancement(bonfireLit, (ItemLike)ModItems.SKILLET.get(), "use_skillet", AdvancementType.TASK, true, false, false).addCriterion("skillet", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.SKILLET.get()))).save(consumer, this.getNameId("main/use_skillet"));
        AdvancementHolder sizzlingHot = FDAdvancementGenerator.getAdvancement(portableCooking, (ItemLike)ModItems.SKILLET.get(), "place_skillet", AdvancementType.TASK, true, false, false).addCriterion("skillet", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.SKILLET.get())).save(consumer, this.getNameId("main/place_skillet"));
        AdvancementHolder dinnerIsServed = FDAdvancementGenerator.getAdvancement(bonfireLit, (ItemLike)ModItems.COOKING_POT.get(), "place_cooking_pot", AdvancementType.GOAL, true, true, false).addCriterion("cooking_pot", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.COOKING_POT.get())).save(consumer, this.getNameId("main/place_cooking_pot"));
        AdvancementHolder comforting = FDAdvancementGenerator.getAdvancement(dinnerIsServed, (ItemLike)ModItems.BAKED_COD_STEW.get(), "eat_comfort_food", AdvancementType.TASK, true, false, false).addCriterion("comfort", EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(ModEffects.COMFORT))).save(consumer, this.getNameId("main/eat_comfort_food"));
        AdvancementHolder nourishing = FDAdvancementGenerator.getAdvancement(comforting, (ItemLike)ModItems.STEAK_AND_POTATOES.get(), "eat_nourishing_food", AdvancementType.TASK, true, false, false).addCriterion("nourishment", EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(ModEffects.NOURISHMENT))).save(consumer, this.getNameId("main/eat_nourishing_food"));
        AdvancementHolder gloriousFeast = FDAdvancementGenerator.getAdvancement(nourishing, (ItemLike)ModItems.ROAST_CHICKEN_BLOCK.get(), "place_feast", AdvancementType.TASK, true, true, false).addCriterion("roast_chicken", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.ROAST_CHICKEN_BLOCK.get())).addCriterion("stuffed_pumpkin", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.STUFFED_PUMPKIN_BLOCK.get())).addCriterion("honey_glazed_ham", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.HONEY_GLAZED_HAM_BLOCK.get())).addCriterion("shepherds_pie", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.SHEPHERDS_PIE_BLOCK.get())).addCriterion("rice_roll_medley", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)ModBlocks.RICE_ROLL_MEDLEY_BLOCK.get())).requirements(AdvancementRequirements.Strategy.OR).save(consumer, this.getNameId("main/place_feast"));
        AdvancementHolder masterChef = FDAdvancementGenerator.getAdvancement(gloriousFeast, (ItemLike)ModItems.HONEY_GLAZED_HAM.get(), "master_chef", AdvancementType.CHALLENGE, true, true, false).addCriterion("mixed_salad", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.MIXED_SALAD.get()))).addCriterion("cooked_rice", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.COOKED_RICE.get()))).addCriterion("bone_broth", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.BONE_BROTH.get()))).addCriterion("beef_stew", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.BEEF_STEW.get()))).addCriterion("vegetable_soup", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.VEGETABLE_SOUP.get()))).addCriterion("fish_stew", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.FISH_STEW.get()))).addCriterion("chicken_soup", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.CHICKEN_SOUP.get()))).addCriterion("fried_rice", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.FRIED_RICE.get()))).addCriterion("pumpkin_soup", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.PUMPKIN_SOUP.get()))).addCriterion("baked_cod_stew", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.BAKED_COD_STEW.get()))).addCriterion("noodle_soup", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.NOODLE_SOUP.get()))).addCriterion("bacon_and_eggs", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.BACON_AND_EGGS.get()))).addCriterion("ratatouille", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.RATATOUILLE.get()))).addCriterion("steak_and_potatoes", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.STEAK_AND_POTATOES.get()))).addCriterion("pasta_with_meatballs", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.PASTA_WITH_MEATBALLS.get()))).addCriterion("pasta_with_mutton_chop", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.PASTA_WITH_MUTTON_CHOP.get()))).addCriterion("mushroom_rice", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.MUSHROOM_RICE.get()))).addCriterion("roasted_mutton_chops", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.ROASTED_MUTTON_CHOPS.get()))).addCriterion("vegetable_noodles", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.VEGETABLE_NOODLES.get()))).addCriterion("squid_ink_pasta", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.SQUID_INK_PASTA.get()))).addCriterion("grilled_salmon", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.GRILLED_SALMON.get()))).addCriterion("roast_chicken", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.ROAST_CHICKEN.get()))).addCriterion("stuffed_pumpkin", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.STUFFED_PUMPKIN.get()))).addCriterion("honey_glazed_ham", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.HONEY_GLAZED_HAM.get()))).addCriterion("shepherds_pie", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)ModItems.SHEPHERDS_PIE.get()))).rewards(AdvancementRewards.Builder.experience((int)200)).save(consumer, this.getNameId("main/master_chef"));
    }

    protected static Advancement.Builder getAdvancement(AdvancementHolder parent, ItemLike display, String name, AdvancementType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.advancement().parent(parent).display(display, (Component)TextUtils.getTranslation("advancement." + name, new Object[0]), (Component)TextUtils.getTranslation("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
    }

    private String getNameId(String id) {
        return "farmersdelight:" + id;
    }
}

