/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.visuality.config.Config;
import plus.dragons.visuality.particle.type.ColorParticleType;
import plus.dragons.visuality.registry.VisualityParticles;

@Mixin(value={WaterFluid.class})
public class WaterFluidMixin {
    @Inject(method={"animateTick"}, at={@At(value="HEAD")})
    private void visuality$addWaterCircles(Level level, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        if (!((Boolean)Config.WATER_CIRCLE_ENABLED.get()).booleanValue()) {
            return;
        }
        int density = (Integer)Config.WATER_CIRCLE_DENSITY.get();
        if (random.nextInt(256) < density) {
            BlockPos above = pos.above();
            if (state.isSource() && level.isRainingAt(above)) {
                Biome biome = (Biome)level.getBiome(pos).value();
                int color = (Boolean)Config.WATER_CIRCLE_COLORED.get() != false ? biome.getWaterColor() : -1;
                level.addParticle((ParticleOptions)((ColorParticleType)((Object)VisualityParticles.WATER_CIRCLE.get())).withColor(color), (double)above.getX() + level.random.nextDouble(), (double)above.getY() - 0.1, (double)above.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }
}

