/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.tradecycling.mixin.MerchantMenuAccessor;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MerchantMenu;

public class CycleTradesButton
extends AbstractButton {
    private static final ResourceLocation ARROW_BUTTON = ResourceLocation.fromNamespaceAndPath((String)"trade_cycling", (String)"textures/cycle_trades.png");
    public static final int WIDTH = 18;
    public static final int HEIGHT = 14;
    private MerchantScreen screen;
    private Consumer<CycleTradesButton> onPress;

    public CycleTradesButton(int x, int y, Consumer<CycleTradesButton> onPress, MerchantScreen screen) {
        super(x, y, 18, 14, (Component)Component.empty());
        this.onPress = onPress;
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.visible = CycleTradesButton.canCycle((MerchantMenu)this.screen.getMenu());
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_BUTTON);
        if (this.isHovered) {
            guiGraphics.blit(ARROW_BUTTON, this.getX(), this.getY(), 0.0f, 14.0f, 18, 14, 32, 32);
            guiGraphics.renderTooltip(Minecraft.getInstance().font, Collections.singletonList(Component.translatable((String)"tooltip.trade_cycling.cycle_trades").getVisualOrderText()), mouseX, mouseY);
        } else {
            guiGraphics.blit(ARROW_BUTTON, this.getX(), this.getY(), 0.0f, 0.0f, 18, 14, 32, 32);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static boolean canCycle(MerchantMenu menu) {
        if (menu instanceof MerchantMenuAccessor) {
            MerchantMenuAccessor m = (MerchantMenuAccessor)menu;
            return menu.showProgressBar() && menu.getTraderXp() <= 0 && m.getTradeContainer().getActiveOffer() == null;
        }
        return false;
    }

    public void onPress() {
        this.onPress.accept(this);
    }
}

