/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.flamethrover;

import com.drmangotea.tfmg.TFMGClient;
import com.drmangotea.tfmg.base.spark.FireSpark;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGEntityTypes;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.item.CustomArmPoseItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FlamethrowerItem
extends Item
implements CustomArmPoseItem {
    public static final int FUEL_CAPACITY = 4000;

    public FlamethrowerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int time) {
        if (stack.get(TFMGDataComponents.AMOUNT) == null) {
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
        }
        FireSpark spark = (FireSpark)TFMGEntityTypes.SPARK.create(level);
        spark.setPos(entity.getX(), entity.getY() + (double)1.2f, entity.getZ());
        if ((Integer)stack.get(TFMGDataComponents.AMOUNT) == 0) {
            stack.set(TFMGDataComponents.FLAMETHROWER_FUEL, (Object)"");
            return;
        }
        level.playSound((Player)null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.NEUTRAL, 0.1f, 0.04f);
        FlamethrowerFuel fuel = Enum.valueOf(FlamethrowerFuel.class, ((String)stack.get(TFMGDataComponents.FLAMETHROWER_FUEL)).toUpperCase());
        for (int i = 0; i < fuel.amount; ++i) {
            if ((Integer)stack.get(TFMGDataComponents.AMOUNT) == 0) {
                stack.set(TFMGDataComponents.FLAMETHROWER_FUEL, (Object)"");
                return;
            }
            stack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)stack.get(TFMGDataComponents.AMOUNT) - 1));
            spark.shoot(entity.getLookAngle().x, entity.getLookAngle().y, entity.getLookAngle().z, fuel.speed, fuel.spread);
            level.addFreshEntity((Entity)spark);
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        if (stack.get(TFMGDataComponents.AMOUNT) == null) {
            return false;
        }
        return (Integer)stack.get(TFMGDataComponents.AMOUNT) != 0;
    }

    public int getBarColor(ItemStack stack) {
        return ((String)stack.get(TFMGDataComponents.FLAMETHROWER_FUEL)).isEmpty() ? 0xFFFFFF : Enum.valueOf(FlamethrowerFuel.class, (String)((String)stack.get(TFMGDataComponents.FLAMETHROWER_FUEL)).toUpperCase()).color;
    }

    public int getBarWidth(ItemStack stack) {
        if (stack.get(TFMGDataComponents.AMOUNT) == null) {
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
        }
        return Math.round(13.0f * ((float)((Integer)stack.get(TFMGDataComponents.AMOUNT)).intValue() / 4000.0f));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        if (level.isClientSide) {
            TFMGClient.FLAMETHROWER_RENDER_HANDLER.dontAnimateItem(hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        if (stack.get(TFMGDataComponents.FLAMETHROWER_FUEL) == null) {
            stack.set(TFMGDataComponents.FLAMETHROWER_FUEL, (Object)"");
        }
        if (stack.get(TFMGDataComponents.AMOUNT) == null) {
            stack.set(TFMGDataComponents.AMOUNT, (Object)0);
        }
        if (level.getBlockEntity(pos) != null && (blockEntity = level.getBlockEntity(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity fluidTankBe = (FluidTankBlockEntity)blockEntity;
            FluidTankBlockEntity be = fluidTankBe.isController() ? fluidTankBe : fluidTankBe.getControllerBE();
            for (FlamethrowerFuel fuel : FlamethrowerFuel.values()) {
                String fluid = be.getFluid(0).getFluid().getFluidType().toString().replaceFirst("tfmg:", "");
                if (!fluid.equals(fuel.name().toLowerCase()) || !((String)stack.get(TFMGDataComponents.FLAMETHROWER_FUEL)).equals(fluid) && (Integer)stack.get(TFMGDataComponents.AMOUNT) != 0) continue;
                int toDrain = Math.min(4000 - (Integer)stack.get(TFMGDataComponents.AMOUNT), be.getFluid(0).getAmount());
                stack.set(TFMGDataComponents.FLAMETHROWER_FUEL, (Object)fluid);
                be.getTankInventory().drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                stack.set(TFMGDataComponents.AMOUNT, (Object)((Integer)stack.get(TFMGDataComponents.AMOUNT) + toDrain));
                context.getPlayer().getCooldowns().addCooldown(stack.getItem(), 20);
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public HumanoidModel.ArmPose getArmPose(ItemStack stack, AbstractClientPlayer player, InteractionHand hand) {
        if (!player.swinging) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.NONE;
    }

    static enum FlamethrowerFuel {
        GASOLINE(15.0f, 1.0f, 3, 12888694),
        DIESEL(7.0f, 2.0f, 3, 12226935),
        KEROSENE(10.0f, 1.3f, 4, 7894741),
        NAPHTHA(20.0f, 0.8f, 1, 6167306),
        LPG(35.0f, 0.6f, 15, 14728008),
        NAPALM(20.0f, 1.8f, 15, 10733129),
        MOLTEN_SLAG(15.0f, 0.3f, 15, 16750113);

        public final float spread;
        public final float speed;
        public final int amount;
        public final int color;

        private FlamethrowerFuel(float spread, float speed, int amount, int color) {
            this.spread = spread;
            this.speed = speed;
            this.amount = amount;
            this.color = color;
        }
    }
}

