/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.segmented_display;

import com.drmangotea.tfmg.content.electricity.utilities.segmented_display.SegmentedDisplayBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SegmentedDisplayRenderer
extends SafeBlockEntityRenderer<SegmentedDisplayBlockEntity> {
    public static Map<String, List<Integer>> SYMBOLS_TO_SEGMENTS = new HashMap<String, List<Integer>>();

    public SegmentedDisplayRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(SegmentedDisplayBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        int i;
        BlockState blockState = be.getBlockState();
        VertexConsumer vb = bufferSource.getBuffer(RenderType.cutoutMipped());
        ms.pushPose();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        int color = be.color.getTextColor();
        for (i = 0; i < be.segmentsToRender.size(); ++i) {
            CachedBuffers.partialFacing((PartialModel)this.getSegment(be.segmentsToRender.get(i) - 10), (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).light(999999).color(color).renderInto(ms, vb);
        }
        for (i = 0; i < be.segmentsToRender2.size(); ++i) {
            CachedBuffers.partialFacing((PartialModel)this.getSegment(be.segmentsToRender2.get(i) - 10), (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite()).light(999999).color(color).renderInto(ms, vb);
        }
        ms.popPose();
    }

    public PartialModel getSegment(int id) {
        return TFMGPartialModels.SEGMENTS.get(Math.min(id, 20));
    }

    public static void put(int number, Integer ... segments) {
        SegmentedDisplayRenderer.put(String.valueOf(number), segments);
    }

    private static void put(String string, Integer ... segments) {
        SYMBOLS_TO_SEGMENTS.put(string, Arrays.asList(segments));
        ArrayList<Integer> segments2 = new ArrayList<Integer>();
        for (Integer segment : segments) {
            if (segment == 0) break;
            segments2.add(10 + segment);
        }
        SYMBOLS_TO_SEGMENTS.put(string, segments2);
    }

    static {
        SegmentedDisplayRenderer.put(0, 1, 2, 3, 5, 6, 7);
        SegmentedDisplayRenderer.put(1, 1, 2);
        SegmentedDisplayRenderer.put(2, 3, 6, 4, 2, 5);
        SegmentedDisplayRenderer.put(3, 3, 4, 5, 6, 7);
        SegmentedDisplayRenderer.put(4, 1, 4, 6, 7);
        SegmentedDisplayRenderer.put(5, 1, 3, 4, 5, 7);
        SegmentedDisplayRenderer.put(6, 1, 2, 3, 4, 5, 7);
        SegmentedDisplayRenderer.put(7, 7, 6, 3);
        SegmentedDisplayRenderer.put(8, 1, 2, 3, 4, 5, 6, 7);
        SegmentedDisplayRenderer.put(9, 1, 3, 4, 6, 7);
        SegmentedDisplayRenderer.put(":", 0);
        SegmentedDisplayRenderer.put("a", 1, 2, 3, 4, 6, 7);
        SegmentedDisplayRenderer.put("b", 1, 2, 4, 5, 7);
        SegmentedDisplayRenderer.put("c", 1, 2, 3, 5);
        SegmentedDisplayRenderer.put("d", 2, 4, 5, 6, 7);
        SegmentedDisplayRenderer.put("e", 1, 2, 3, 4, 5);
        SegmentedDisplayRenderer.put("f", 1, 2, 3, 4);
        SegmentedDisplayRenderer.put("g", 1, 2, 3, 5, 7);
        SegmentedDisplayRenderer.put("h", 1, 2, 4, 6, 7);
        SegmentedDisplayRenderer.put("i", 1, 2);
        SegmentedDisplayRenderer.put("j", 6, 7, 5, 2);
        SegmentedDisplayRenderer.put("k", 1, 2, 9, 10);
        SegmentedDisplayRenderer.put("l", 1, 2, 5);
        SegmentedDisplayRenderer.put("m", 1, 2, 6, 7, 8);
        SegmentedDisplayRenderer.put("n", 2, 7, 10);
        SegmentedDisplayRenderer.put("o", 1, 2, 6, 7, 3, 5);
        SegmentedDisplayRenderer.put("p", 1, 2, 3, 4, 6);
        SegmentedDisplayRenderer.put("q", 1, 3, 4, 6, 7);
        SegmentedDisplayRenderer.put("r", 1, 2, 3, 4, 6, 10);
        SegmentedDisplayRenderer.put("s", 1, 3, 4, 5, 7);
        SegmentedDisplayRenderer.put("t", 1, 2, 4, 5);
        SegmentedDisplayRenderer.put("u", 2, 5, 7);
        SegmentedDisplayRenderer.put("v", 1, 2, 5, 6, 7);
        SegmentedDisplayRenderer.put("w", 1, 2, 4, 5, 6, 7);
        SegmentedDisplayRenderer.put("x", 1, 2, 4, 6, 7);
        SegmentedDisplayRenderer.put("y", 1, 4, 6, 7, 5);
        SegmentedDisplayRenderer.put("z", 3, 9, 4);
    }
}

