/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.generators.creative_generator;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CreativeGeneratorBlockEntity
extends ElectricBlockEntity {
    protected ScrollValueBehaviour outputVoltage;

    public CreativeGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.outputVoltage = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"creative_generator.voltage_generation", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new CreativeGeneratorValueBox(this));
        this.outputVoltage.between(0, max);
        this.outputVoltage.value = 50;
        this.outputVoltage.withCallback(i -> CreativeGeneratorBlockEntity.update(this));
        behaviours.add((BlockEntityBehaviour)this.outputVoltage);
    }

    public static void update(CreativeGeneratorBlockEntity be) {
        be.updateNextTick();
    }

    @Override
    public int voltageGeneration() {
        return this.outputVoltage.getValue() * 10;
    }

    @Override
    public int powerGeneration() {
        return this.outputVoltage.getValue() * 100;
    }

    class CreativeGeneratorValueBox
    extends ValueBoxTransform.Sided {
        CreativeGeneratorValueBox(CreativeGeneratorBlockEntity this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }
    }
}

