/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.ConnectNeightborsPacket;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricNetworkManager;
import com.drmangotea.tfmg.content.electricity.base.ElectricalGroup;
import com.drmangotea.tfmg.content.electricity.base.ElectricalNetwork;
import com.drmangotea.tfmg.content.electricity.base.NetworkUpdatePacket;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IElectric {
    public long getPos();

    public LevelAccessor getLevelAccessor();

    default public boolean destroyed() {
        return this.getData().destroyed();
    }

    default public ElectricalNetwork getOrCreateElectricNetwork() {
        if (this.getLevelAccessor().getBlockEntity(BlockPos.of((long)this.getData().electricalNetworkId)) instanceof IElectric) {
            return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor((IElectric)this.getLevelAccessor().getBlockEntity(BlockPos.of((long)this.getData().electricalNetworkId)));
        }
        ElectricNetworkManager.networks.get(this.getLevelAccessor()).remove(this.getData().electricalNetworkId);
        return TFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
    }

    default public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    default public void onPlaced() {
        LevelAccessor levelAccessor = this.getLevelAccessor();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(BlockPos.of((long)this.getPos())), (CustomPacketPayload)new ConnectNeightborsPacket(BlockPos.of((long)this.getPos())));
        }
        ElectricalNetwork network = TFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
        this.setNetwork(this.getPos());
        this.getData().electricalNetworkId = this.getPos();
        network.add(this);
        this.getData().checkForLoopsNextTick = true;
        this.getOrCreateElectricNetwork().checkForLoops(BlockPos.of((long)this.getPos()));
        this.updateNextTick();
        this.onConnected();
        this.sendStuff();
    }

    default public void onRemoved() {
        this.getData().destroyed = true;
        for (Direction d : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().getBlockEntity(BlockPos.of((long)this.getPos()).relative(d))) instanceof IElectric) || !(be = (IElectric)blockEntity).hasElectricitySlot(d.getOpposite())) continue;
            ElectricNetworkManager.networks.get(this.getLevelAccessor()).remove(be.getPos());
            be.setNetwork(be.getPos());
            be.onPlaced();
            be.updateNextTick();
        }
        if (this.getData().electricalNetworkId != this.getPos()) {
            this.getOrCreateElectricNetwork().getMembers().remove(this);
        }
        if (this.getData().electricalNetworkId == this.getPos()) {
            ElectricNetworkManager.networks.get(this.getLevelAccessor()).remove(this.getData().getId());
        }
    }

    default public void readElectricity(CompoundTag compound, boolean clientPacket) {
        this.getData().group = new ElectricalGroup(compound.getInt("GroupId"));
        this.getData().group.resistance = compound.getFloat("GroupResistance");
        if (!clientPacket) {
            this.getData().connectNextTick = true;
        }
    }

    default public void writeElectricity(CompoundTag compound, boolean clientPacket) {
        compound.putInt("GroupId", this.getData().group.id);
        compound.putFloat("GroupResistance", this.getData().group.resistance);
    }

    default public void tickElectricity() {
        if (this.getData().checkForLoopsNextTick) {
            this.getOrCreateElectricNetwork().checkForLoops(this.getBlockPos());
            this.getData().checkForLoopsNextTick = false;
        }
        if (this.getData().connectNextTick) {
            this.onPlaced();
            this.getData().connectNextTick = false;
        }
        if (this.getData().updateNextTick) {
            this.updateNetwork();
            this.getData().updateNextTick = false;
        }
        if (this.getData().updatePowerNextTick) {
            this.updateUnpowered(new ArrayList<BlockPos>());
            this.getData().updatePowerNextTick = false;
        }
        if (this.getData().setVoltageNextTick) {
            this.setVoltage(this.getData().voltageSupply);
            this.getData().setVoltageNextTick = false;
        }
    }

    default public void lazyTickElectricity() {
        if (this.getData().failTimer >= 4) {
            this.blockFail();
            this.getData().failTimer = 0;
            this.sendStuff();
        } else if (this.getData().voltage > this.getMaxVoltage() && this.getMaxVoltage() > 0 || this.getCurrent() > (float)this.getMaxCurrent() && this.getMaxCurrent() > 0) {
            ++this.getData().failTimer;
        }
    }

    default public int getMaxVoltage() {
        return 0;
    }

    default public int getMaxCurrent() {
        return 0;
    }

    default public void onConnected() {
        BlockPos pos = BlockPos.of((long)this.getPos());
        for (Direction d : Direction.values()) {
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().getBlockEntity(pos.relative(d))) instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be.hasElectricitySlot(d.getOpposite())) {
                if (be.destroyed()) continue;
                this.getOrCreateElectricNetwork().add(be);
                if (be.getData().getId() == this.getData().getId()) continue;
                be.setNetwork(this.getData().getId());
                be.onConnected();
                if (this.getLevelAccessor().isClientSide()) continue;
                this.sendStuff();
                continue;
            }
            if (be.getData().getId() == this.getData().getId()) continue;
            be.updateNextTick();
        }
        this.sendStuff();
    }

    default public BlockPos getBlockPos() {
        return BlockPos.of((long)this.getPos());
    }

    default public void updateUnpowered(List<BlockPos> alreadyChecked) {
        alreadyChecked.add(BlockPos.of((long)this.getPos()));
        this.updateNextTick();
        IElectric iElectric = this;
        if (iElectric instanceof CableConnectorBlockEntity) {
            CableConnectorBlockEntity connectorBE = (CableConnectorBlockEntity)iElectric;
            for (CableConnection connection : connectorBE.connections) {
                CableConnectorBlockEntity be2;
                BlockEntity blockEntity = this.getLevelAccessor().getBlockEntity(connection.blockPos1);
                if (!(blockEntity instanceof CableConnectorBlockEntity) || alreadyChecked.contains(BlockPos.of((long)(be2 = (CableConnectorBlockEntity)blockEntity).getPos()))) continue;
                be2.updateUnpowered(alreadyChecked);
            }
        }
        for (Direction direction : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity = this.getLevelAccessor().getBlockEntity(BlockPos.of((long)this.getPos()).relative(direction));
            if (!(blockEntity instanceof IElectric) || alreadyChecked.contains(BlockPos.of((long)(be = (IElectric)blockEntity).getPos()))) continue;
            be.updateUnpowered(alreadyChecked);
        }
    }

    default public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"multimeter.header", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        if (this.getData().notEnoughtPower) {
            CreateLang.text((String)"NOT ENOUGHT POWER").color(Color.RED).forGoggles(tooltip, 1);
        }
        if (this.voltageGeneration() > 0) {
            CreateLang.translate((String)"multimeter.power_generated", (Object[])new Object[0]).add(Component.literal((String)TFMGUtils.formatUnits(this.powerGeneration(), "W"))).color(8728138).forGoggles(tooltip, 1);
            CreateLang.translate((String)"multimeter.voltage_generated", (Object[])new Object[0]).add(Component.literal((String)TFMGUtils.formatUnits(this.voltageGeneration(), "V"))).color(1210265).forGoggles(tooltip, 1);
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
        }
        CreateLang.text((String)("   R = " + TFMGUtils.formatUnits(this.voltageGeneration() > 0 ? (double)this.getGeneratorResistance() : (double)this.resistance(), "\u03a9"))).color(13207913).forGoggles(tooltip, 1);
        CreateLang.text((String)("   U = " + TFMGUtils.formatUnits(this.getData().getVoltage(), "V"))).color(0x4BBBCC).forGoggles(tooltip, 1);
        CreateLang.text((String)("   I = " + TFMGUtils.formatUnits(this.getCurrent(), "A"))).color(2269510).forGoggles(tooltip, 1);
        CreateLang.text((String)("   P = " + TFMGUtils.formatUnits(this.getPowerUsage(), "W"))).color(13388660).forGoggles(tooltip, 1);
        if (this.getData().group.id != -1) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.translate((String)"multimeter.group", (Object[])new Object[0]).add(CreateLang.number((double)this.getData().group.id)).color(14211879).forGoggles(tooltip, 1);
        }
        if (isPlayerSneaking) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.text((String)("Network Power Generation: " + TFMGUtils.formatUnits(this.getNetworkPowerGeneration(), "W"))).color(13388660).forGoggles(tooltip, 1);
            CreateLang.text((String)("Network Power Consumption: " + TFMGUtils.formatUnits(this.getNetworkPowerUsage(), "W"))).color(13388660).forGoggles(tooltip, 1);
        }
        return true;
    }

    default public void updateNearbyNetworks(IElectric member) {
    }

    public ElectricBlockValues getData();

    default public boolean canWork() {
        return !this.getData().notEnoughtPower;
    }

    default public void blockFail() {
        this.getLevelAccessor().destroyBlock(BlockPos.of((long)this.getPos()), false);
    }

    default public int getPowerUsage() {
        return (int)((float)this.getData().getVoltage() * this.getCurrent());
    }

    default public int getNetworkPowerUsage(IElectric blocked) {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (member.getPos() != blocked.getPos()) {
                power += member.getPowerUsage();
                continue;
            }
            blocked.updateNextTick();
        }
        return power;
    }

    default public int getNetworkPowerUsage() {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            power += member.getPowerUsage();
        }
        return power;
    }

    default public int getNetworkPowerGeneration() {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            power += member.powerGeneration();
        }
        return power;
    }

    default public void onNetworkChanged(int oldVoltage, int oldPower) {
    }

    default public float getGeneratorResistance() {
        if (this.getData().voltageSupply == 0) {
            return 0.0f;
        }
        if ((float)this.getData().networkPowerGeneration * (float)this.getNetworkResistance() == 0.0f) {
            return 0.0f;
        }
        return (float)this.powerGeneration() / (float)this.getData().networkPowerGeneration * (float)this.getNetworkResistance();
    }

    default public float getGeneratorLoad() {
        if (this.getNetworkPowerUsage() == 0) {
            return 0.0f;
        }
        return (float)this.powerGeneration() / (float)this.getData().networkPowerGeneration * (float)this.getNetworkPowerUsage();
    }

    default public float resistance() {
        return 0.0f;
    }

    default public int voltageGeneration() {
        int voltageGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(direction))) instanceof VoltageAlteringBlockEntity) || (be = (VoltageAlteringBlockEntity)blockEntity).getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction)) continue;
            voltageGeneration = Math.max(voltageGeneration, be.getOutputVoltage());
            this.getData().getsOutsidePower = true;
        }
        if (voltageGeneration == 0) {
            this.getData().getsOutsidePower = false;
        }
        return voltageGeneration;
    }

    default public int powerGeneration() {
        int powerGeneration = 0;
        for (Direction direction : Direction.values()) {
            VoltageAlteringBlockEntity be;
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(direction) || !((blockEntity = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(direction))) instanceof VoltageAlteringBlockEntity) || !(be = (VoltageAlteringBlockEntity)blockEntity).canWork() || be.getData().getId() == this.getData().getId() || be.getData().getVoltage() == 0 || !be.hasElectricitySlot(direction) || (powerGeneration = Math.max(powerGeneration, be.getPowerUsage()) + 1) <= be.getNetworkPowerGeneration()) continue;
            powerGeneration = 0;
            be.data.updatePowerNextTick = true;
        }
        return powerGeneration;
    }

    default public int getNetworkResistance() {
        return this.getData().networkResistance;
    }

    default public boolean networkUndersupplied() {
        return this.getNetworkPowerUsage() > this.getData().networkPowerGeneration;
    }

    default public int getMaxAmps() {
        return (int)this.getCurrent();
    }

    default public float getCurrent() {
        return this.getData().getVoltage() == 0 || this.resistance() == 0.0f ? 0.0f : (float)this.getData().getVoltage() / this.resistance();
    }

    default public void updateNextTick() {
        this.getData().updateNextTick = true;
    }

    default public void updateNetwork() {
        this.getOrCreateElectricNetwork().updateNetwork();
        LevelAccessor levelAccessor = this.getLevelAccessor();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new NetworkUpdatePacket(BlockPos.of((long)this.getPos())));
        }
        this.sendStuff();
    }

    public void sendStuff();

    default public void setVoltage(int newVoltage) {
        if (this.canBeInGroups()) {
            this.getData().voltage = (int)(this.resistance() / this.getData().group.resistance * (float)this.getData().voltageSupply);
            return;
        }
        this.getData().voltage = newVoltage;
    }

    default public void setNetworkResistance(int newUsage) {
        this.getData().networkResistance = newUsage;
    }

    default public void setNetwork(long network) {
        this.getData().electricalNetworkId = network;
        if (network != this.getPos()) {
            ElectricNetworkManager.networks.get(this.getLevelAccessor()).remove(this.getPos());
        }
    }

    default public boolean canBeInGroups() {
        return false;
    }
}

