/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBuntingBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BuntingItem
extends StandingAndWallBlockItem
implements IColored {
    private final DyeColor dyeColor;

    public BuntingItem(DyeColor color, Block block, Block wallBlock, Item.Properties properties, Direction attachmentDirection) {
        super(block, wallBlock, properties, attachmentDirection);
        this.dyeColor = color;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.bunting").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockHitResult hit;
        BlockState s;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.is((Block)ModRegistry.ROPE.get()) && (s = RopeBuntingBlock.fromRope(state, hit = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), pos, false))) != null) {
            level.setBlockAndUpdate(pos, s);
            ItemInteractionResult ret = s.useItemOn(context.getItemInHand(), level, context.getPlayer(), context.getHand(), hit);
            if (!ret.consumesAction()) {
                level.setBlockAndUpdate(pos, state);
            } else {
                return ret.result();
            }
        }
        return super.useOn(context);
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }
}

