/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import java.util.EnumSet;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FodderBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.Vec3;

public class EatFodderGoal
extends MoveToBlockGoal {
    private final Animal animal;
    private final int blockBreakingTime;
    private int ticksSinceReachedGoal;
    protected int lastBreakProgress = -1;
    private static final BlockState FODDER_STATE = ModRegistry.FODDER.get().defaultBlockState();

    public EatFodderGoal(Animal entity, double speedModifier, int searchRange, int verticalSearchRange, int breakTime) {
        super((PathfinderMob)entity, speedModifier, searchRange, verticalSearchRange);
        this.animal = entity;
        this.blockBreakingTime = breakTime;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.animal.canFallInLove() || this.animal.getAge() > 0) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.blockPos != BlockPos.ZERO && !ForgeHelper.canEntityDestroy((Level)this.animal.level(), (BlockPos)this.blockPos, (Animal)this.animal)) {
            return false;
        }
        if (this.tryFindBlock()) {
            this.nextStartTick = 600;
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    public boolean canContinueToUse() {
        return this.tryTicks >= -100 && this.tryTicks <= 200 && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos);
    }

    private boolean tryFindBlock() {
        return this.blockPos != BlockPos.ZERO && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos) || this.findNearestBlock();
    }

    protected int nextStartTick(PathfinderMob pCreature) {
        return 800 + pCreature.getRandom().nextInt(400);
    }

    public void stop() {
        super.stop();
        this.animal.fallDistance = 1.0f;
        this.blockPos = BlockPos.ZERO;
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public double acceptedDistance() {
        return 1.5;
    }

    public void tick() {
        super.tick();
        Level level = this.animal.level();
        RandomSource random = this.animal.getRandom();
        if (this.isReachedTarget()) {
            int k;
            --this.tryTicks;
            BlockPos targetPos = this.getMoveToTarget().below();
            Vec3 vector3d = Vec3.atBottomCenterOf((Vec3i)targetPos);
            this.mob.getLookControl().setLookAt(vector3d.x(), vector3d.y(), vector3d.z());
            if (this.ticksSinceReachedGoal > 0 && level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (this.ticksSinceReachedGoal % 2 == 0) {
                    sl.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, FODDER_STATE), (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.7, (double)targetPos.getZ() + 0.5, 3, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, ((double)random.nextFloat() - 0.5) * 0.08, (double)0.15f);
                }
            }
            if (this.ticksSinceReachedGoal == 1 && this.animal instanceof Sheep) {
                level.broadcastEntityEvent((Entity)this.mob, (byte)10);
            }
            if ((k = (int)((float)this.ticksSinceReachedGoal / (float)this.blockBreakingTime * 10.0f)) != this.lastBreakProgress) {
                level.destroyBlockProgress(this.mob.getId(), this.blockPos, k);
                this.lastBreakProgress = k;
            }
            if (this.ticksSinceReachedGoal > this.blockBreakingTime) {
                BlockState state = level.getBlockState(targetPos);
                if (state.is(ModRegistry.FODDER.get())) {
                    int layers = (Integer)state.getValue((Property)FodderBlock.LAYERS);
                    if (layers > 1) {
                        level.levelEvent(2001, targetPos, Block.getId((BlockState)FODDER_STATE));
                        level.setBlock(targetPos, (BlockState)FODDER_STATE.setValue((Property)FodderBlock.LAYERS, (Comparable)Integer.valueOf(layers - 1)), 2);
                    } else {
                        level.destroyBlock(targetPos, false);
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)level;
                        sl.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.animal.getX(), this.animal.getY(), this.animal.getZ(), 5, (double)(this.animal.getBbWidth() / 2.0f), (double)(this.animal.getBbHeight() / 2.0f), (double)(this.animal.getBbWidth() / 2.0f), 0.0);
                    }
                    if (!this.animal.isBaby()) {
                        this.animal.setInLove(null);
                    }
                    this.animal.ate();
                }
                this.nextStartTick = this.nextStartTick(this.mob);
                this.tryTicks = 800;
            }
            ++this.ticksSinceReachedGoal;
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        ChunkAccess chunk = world.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()), ChunkStatus.FULL, false);
        if (chunk == null) {
            return false;
        }
        return chunk.getBlockState(pos).is(ModRegistry.FODDER.get()) && chunk.getBlockState(pos.above()).isAir();
    }
}

