/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.dispenser;

import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

abstract class ProjectileBehavior
extends DispenserHelper.AdditionalDispenserBehavior {
    protected ProjectileBehavior(Item item) {
        super(item);
    }

    protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
        ServerLevel world = source.level();
        Position dispensePosition = DispenserBlock.getDispensePosition((BlockSource)source);
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        BlockPos frontPos = source.pos().relative(direction);
        if (!world.getBlockState(frontPos).getCollisionShape((BlockGetter)world, frontPos).isEmpty()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        Projectile projectileEntity = this.getProjectileEntity(source, dispensePosition, stack);
        projectileEntity.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
        world.addFreshEntity((Entity)projectileEntity);
        stack.shrink(1);
        return InteractionResultHolder.success((Object)stack);
    }

    protected void playSound(BlockSource source, boolean success) {
        Vec3 center = source.center();
        source.level().playSound(null, center.x() + 0.5, center.y() + 0.5, center.z() + 0.5, this.getSound(), SoundSource.NEUTRAL, 0.5f, 0.4f / (source.level().getRandom().nextFloat() * 0.4f + 0.8f));
    }

    protected abstract SoundEvent getSound();

    protected abstract Projectile getProjectileEntity(BlockSource var1, Position var2, ItemStack var3);

    protected float getProjectileInaccuracy() {
        return 6.0f;
    }

    protected float getProjectileVelocity() {
        return 1.1f;
    }
}

