/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.utils.RopeHelper;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.DecoBlocksCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractRopeBlock
extends WaterBlock
implements IRopeConnection {
    public static final VoxelShape COLLISION_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    public static final BooleanProperty KNOT = ModBlockProperties.KNOT;
    private final Map<BlockState, VoxelShape> shapes;

    public AbstractRopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)KNOT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes.getOrDefault(state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.block());
    }

    protected abstract Map<BlockState, VoxelShape> makeShapes();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, KNOT});
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return this.hasConnection(Direction.DOWN, state) && (this.hasConnection(Direction.UP, state) || entity.position().y() - (double)pos.getY() < 0.8125);
    }

    public abstract boolean hasConnection(Direction var1, BlockState var2);

    public abstract BlockState setConnection(Direction var1, BlockState var2, boolean var3);

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        if (!CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return Shapes.empty();
        }
        return !this.hasConnection(Direction.UP, state) && (context.isAbove(COLLISION_SHAPE, pos, true) || !this.hasConnection(Direction.DOWN, state)) || !(context instanceof EntityCollisionContext) || !((ec = (EntityCollisionContext)context).getEntity() instanceof LivingEntity) ? this.getShape(state, worldIn, pos, context) : Shapes.empty();
    }

    public boolean shouldConnectToDir(BlockState thisState, BlockPos currentPos, LevelReader world, Direction dir) {
        if (dir.getAxis().isHorizontal() && !CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            return false;
        }
        BlockPos facingPos = currentPos.relative(dir);
        return this.shouldConnectToFace(thisState, world.getBlockState(facingPos), facingPos, dir, world);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!worldIn.isClientSide()) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        if (facing == Direction.UP) {
            stateIn = this.setConnection(Direction.DOWN, stateIn, this.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, Direction.DOWN));
        }
        stateIn = this.setConnection(facing, stateIn, this.shouldConnectToDir(stateIn, currentPos, (LevelReader)worldIn, facing));
        if (facing == Direction.DOWN && !worldIn.isClientSide() && CompatHandler.DECO_BLOCKS) {
            DecoBlocksCompat.tryConvertingRopeChandelier(facingState, worldIn, facingPos);
        }
        return (BlockState)stateIn.setValue((Property)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(stateIn)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        boolean hasWater = context.getLevel().getFluidState(pos).getType() == Fluids.WATER;
        BlockState state = this.defaultBlockState();
        for (Direction dir : Direction.values()) {
            state = this.setConnection(dir, state, this.shouldConnectToDir(state, pos, (LevelReader)world, dir));
        }
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (BlockState)state.setValue((Property)KNOT, (Comparable)Boolean.valueOf(this.hasMiddleKnot(state)));
        return state;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.isClientSide) {
            worldIn.scheduleTick(pos, (Block)this, 1);
            if (CompatHandler.DECO_BLOCKS) {
                BlockPos down = pos.below();
                DecoBlocksCompat.tryConvertingRopeChandelier(worldIn.getBlockState(down), (LevelAccessor)worldIn, down);
            }
        }
    }

    public boolean hasMiddleKnot(BlockState state) {
        boolean up = this.hasConnection(Direction.UP, state);
        boolean down = this.hasConnection(Direction.DOWN, state);
        boolean north = this.hasConnection(Direction.NORTH, state);
        boolean east = this.hasConnection(Direction.EAST, state);
        boolean south = this.hasConnection(Direction.SOUTH, state);
        boolean west = this.hasConnection(Direction.WEST, state);
        return !(up && down && !north && !south && !east && !west || !up && !down && north && south && !east && !west || !up && !down && !north && !south && east && west);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.mutable().move(Direction.UP);
        BlockState upstate = world.getBlockState((BlockPos)mutable);
        if (upstate.is((Block)this)) {
            return true;
        }
        if (IRopeConnection.isSupportingCeiling((BlockPos)mutable, world)) {
            return true;
        }
        if (CommonConfigs.Functional.ROPE_HORIZONTAL.get().booleanValue()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos.MutableBlockPos facingPos = mutable.setWithOffset((Vec3i)pos, direction);
                BlockState sideState = world.getBlockState((BlockPos)facingPos);
                Block b = sideState.getBlock();
                if (b instanceof AbstractRopeBlock) {
                    return true;
                }
                if (!this.shouldConnectToFace(this.defaultBlockState(), sideState, (BlockPos)facingPos, direction, world)) continue;
                return true;
            }
        }
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
            return;
        }
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || !level.getBlockState(pos.relative(dir)).is(BlockTags.FIRE)) continue;
            level.scheduleTick(pos.relative(dir), Blocks.FIRE, 2 + level.random.nextInt(1));
            for (Direction d2 : Direction.Plane.HORIZONTAL) {
                BlockPos fp = pos.relative(d2);
                if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)fp, (Direction)d2.getOpposite())) continue;
                BlockState fireState = BaseFireBlock.getState((BlockGetter)level, (BlockPos)fp);
                if (fireState.hasProperty((Property)FireBlock.AGE)) {
                    fireState = (BlockState)fireState.setValue((Property)FireBlock.AGE, (Comparable)Integer.valueOf(14));
                }
                level.setBlockAndUpdate(fp, fireState);
                level.scheduleTick(pos.relative(dir), Blocks.FIRE, 2 + level.random.nextInt(1));
            }
            return;
        }
    }

    private static boolean findConnectedPulley(Level world, BlockPos pos, Player player, int it, Rotation rot) {
        if (it > 64) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        Block b = state.getBlock();
        if (b instanceof AbstractRopeBlock) {
            return AbstractRopeBlock.findConnectedPulley(world, pos.above(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock) {
            PulleyBlock pulley = (PulleyBlock)b;
            if (it != 0) {
                return pulley.windPulley(state, pos, (LevelAccessor)world, rot, null);
            }
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item i = stack.getItem();
        if (i == this.asItem()) {
            if (hit.getDirection().getAxis() == Direction.Axis.Y || this.hasConnection(Direction.DOWN, state)) {
                if (this.hasConnection(Direction.UP, state) && !this.hasConnection(Direction.DOWN, state)) {
                    state = this.setConnection(Direction.DOWN, state, true);
                    level.setBlock(pos, state, 0);
                }
                if (RopeHelper.addRopeDown(pos.below(), level, player, hand, (Block)this)) {
                    SoundType soundtype = state.getSoundType();
                    level.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.isEmpty()) {
            if (this.hasConnection(Direction.UP, state) && AbstractRopeBlock.findConnectedPulley(level, pos, player, 0, player.isShiftKeyDown() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && level.getBlockState(pos.below()).getBlock() == this && RopeHelper.removeRopeDown(pos.below(), level, (Block)this)) {
                level.playSound(player, pos, SoundEvents.LEASH_KNOT_PLACE, SoundSource.BLOCKS, 1.0f, 0.6f);
                if (!player.getAbilities().instabuild) {
                    Utils.addStackToExisting((Player)player, (ItemStack)new ItemStack((ItemLike)this), (boolean)true);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else if (i instanceof ShearsItem && this.hasConnection(Direction.DOWN, state)) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.SNOW_GOLEM_SHEAR, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 0.8f, 1.3f);
                BlockState newState = (BlockState)this.setConnection(Direction.DOWN, state, false).setValue((Property)KNOT, (Comparable)Boolean.valueOf(true));
                level.setBlock(pos, newState, 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        super.entityInside(state, worldIn, pos, entityIn);
        if (entityIn instanceof Arrow && !worldIn.isClientSide) {
            worldIn.destroyBlock(pos, true, entityIn);
            worldIn.playSound(null, pos, SoundEvents.LEASH_KNOT_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean skipRendering(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        return pAdjacentBlockState.is((Block)this) || super.skipRendering(pState, pAdjacentBlockState, pSide);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.SOUTH, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.WEST, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.NORTH, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.EAST, state));
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.EAST, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.SOUTH, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.WEST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.NORTH, state));
            }
            case Rotation.CLOCKWISE_90 -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.WEST, state));
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.NORTH, state));
                state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.EAST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.SOUTH, state));
            }
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> {
                state = this.setConnection(Direction.NORTH, state, this.hasConnection(Direction.SOUTH, state));
                yield state = this.setConnection(Direction.SOUTH, state, this.hasConnection(Direction.NORTH, state));
            }
            case Mirror.FRONT_BACK -> {
                state = this.setConnection(Direction.EAST, state, this.hasConnection(Direction.WEST, state));
                yield state = this.setConnection(Direction.WEST, state, this.hasConnection(Direction.EAST, state));
            }
            default -> super.mirror(state, mirror);
        };
    }

    @Override
    public boolean canSideAcceptConnection(BlockState state, Direction direction) {
        return true;
    }
}

