/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.parser;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.styledchat.StyledChatUtils;
import eu.pb4.styledchat.config.ChatStyle;
import eu.pb4.styledchat.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public record LinkParser(TextNode style) implements NodeParser
{
    public TextNode[] parseNodes(TextNode node) {
        if (node instanceof LiteralNode) {
            String restOfText;
            LiteralNode literalNode = (LiteralNode)node;
            String input = literalNode.value();
            ArrayList<Object> list = new ArrayList<Object>();
            Matcher matcher = StyledChatUtils.URL_REGEX.matcher(input);
            int currentPos = 0;
            int currentEnd = input.length();
            while (matcher.find() && currentEnd > matcher.start()) {
                String betweenText = input.substring(currentPos, matcher.start());
                if (!betweenText.isEmpty()) {
                    list.add(new LiteralNode(betweenText));
                }
                String link = matcher.group();
                Component text = this.style.toText(ParserContext.of(ChatStyle.DYN_KEY, Map.of("url", Component.literal((String)link), "link", Component.literal((String)link))::get));
                list.add(new DirectTextNode((Component)Component.empty().append(text).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link)))));
                currentPos = matcher.end();
            }
            if (currentPos < currentEnd && !(restOfText = input.substring(currentPos, currentEnd)).isEmpty()) {
                list.add(new LiteralNode(restOfText));
            }
            return list.toArray(new TextNode[0]);
        }
        if (node instanceof ParentNode) {
            ParentNode parentNode = (ParentNode)node;
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (TextNode child : parentNode.getChildren()) {
                list.addAll(List.of(this.parseNodes(child)));
            }
            return new TextNode[]{parentNode.copyWith(list.toArray(new TextNode[0]))};
        }
        return new TextNode[]{node};
    }

    public static TextNode[] parse(TextNode node, PlaceholderContext context) {
        return new LinkParser(ConfigManager.getConfig().getLinkStyle(context)).parseNodes(node);
    }
}

