/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.other;

import eu.pb4.styledchat.StyledChatMod;
import eu.pb4.styledchat.StyledChatStyles;
import eu.pb4.styledchat.StyledChatUtils;
import eu.pb4.styledchat.ducks.ExtPlayNetworkHandler;
import eu.pb4.styledchat.ducks.ExtSignedMessage;
import eu.pb4.styledchat.other.ExtendedSentMessage;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.mutable.MutableObject;

public interface StyledChatSentMessage
extends OutgoingChatMessage,
ExtendedSentMessage {
    public Component override();

    public PlayerChatMessage message();

    public StyledChatSentMessage reformat(ChatType.Bound var1, ResourceKey<ChatType> var2);

    public ResourceKey<ChatType> sourceType();

    @Override
    default public PlayerChatMessage styledChat$message() {
        return this.message();
    }

    public record System(PlayerChatMessage message, Component override, ChatType.Bound parameters, ResourceKey<ChatType> sourceType, MutableObject<ChatType.Bound> colorless) implements StyledChatSentMessage
    {
        public Component content() {
            return this.message.decoratedContent();
        }

        public void sendToPlayer(ServerPlayer receiver, boolean filterMaskEnabled, ChatType.Bound params) {
            ResourceLocation id = receiver.server.registryAccess().registryOrThrow(Registries.CHAT_TYPE).getKey((Object)((ChatType)params.chatType().value()));
            boolean color = ((ExtPlayNetworkHandler)receiver.connection).styledChat$chatColors();
            if (!color && this.colorless.getValue() == null) {
                this.colorless.setValue((Object)StyledChatUtils.removeColor(this.parameters));
            }
            if (this.sourceType == null || Objects.equals(id, this.sourceType.location())) {
                receiver.connection.sendDisguisedChatMessage(this.message.decoratedContent(), color ? this.parameters : (ChatType.Bound)this.colorless.getValue());
            } else {
                Component baseInput = ExtSignedMessage.getArg(this.message, "base_input");
                CommandSourceStack source = ExtSignedMessage.of(this.message).styledChat_getSource();
                Component input = baseInput != StyledChatUtils.EMPTY_TEXT && baseInput.getContents() != PlainTextContents.EMPTY ? baseInput : this.message.decoratedContent();
                Component text = StyledChatStyles.getCustom(id, params.name(), input, params.targetName().orElse(null), source != null ? source : StyledChatMod.server.createCommandSourceStack());
                if (!color) {
                    text = StyledChatUtils.removeColor(text);
                }
                receiver.connection.sendDisguisedChatMessage(this.message.decoratedContent(), StyledChatUtils.createParameters(text));
            }
        }

        @Override
        public StyledChatSentMessage reformat(ChatType.Bound pars, ResourceKey<ChatType> sourceType) {
            return new Chat(this.message, this.override, pars, sourceType, (MutableObject<ChatType.Bound>)new MutableObject());
        }
    }

    public record Chat(PlayerChatMessage message, Component override, ChatType.Bound parameters, ResourceKey<ChatType> sourceType, MutableObject<ChatType.Bound> colorless) implements StyledChatSentMessage
    {
        public Component content() {
            return this.message.decoratedContent();
        }

        public void sendToPlayer(ServerPlayer receiver, boolean filterMaskEnabled, ChatType.Bound params) {
            PlayerChatMessage signedMessage = this.message.filter(filterMaskEnabled);
            boolean color = ((ExtPlayNetworkHandler)receiver.connection).styledChat$chatColors();
            if (!color && this.colorless.getValue() == null) {
                this.colorless.setValue((Object)StyledChatUtils.removeColor(this.parameters));
            }
            if (!signedMessage.isFullyFiltered()) {
                ResourceLocation id = receiver.server.registryAccess().registryOrThrow(Registries.CHAT_TYPE).getKey((Object)((ChatType)params.chatType().value()));
                if (this.sourceType == null || Objects.equals(id, this.sourceType.location())) {
                    receiver.connection.sendPlayerChatMessage(signedMessage, color ? this.parameters : (ChatType.Bound)this.colorless.getValue());
                } else {
                    Component baseInput = ExtSignedMessage.getArg(signedMessage, "base_input");
                    CommandSourceStack source = ExtSignedMessage.of(signedMessage).styledChat_getSource();
                    Component input = baseInput != StyledChatUtils.EMPTY_TEXT && baseInput.getContents() != PlainTextContents.EMPTY ? baseInput : signedMessage.decoratedContent();
                    Component text = StyledChatStyles.getCustom(id, params.name(), input, params.targetName().orElse(null), source != null ? source : StyledChatMod.server.createCommandSourceStack());
                    if (!color) {
                        text = StyledChatUtils.removeColor(text);
                    }
                    receiver.connection.sendPlayerChatMessage(signedMessage, ChatType.bind(StyledChatMod.MESSAGE_TYPE_ID, (RegistryAccess)receiver.server.registryAccess(), (Component)text));
                }
            }
        }

        @Override
        public StyledChatSentMessage reformat(ChatType.Bound pars, ResourceKey<ChatType> sourceType) {
            return new Chat(this.message, this.override, pars, sourceType, (MutableObject<ChatType.Bound>)new MutableObject());
        }
    }
}

