/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.other;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModContainer;

public class GenericModInfo {
    private static Component[] icon = new Component[0];
    private static Component[] about = new Component[0];
    private static Component[] consoleAbout = new Component[0];

    public static void build(ModContainer container) {
        boolean useIcon = true;
        String chr = "\u2588";
        ArrayList<MutableComponent> icon = new ArrayList<MutableComponent>();
        try {
            BufferedImage source = ImageIO.read(Objects.requireNonNull(GenericModInfo.class.getResourceAsStream("/assets/icon_small.png")));
            for (int y = 0; y < source.getHeight(); ++y) {
                MutableComponent base = Component.literal((String)"");
                int line = 0;
                int color = source.getRGB(0, y) & 0xFFFFFF;
                for (int x = 0; x < source.getWidth(); ++x) {
                    int colorPixel = source.getRGB(x, y) & 0xFFFFFF;
                    if (color == colorPixel) {
                        ++line;
                        continue;
                    }
                    base.append((Component)Component.literal((String)"\u2588".repeat(line)).setStyle(Style.EMPTY.withColor(color)));
                    color = colorPixel;
                    line = 1;
                }
                base.append((Component)Component.literal((String)"\u2588".repeat(line)).setStyle(Style.EMPTY.withColor(color)));
                icon.add(base);
            }
        }
        catch (Throwable e) {
            useIcon = false;
            e.printStackTrace();
            while (icon.size() < 16) {
                icon.add(Component.literal((String)"/!\\ [ Invalid icon file ] /!\\").setStyle(Style.EMPTY.withColor(0xFF0000).withItalic(Boolean.valueOf(true))));
            }
        }
        GenericModInfo.icon = icon.toArray(new Component[0]);
        ArrayList<MutableComponent> about = new ArrayList<MutableComponent>();
        ArrayList<Object> aboutBasic = new ArrayList<Object>();
        ArrayList<Object> output = new ArrayList<Object>();
        try {
            about.add(Component.literal((String)container.getModInfo().getDisplayName()).setStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withBold(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/LostPattern/StyledChat"))));
            about.add(Component.translatable((String)"Version: ").setStyle(Style.EMPTY.withColor(16245159)).append((Component)Component.literal((String)container.getModInfo().getVersion().toString()).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE))));
            aboutBasic.addAll(about);
            aboutBasic.add(Component.empty());
            aboutBasic.add(Component.nullToEmpty((String)container.getModInfo().getDescription()));
            ArrayList<String> contributors = new ArrayList<String>();
            contributors.add((String)container.getModInfo().getConfig().getConfigElement(new String[]{"authors"}).get());
            about.add(Component.literal((String)"").append((Component)Component.translatable((String)"Contributors").setStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)String.join((CharSequence)", ", contributors)))))).append("").setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY)));
            about.add(Component.empty());
            ArrayList<String> desc = new ArrayList<String>(List.of(container.getModInfo().getDescription().split(" ")));
            if (desc.size() > 0) {
                StringBuilder descPart = new StringBuilder();
                while (!desc.isEmpty()) {
                    (descPart.isEmpty() ? descPart : descPart.append(" ")).append(desc.remove(0));
                    if (descPart.length() <= 16) continue;
                    about.add(Component.literal((String)descPart.toString()).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
                    descPart = new StringBuilder();
                }
                if (descPart.length() > 0) {
                    about.add(Component.literal((String)descPart.toString()).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
                }
            }
            if (GenericModInfo.icon.length > about.size() + 2 && useIcon) {
                int a = 0;
                for (int i = 0; i < GenericModInfo.icon.length; ++i) {
                    if (i == (GenericModInfo.icon.length - about.size() - 1) / 2 + a && a < about.size()) {
                        output.add(GenericModInfo.icon[i].copy().append((Component)Component.literal((String)"  ").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false))).append((Component)about.get(a++))));
                        continue;
                    }
                    output.add(GenericModInfo.icon[i]);
                }
            } else {
                Collections.addAll(output, GenericModInfo.icon);
                output.addAll(about);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MutableComponent invalid = Component.literal((String)"/!\\ [ Invalid about mod info ] /!\\").setStyle(Style.EMPTY.withColor(0xFF0000).withItalic(Boolean.valueOf(true)));
            output.add(invalid);
            about.add(invalid);
        }
        GenericModInfo.about = output.toArray(new Component[0]);
        consoleAbout = aboutBasic.toArray(new Component[0]);
    }

    public static Component[] getIcon() {
        return icon;
    }

    public static Component[] getAboutFull() {
        return about;
    }

    public static Component[] getAboutConsole() {
        return consoleAbout;
    }
}

