/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.mixin;

import eu.pb4.styledchat.StyledChatMod;
import eu.pb4.styledchat.StyledChatUtils;
import eu.pb4.styledchat.ducks.ExtSignedMessage;
import eu.pb4.styledchat.other.ExtendedSentMessage;
import eu.pb4.styledchat.other.StyledChatSentMessage;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={OutgoingChatMessage.class})
public interface SentMessageMixin {
    @Inject(method={"create(Lnet/minecraft/network/chat/PlayerChatMessage;)Lnet/minecraft/network/chat/OutgoingChatMessage;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void styledChat$patchStyle(PlayerChatMessage message, CallbackInfoReturnable<OutgoingChatMessage> cir) {
        Component override = ((ExtSignedMessage)message).styledChat_getArg("override");
        if (override != StyledChatUtils.EMPTY_TEXT && StyledChatMod.server != null) {
            ResourceKey<ChatType> type = ((ExtSignedMessage)message).styledChat_getType();
            if (message.isSystem()) {
                cir.setReturnValue((Object)new StyledChatSentMessage.System(message, override, StyledChatUtils.createParameters(override), type, (MutableObject<ChatType.Bound>)new MutableObject()));
            } else {
                cir.setReturnValue((Object)new StyledChatSentMessage.Chat(message, override, StyledChatUtils.createParameters(override), type, (MutableObject<ChatType.Bound>)new MutableObject()));
            }
        }
    }

    @Inject(method={"create(Lnet/minecraft/network/chat/PlayerChatMessage;)Lnet/minecraft/network/chat/OutgoingChatMessage;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void styledChat$forceAttach(PlayerChatMessage message, CallbackInfoReturnable<OutgoingChatMessage> cir) {
        if (cir.getReturnValue() instanceof OutgoingChatMessage.Disguised) {
            ((ExtendedSentMessage)cir.getReturnValue()).styledChat$setMessage(message);
        }
    }

    @Mixin(value={OutgoingChatMessage.Disguised.class})
    public static class ProfilelessMixin
    implements ExtendedSentMessage {
        @Unique
        private PlayerChatMessage styledChat$message;

        @Override
        public PlayerChatMessage styledChat$message() {
            return this.styledChat$message;
        }

        @Override
        public void styledChat$setMessage(PlayerChatMessage value) {
            this.styledChat$message = value;
        }
    }

    @Mixin(value={OutgoingChatMessage.Player.class})
    public static class ChatMixin
    implements ExtendedSentMessage {
        @Shadow
        @Final
        private PlayerChatMessage message;

        @Override
        public PlayerChatMessage styledChat$message() {
            return this.message;
        }
    }
}

