/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.config.data.old;

import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.styledchat.config.data.ConfigData;
import eu.pb4.styledchat.config.data.old.ChatStyleDataV2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Tuple;

public class ConfigDataV2 {
    public static final int VERSION = 2;
    public int CONFIG_VERSION_DONT_TOUCH_THIS = 2;
    public String _comment = "Before changing anything, see https://github.com/Patbox/StyledChat#configuration";
    public ChatStyleDataV2 defaultStyle;
    public List<PermissionPriorityStyle> permissionStyles = new ArrayList<PermissionPriorityStyle>();
    public String petDeathMessage = "${default_message}";
    public Map<String, String> emoticons = new HashMap<String, String>();
    public List<PermissionEmotes> permissionEmoticons = new ArrayList<PermissionEmotes>();
    public boolean legacyChatFormatting = true;
    public boolean parseLinksInChat = true;
    public boolean enableMarkdown = true;
    public boolean allowModdedDecorators = true;
    public boolean sendFullMessageInChatPreview = false;
    public boolean requireChatPreviewForFormatting = false;
    public boolean sendAutoCompletionForTags = false;
    public boolean sendAutoCompletionForTagAliases = false;
    public boolean sendAutoCompletionForEmotes = true;
    public String linkStyle = "<underline><c:#7878ff>${link}";
    public String spoilerStyle = "<gray>${spoiler}";
    public String spoilerSymbol = "\u258c";
    public HashMap<String, Boolean> defaultEnabledFormatting = new HashMap();

    public ConfigData update() {
        ConfigData data = new ConfigData();
        data.defaultStyle = this.defaultStyle.update();
        data.defaultStyle.messages.petDeathMessage = this.petDeathMessage;
        data.defaultStyle.linkStyle = this.linkStyle;
        data.defaultStyle.spoilerStyle = this.spoilerStyle;
        data.defaultStyle.spoilerSymbol = this.spoilerSymbol;
        data.defaultStyle.emoticons.putAll(this.emoticons);
        for (Map.Entry<String, Boolean> e : this.defaultEnabledFormatting.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            data.defaultStyle.formatting.put(e.getKey(), true);
        }
        data.autoCompletion.tagAliases = this.sendAutoCompletionForTagAliases;
        data.autoCompletion.tags = this.sendAutoCompletionForTags;
        data.autoCompletion.emoticons = this.sendAutoCompletionForEmotes;
        data.formatting.markdown = this.enableMarkdown;
        data.formatting.legacyChatFormatting = this.legacyChatFormatting;
        data.formatting.respectColors = this.allowModdedDecorators;
        data.formatting.parseLinksInChat = this.parseLinksInChat;
        ArrayList<Tuple> pairs = new ArrayList<Tuple>();
        for (PermissionPriorityStyle permissionPriorityStyle : this.permissionStyles) {
            pairs.add(new Tuple((Object)permissionPriorityStyle, null));
        }
        for (PermissionEmotes permissionEmotes : this.permissionEmoticons) {
            boolean hasPair = false;
            for (Tuple pair : pairs) {
                if (pair.getB() != null || ((PermissionPriorityStyle)pair.getA()).opLevel != permissionEmotes.opLevel || !((PermissionPriorityStyle)pair.getA()).permission.equals(permissionEmotes.permission)) continue;
                hasPair = true;
                pair.setB((Object)permissionEmotes);
                break;
            }
            if (hasPair) continue;
            pairs.add(new Tuple(null, (Object)permissionEmotes));
        }
        for (Tuple tuple : pairs) {
            ConfigData.RequireChatStyleData style = new ConfigData.RequireChatStyleData();
            if (tuple.getA() != null) {
                style.require = this.createRequire(((PermissionPriorityStyle)tuple.getA()).permission, ((PermissionPriorityStyle)tuple.getA()).opLevel);
                ((PermissionPriorityStyle)tuple.getA()).style.copyInto(style);
            } else {
                style.require = this.createRequire(((PermissionEmotes)tuple.getB()).permission, ((PermissionEmotes)tuple.getB()).opLevel);
            }
            if (tuple.getB() != null) {
                style.emoticons.putAll(((PermissionEmotes)tuple.getB()).emoticons);
            }
            data.permissionStyles.add(style);
        }
        return data;
    }

    private MinecraftPredicate createRequire(String permission, int opLevel) {
        if (permission.isEmpty()) {
            return BuiltinPredicates.operatorLevel((int)opLevel);
        }
        if (opLevel > 4 || opLevel < 1) {
            return BuiltinPredicates.modPermissionApi((String)permission);
        }
        return BuiltinPredicates.modPermissionApi((String)permission, (int)opLevel);
    }

    public static class PermissionPriorityStyle {
        public ChatStyleDataV2 style;
        public String permission = "";
        public int opLevel = 5;
    }

    public static class PermissionEmotes {
        public String permission = "";
        public int opLevel = 3;
        public Map<String, String> emoticons = Collections.EMPTY_MAP;
    }
}

