/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.config.data;

import com.google.gson.annotations.SerializedName;
import eu.pb4.styledchat.mixin.PermissionAPIAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.Nullable;

public class ChatStyleData
implements Cloneable {
    public static ChatStyleData DEFAULT = ChatStyleData.createDefault();
    public static final Map<String, PropertyGetSet> PROPERTIES = new HashMap<String, PropertyGetSet>();
    @SerializedName(value="display_name")
    public String displayName;
    @SerializedName(value="message_formats")
    public Messages messages = new Messages();
    @SerializedName(value="link_style")
    public String linkStyle;
    @SerializedName(value="mention_style")
    public String mentionStyle;
    @SerializedName(value="spoiler_style")
    public String spoilerStyle;
    @SerializedName(value="spoiler_symbol")
    public String spoilerSymbol;
    @SerializedName(value="formatting")
    public Map<String, Boolean> formatting = new HashMap<String, Boolean>();
    @SerializedName(value="emoticons")
    public LinkedHashMap<String, String> emoticons = new LinkedHashMap();
    @SerializedName(value="custom_message_types")
    public Map<String, String> custom = new HashMap<String, String>();

    public ChatStyleData clone() {
        try {
            ChatStyleData base = (ChatStyleData)super.clone();
            base.messages = this.messages.clone();
            base.formatting = new HashMap<String, Boolean>(this.formatting);
            base.emoticons = new LinkedHashMap<String, String>(this.emoticons);
            base.custom = new HashMap<String, String>(this.custom);
            return base;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fillPermissionOptionProvider(CommandSourceStack source) {
        if (source.getPlayer() == null) {
            return;
        }
        for (Map.Entry<String, PropertyGetSet> prop : PROPERTIES.entrySet()) {
            String value;
            if (prop.getValue().get(this) != null || (value = (String)PermissionAPIAccessor.getActiveHandler().getPermission(source.getPlayer(), new PermissionNode("styled_chat", prop.getKey(), PermissionTypes.STRING, (arg, uUID, permissionDynamicContexts) -> "", new PermissionDynamicContextKey[0]), new PermissionDynamicContext[0])).isEmpty()) continue;
            prop.getValue().set(this, value);
        }
    }

    public static ChatStyleData createDefault() {
        ChatStyleData data = new ChatStyleData();
        data.displayName = "${default}";
        data.messages.chat = "<${player}> ${message}";
        data.messages.joinedGame = "<yellow><lang:multiplayer.player.joined:'${player}'></yellow>";
        data.messages.joinedAfterNameChange = "<yellow><lang:multiplayer.player.joined.renamed:'${player}':'${old_name}'></yellow>";
        data.messages.joinedForFirstTime = "<yellow><lang:multiplayer.player.joined:'${player}'></yellow>";
        data.messages.leftGame = "<yellow><lang:multiplayer.player.left:'${player}'></yellow>";
        data.messages.baseDeath = "${default_message}";
        data.messages.advancementTask = "<lang:chat.type.advancement.task:'${player}':'${advancement}'>";
        data.messages.advancementGoal = "<lang:chat.type.advancement.goal:'${player}':'${advancement}'>";
        data.messages.advancementChallenge = "<lang:chat.type.advancement.challenge:'${player}':'${advancement}'>";
        data.messages.sentTeamChat = "<lang:'chat.type.team.sent':'<hover\\:\\'<lang\\:chat.type.team.hover>\\'><suggest_command\\:\\'/teammsg \\'>${team}':'${displayName}':'${message}'>";
        data.messages.receivedTeamChat = "<lang:'chat.type.team.text':'<hover\\:\\'<lang\\:chat.type.team.hover>\\'><suggest_command\\:\\'/teammsg \\'>${team}':'${displayName}':'${message}'>";
        data.messages.privateMessageSent = "<gray><italic><lang:commands.message.display.outgoing:'${receiver}':'${message}'>";
        data.messages.privateMessageReceived = "<gray><italic><lang:commands.message.display.incoming:'${sender}':'${message}'>";
        data.messages.sayCommandMessage = "[${player}] ${message}";
        data.messages.meCommandMessage = "<lang:'chat.type.emote':'${player}':'${message}'>";
        data.messages.petDeathMessage = "${default_message}";
        data.linkStyle = "<underline><c:#7878ff>${link}";
        data.mentionStyle = "<c:#7878ff>%player:displayname%";
        data.spoilerStyle = "<gray>${spoiler}";
        data.spoilerSymbol = "\u258c";
        data.formatting.put("spoiler", true);
        data.formatting.put("bold", true);
        data.formatting.put("italic", true);
        data.formatting.put("strikethrough", true);
        data.formatting.put("underline", true);
        for (ChatFormatting formatting : ChatFormatting.values()) {
            if (!formatting.isColor()) continue;
            data.formatting.put(formatting.getName(), true);
        }
        data.emoticons.put("$emojibase:builtin:joypixels", "${emoji}");
        data.emoticons.put("shrug", "\u00af\\_(\u30c4)_/\u00af");
        data.emoticons.put("table", "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b");
        data.emoticons.put("sword", "\ud83d\udde1");
        data.emoticons.put("bow", "\ud83c\udff9");
        data.emoticons.put("trident", "\ud83d\udd31");
        data.emoticons.put("rod", "\ud83c\udfa3");
        data.emoticons.put("potion", "\ud83e\uddea");
        data.emoticons.put("shears", "\u2702");
        data.emoticons.put("bucket", "\ud83e\udea3");
        data.emoticons.put("bell", "\ud83d\udd14");
        data.emoticons.put("item", "[%player:equipment_slot mainhand%]");
        data.emoticons.put("pos", "%player:pos_x% %player:pos_y% %player:pos_z%");
        return data;
    }

    public void fillMissing() {
        this.displayName = Objects.requireNonNullElse(this.displayName, ChatStyleData.DEFAULT.displayName);
        this.messages.chat = Objects.requireNonNullElse(this.messages.chat, ChatStyleData.DEFAULT.messages.chat);
        this.messages.joinedGame = Objects.requireNonNullElse(this.messages.joinedGame, ChatStyleData.DEFAULT.messages.joinedGame);
        this.messages.joinedAfterNameChange = Objects.requireNonNullElse(this.messages.joinedAfterNameChange, ChatStyleData.DEFAULT.messages.joinedAfterNameChange);
        this.messages.joinedForFirstTime = Objects.requireNonNullElse(this.messages.joinedForFirstTime, ChatStyleData.DEFAULT.messages.joinedForFirstTime);
        this.messages.leftGame = Objects.requireNonNullElse(this.messages.leftGame, ChatStyleData.DEFAULT.messages.leftGame);
        this.messages.baseDeath = Objects.requireNonNullElse(this.messages.baseDeath, ChatStyleData.DEFAULT.messages.baseDeath);
        this.messages.advancementTask = Objects.requireNonNullElse(this.messages.advancementTask, ChatStyleData.DEFAULT.messages.advancementTask);
        this.messages.advancementChallenge = Objects.requireNonNullElse(this.messages.advancementChallenge, ChatStyleData.DEFAULT.messages.advancementChallenge);
        this.messages.advancementGoal = Objects.requireNonNullElse(this.messages.advancementGoal, ChatStyleData.DEFAULT.messages.advancementGoal);
        this.messages.privateMessageReceived = Objects.requireNonNullElse(this.messages.privateMessageReceived, ChatStyleData.DEFAULT.messages.privateMessageReceived);
        this.messages.privateMessageSent = Objects.requireNonNullElse(this.messages.privateMessageSent, ChatStyleData.DEFAULT.messages.privateMessageSent);
        this.messages.sentTeamChat = Objects.requireNonNullElse(this.messages.sentTeamChat, ChatStyleData.DEFAULT.messages.sentTeamChat);
        this.messages.receivedTeamChat = Objects.requireNonNullElse(this.messages.receivedTeamChat, ChatStyleData.DEFAULT.messages.receivedTeamChat);
        this.messages.sayCommandMessage = Objects.requireNonNullElse(this.messages.sayCommandMessage, ChatStyleData.DEFAULT.messages.sayCommandMessage);
        this.messages.meCommandMessage = Objects.requireNonNullElse(this.messages.meCommandMessage, ChatStyleData.DEFAULT.messages.meCommandMessage);
        this.messages.petDeathMessage = Objects.requireNonNullElse(this.messages.petDeathMessage, ChatStyleData.DEFAULT.messages.petDeathMessage);
        this.linkStyle = Objects.requireNonNullElse(this.linkStyle, ChatStyleData.DEFAULT.linkStyle);
        this.spoilerStyle = Objects.requireNonNullElse(this.spoilerStyle, ChatStyleData.DEFAULT.spoilerStyle);
        this.spoilerSymbol = Objects.requireNonNullElse(this.spoilerSymbol, ChatStyleData.DEFAULT.spoilerSymbol);
        this.custom = Objects.requireNonNullElse(this.custom, new HashMap());
        for (String key : ChatStyleData.DEFAULT.formatting.keySet()) {
            if (this.formatting.containsKey(key)) continue;
            this.formatting.put(key, ChatStyleData.DEFAULT.formatting.get(key));
        }
    }

    static {
        for (Field field : ChatStyleData.class.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (field.getType() == String.class) {
                PROPERTIES.put(field.getAnnotation(SerializedName.class).value(), PropertyGetSet.of(field));
                continue;
            }
            if (field.getType() != Messages.class) continue;
            for (Field field2 : Messages.class.getFields()) {
                PROPERTIES.put("message_formats." + field2.getAnnotation(SerializedName.class).value(), PropertyGetSet.ofMessage(field2));
            }
        }
    }

    public static class Messages
    implements Cloneable {
        @SerializedName(value="chat")
        public String chat;
        @SerializedName(value="joined_the_game")
        public String joinedGame;
        @SerializedName(value="joined_after_name_change")
        public String joinedAfterNameChange;
        @SerializedName(value="joined_for_first_time")
        public String joinedForFirstTime;
        @SerializedName(value="left_game")
        public String leftGame;
        @SerializedName(value="base_death")
        public String baseDeath;
        @SerializedName(value="advancement_task")
        public String advancementTask;
        @SerializedName(value="advancement_challenge")
        public String advancementChallenge;
        @SerializedName(value="advancement_goal")
        public String advancementGoal;
        @SerializedName(value="sent_team_chat")
        public String sentTeamChat;
        @SerializedName(value="received_team_chat")
        public String receivedTeamChat;
        @SerializedName(value="sent_private_message")
        public String privateMessageSent;
        @SerializedName(value="received_private_message")
        public String privateMessageReceived;
        @SerializedName(value="say_command")
        public String sayCommandMessage;
        @SerializedName(value="me_command")
        public String meCommandMessage;
        @SerializedName(value="pet_death")
        public String petDeathMessage;

        public Messages clone() {
            try {
                return (Messages)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static interface PropertyGetSet {
        public static PropertyGetSet of(final Field field) {
            return new PropertyGetSet(){

                @Override
                public void set(ChatStyleData data, String value) {
                    try {
                        field.set(data, value);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public String get(ChatStyleData data) {
                    try {
                        return (String)field.get(data);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }

        public static PropertyGetSet ofCustom(final String key) {
            return new PropertyGetSet(){

                @Override
                public void set(ChatStyleData data, String value) {
                    if (value == null) {
                        data.custom.remove(key);
                    } else {
                        data.custom.put(key, value);
                    }
                }

                @Override
                public String get(ChatStyleData data) {
                    return data.custom.get(key);
                }
            };
        }

        public static PropertyGetSet ofMessage(final Field field) {
            return new PropertyGetSet(){

                @Override
                public void set(ChatStyleData data, String value) {
                    try {
                        field.set(data.messages, value);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public String get(ChatStyleData data) {
                    try {
                        return (String)field.get(data.messages);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }

        public void set(ChatStyleData var1, String var2);

        @Nullable
        public String get(ChatStyleData var1);
    }
}

