/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.config;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.predicate.api.BuiltinPredicates;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.styledchat.config.ChatStyle;
import eu.pb4.styledchat.config.data.ChatStyleData;
import eu.pb4.styledchat.config.data.ConfigData;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import org.jetbrains.annotations.Nullable;

public final class Config {
    public static final Config DEFAULT = new Config(new ConfigData());
    public final ConfigData configData;
    private final ChatStyle defaultStyle;
    private final List<ChatStyle> permissionStyle;
    public final Set<String> allPossibleAutoCompletionKeys;

    public Config(ConfigData data) {
        this.configData = data;
        this.defaultStyle = new ChatStyle(data.defaultStyle, new ChatStyle(ChatStyleData.DEFAULT));
        this.permissionStyle = new ArrayList<ChatStyle>();
        this.allPossibleAutoCompletionKeys = new HashSet<String>();
        for (String key : this.defaultStyle.emoticons.keySet()) {
            this.allPossibleAutoCompletionKeys.add(":" + key + ":");
        }
        for (ConfigData.RequireChatStyleData entry : data.permissionStyles) {
            if (entry.require == null) {
                entry.require = BuiltinPredicates.operatorLevel((int)4);
            }
            ChatStyle style = new ChatStyle(entry);
            this.permissionStyle.add(style);
            for (String key : style.emoticons.keySet()) {
                this.allPossibleAutoCompletionKeys.add(":" + key + ":");
            }
        }
        for (TextTag tag : TagRegistry.DEFAULT.getTags()) {
            this.allPossibleAutoCompletionKeys.add("<" + tag.name() + ">");
            if (tag.aliases() == null) continue;
            for (String a : tag.aliases()) {
                this.allPossibleAutoCompletionKeys.add("<" + a + ">");
            }
        }
    }

    public Component getDisplayName(ServerPlayer player, Component vanillaDisplayName) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getDisplayName(player, vanillaDisplayName)) == null) continue;
            return text;
        }
        return this.defaultStyle.getDisplayName(player, vanillaDisplayName);
    }

    public Component getChat(ServerPlayer player, Component message) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getChat(player, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getChat(player, message);
    }

    public Component getJoin(ServerPlayer player) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getJoin(player)) == null) continue;
            return text;
        }
        return this.defaultStyle.getJoin(player);
    }

    public Component getJoinFirstTime(ServerPlayer player) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getJoinFirstTime(player)) == null) continue;
            return text;
        }
        Component text = this.defaultStyle.getJoinFirstTime(player);
        if (text != null) {
            return text;
        }
        return this.getJoin(player);
    }

    public Component getJoinRenamed(ServerPlayer player, String oldName) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getJoinRenamed(player, oldName)) == null) continue;
            return text;
        }
        return this.defaultStyle.getJoinRenamed(player, oldName);
    }

    public Component getLeft(ServerPlayer player) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getLeft(player)) == null) continue;
            return text;
        }
        return this.defaultStyle.getLeft(player);
    }

    public Component getDeath(ServerPlayer player, Component vanillaMessage) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getDeath(player, vanillaMessage)) == null) continue;
            return text;
        }
        return this.defaultStyle.getDeath(player, vanillaMessage);
    }

    public Component getAdvancementTask(ServerPlayer player, Component advancement) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementTask(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementTask(player, advancement);
    }

    public Component getAdvancementGoal(ServerPlayer player, Component advancement) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementGoal(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementGoal(player, advancement);
    }

    public Component getAdvancementChallenge(ServerPlayer player, Component advancement) {
        PredicateContext context = PredicateContext.of((ServerPlayer)player);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getAdvancementChallenge(player, advancement)) == null) continue;
            return text;
        }
        return this.defaultStyle.getAdvancementChallenge(player, advancement);
    }

    public Component getSayCommand(CommandSourceStack source, Component message) {
        PredicateContext context = PredicateContext.of((CommandSourceStack)source);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getSayCommand(source, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getSayCommand(source, message);
    }

    public Component getMeCommand(CommandSourceStack source, Component message) {
        PredicateContext context = PredicateContext.of((CommandSourceStack)source);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context).success() || (text = entry.getMeCommand(source, message)) == null) continue;
            return text;
        }
        return this.defaultStyle.getMeCommand(source, message);
    }

    public Component getPrivateMessageSent(Component sender, Component receiver, Component message, CommandSourceStack context) {
        PlaceholderContext placeholderContext = PlaceholderContext.of((CommandSourceStack)context);
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)context);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = entry.getPrivateMessageSent(sender, receiver, message, placeholderContext)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPrivateMessageSent(sender, receiver, message, placeholderContext);
    }

    public Component getPrivateMessageReceived(Component sender, Component receiver, Component message, CommandSourceStack context) {
        PlaceholderContext placeholderContext = PlaceholderContext.of((CommandSourceStack)context);
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)context);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = entry.getPrivateMessageReceived(sender, receiver, message, placeholderContext)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPrivateMessageReceived(sender, receiver, message, placeholderContext);
    }

    public Component getTeamChatSent(Component team, Component displayName, Component message, CommandSourceStack context) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)context);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = entry.getTeamChatSent(team, displayName, message, context)) == null) continue;
            return text;
        }
        return this.defaultStyle.getTeamChatSent(team, displayName, message, context);
    }

    public Component getTeamChatReceived(Component team, Component displayName, Component message, CommandSourceStack context) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)context);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = entry.getTeamChatReceived(team, displayName, message, context)) == null) continue;
            return text;
        }
        return this.defaultStyle.getTeamChatReceived(team, displayName, message, context);
    }

    public TextNode getSpoilerStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getSpoilerStyle()) == null) continue;
            return text;
        }
        return this.defaultStyle.getSpoilerStyle();
    }

    public String getSpoilerSymbole(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            String text;
            if (!entry.require.test(context2).success() || (text = entry.getSpoilerSymbol()) == null) continue;
            return text;
        }
        return this.defaultStyle.getSpoilerSymbol();
    }

    public TextNode getLinkStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getLink()) == null) continue;
            return text;
        }
        return this.defaultStyle.getLink();
    }

    public TextNode getMentionStyle(PlaceholderContext ctx) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)ctx.source());
        for (ChatStyle entry : this.permissionStyle) {
            TextNode text;
            if (!entry.require.test(context2).success() || (text = entry.getMention()) == null) continue;
            return text;
        }
        return this.defaultStyle.getMention();
    }

    public Component getPetDeath(TamableAnimal entity, Component vanillaMessage) {
        PredicateContext context2 = PredicateContext.of((Entity)entity);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = this.defaultStyle.getPetDeath(entity, vanillaMessage)) == null) continue;
            return text;
        }
        return this.defaultStyle.getPetDeath(entity, vanillaMessage);
    }

    public Map<String, TextNode> getEmotes(CommandSourceStack source) {
        HashMap<String, TextNode> base = new HashMap<String, TextNode>(this.defaultStyle.emoticons);
        PredicateContext context = PredicateContext.of((CommandSourceStack)source);
        for (ChatStyle entry : this.permissionStyle) {
            if (!entry.require.test(context).success()) continue;
            for (Map.Entry<String, TextNode> emoticon : entry.emoticons.entrySet()) {
                if (base.containsKey(emoticon.getKey())) continue;
                base.put(emoticon.getKey(), emoticon.getValue());
            }
        }
        return base;
    }

    public Object2BooleanOpenHashMap<String> getAllowedFormatting(CommandSourceStack source) {
        Object2BooleanOpenHashMap base = new Object2BooleanOpenHashMap(this.defaultStyle.formatting);
        PredicateContext context = PredicateContext.of((CommandSourceStack)source);
        for (ChatStyle entry : this.permissionStyle) {
            if (!entry.require.test(context).success()) continue;
            for (Object2BooleanMap.Entry formatting : entry.formatting.object2BooleanEntrySet()) {
                if (base.containsKey(formatting.getKey())) continue;
                base.put((Object)((String)formatting.getKey()), formatting.getBooleanValue());
            }
        }
        return base;
    }

    @Nullable
    public Component getCustom(ResourceLocation identifier, Component displayName, Component message, @Nullable Component receiver, CommandSourceStack source) {
        PredicateContext context2 = PredicateContext.of((CommandSourceStack)source);
        for (ChatStyle entry : this.permissionStyle) {
            Component text;
            if (!entry.require.test(context2).success() || (text = entry.getCustom(identifier, displayName, message, receiver, source)) == null) continue;
            return text;
        }
        return this.defaultStyle.getCustom(identifier, displayName, message, receiver, source);
    }
}

