/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.styledchat.Permissions;
import eu.pb4.styledchat.StyledChatMod;
import eu.pb4.styledchat.StyledChatUtils;
import eu.pb4.styledchat.config.ConfigManager;
import eu.pb4.styledchat.config.data.ChatStyleData;
import eu.pb4.styledchat.other.GenericModInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class Commands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"styledchat").requires(Permissions.require("styledchat.main", true))).executes(Commands::about)).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"reload").requires(Permissions.require("styledchat.reload", 3))).executes(Commands::reloadConfig))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"set").requires(Permissions.require("styledchat.set", 2))).then(Commands.fillWithProperties(net.minecraft.commands.Commands.argument((String)"players", (ArgumentType)EntityArgument.players()), (x, p) -> x.then(net.minecraft.commands.Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Commands.setProperty((CommandContext<CommandSourceStack>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx)))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"get").requires(Permissions.require("styledchat.get", 2))).then(Commands.fillWithProperties(net.minecraft.commands.Commands.argument((String)"player", (ArgumentType)EntityArgument.player()), (x, p) -> x.executes(ctx -> Commands.getProperty((CommandContext<CommandSourceStack>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"clear").requires(Permissions.require("styledchat.clear", 3))).then(Commands.fillWithProperties(net.minecraft.commands.Commands.argument((String)"players", (ArgumentType)EntityArgument.players()), (x, p) -> x.executes(ctx -> Commands.clearProperty((CommandContext<CommandSourceStack>)ctx, (ChatStyleData.PropertyGetSet)p.apply(ctx)))).then(net.minecraft.commands.Commands.literal((String)"*").executes(ctx -> Commands.clearProperty((CommandContext<CommandSourceStack>)ctx, null))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.literal((String)"tellform").requires(Permissions.require("styledchat.tellform", 2))).then(net.minecraft.commands.Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(net.minecraft.commands.Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            int i = 0;
            Component parsed = Placeholders.parseText((TextNode)TextNode.asSingle((TextNode[])StyledChatUtils.createParser((CommandSourceStack)context.getSource()).parseNodes(TextNode.of((String)StringArgumentType.getString((CommandContext)context, (String)"message")))), (PlaceholderContext)PlaceholderContext.of((CommandSourceStack)((CommandSourceStack)context.getSource())));
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)context, (String)"targets")) {
                player.sendSystemMessage(parsed);
            }
            return i;
        }))));
    }

    private static int getProperty(CommandContext<CommandSourceStack> context, ChatStyleData.PropertyGetSet propertyGetSet) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
        ChatStyleData data = StyledChatUtils.getPersonalData(player);
        if (data == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"<not set>").withStyle(ChatFormatting.ITALIC), false);
            return 0;
        }
        String val = propertyGetSet.get(data);
        if (val == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"<not set>").withStyle(ChatFormatting.ITALIC), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)val), false);
        return 1;
    }

    private static int setProperty(CommandContext<CommandSourceStack> context, ChatStyleData.PropertyGetSet propertySet) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        String val = StringArgumentType.getString(context, (String)"value");
        for (ServerPlayer player : players) {
            propertySet.set(StyledChatUtils.getOrCreatePersonalData(player), val);
            StyledChatUtils.updateStyle(player);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Changed style of " + players.size() + " player(s)")), false);
        return players.size();
    }

    private static int clearProperty(CommandContext<CommandSourceStack> context, ChatStyleData.PropertyGetSet propertySet) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            if (propertySet != null) {
                propertySet.set(StyledChatUtils.getOrCreatePersonalData(player), null);
            } else {
                StyledChatUtils.clearPersonalStyleData(player);
            }
            StyledChatUtils.updateStyle(player);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Cleared style for " + players.size() + " player(s)")), false);
        return players.size();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> fillWithProperties(ArgumentBuilder<CommandSourceStack, ?> base, BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, Function<CommandContext<CommandSourceStack>, ChatStyleData.PropertyGetSet>> command) {
        for (Map.Entry<String, ChatStyleData.PropertyGetSet> prop : ChatStyleData.PROPERTIES.entrySet()) {
            LiteralArgumentBuilder x = net.minecraft.commands.Commands.literal((String)prop.getKey());
            command.accept((ArgumentBuilder<CommandSourceStack, ?>)x, (Function<CommandContext<CommandSourceStack>, ChatStyleData.PropertyGetSet>)((Function<CommandContext, ChatStyleData.PropertyGetSet>)ctx -> (ChatStyleData.PropertyGetSet)prop.getValue()));
            base = base.then((ArgumentBuilder)x);
        }
        RequiredArgumentBuilder x = net.minecraft.commands.Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            for (ResourceLocation id : ((CommandSourceStack)context.getSource()).getServer().registryAccess().registryOrThrow(Registries.CHAT_TYPE).keySet()) {
                if (id.getNamespace().equals("minecraft") || id.equals((Object)StyledChatMod.MESSAGE_TYPE_ID.location())) continue;
                builder.suggest(id.toString());
            }
            return builder.buildFuture();
        });
        command.accept((ArgumentBuilder<CommandSourceStack, ?>)x, (Function<CommandContext<CommandSourceStack>, ChatStyleData.PropertyGetSet>)((Function<CommandContext, ChatStyleData.PropertyGetSet>)ctx -> ChatStyleData.PropertyGetSet.ofCustom(ResourceLocationArgument.getId((CommandContext)ctx, (String)"id").toString())));
        base = base.then(net.minecraft.commands.Commands.literal((String)"custom").then((ArgumentBuilder)x));
        return base;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        Set<String> old = ConfigManager.getConfig().allPossibleAutoCompletionKeys;
        if (ConfigManager.loadConfig((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess())) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Reloaded config!"), false);
            for (ServerPlayer player : ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayers()) {
                StyledChatUtils.sendAutoCompletion(player, old);
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Error occurred while reloading config! Check console for more information!").withStyle(ChatFormatting.RED));
        }
        return 1;
    }

    private static int about(CommandContext<CommandSourceStack> context) {
        for (Component text : ((CommandSourceStack)context.getSource()).getEntity() instanceof ServerPlayer ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
        }
        return 1;
    }
}

