/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.MarkdownLiteParserV1;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.ParserBuilder;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.JsonDataStorage;
import eu.pb4.styledchat.Permissions;
import eu.pb4.styledchat.StyledChatMod;
import eu.pb4.styledchat.StyledChatStyles;
import eu.pb4.styledchat.config.ChatStyle;
import eu.pb4.styledchat.config.Config;
import eu.pb4.styledchat.config.ConfigManager;
import eu.pb4.styledchat.config.data.ChatStyleData;
import eu.pb4.styledchat.config.data.VersionedChatStyleData;
import eu.pb4.styledchat.ducks.ExtPlayNetworkHandler;
import eu.pb4.styledchat.ducks.ExtSignedMessage;
import eu.pb4.styledchat.parser.LinkParser;
import eu.pb4.styledchat.parser.MentionParser;
import eu.pb4.styledchat.parser.SpoilerNode;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public final class StyledChatUtils {
    public static final Component IGNORED_TEXT = Component.empty();
    public static final Pattern URL_REGEX = Pattern.compile("(https?:\\/\\/[-a-zA-Z0-9@:%._\\+~#=]+\\.[^ ]+)");
    public static final String ITEM_KEY = "item";
    public static final String POS_KEY = "pos";
    public static final String SPOILER_TAG = "spoiler";
    private static final Function<MutableComponent, MutableComponent> COLOR_CLEARING = t -> t.setStyle(t.getStyle().withColor((TextColor)null));
    public static JsonDataStorage<VersionedChatStyleData> PLAYER_DATA = new JsonDataStorage("styled_chat_style", VersionedChatStyleData.class);
    public static final TextTag SPOILER_TEXT_TAG_NEW = TextTag.enclosing((String)"spoiler", List.of("hide"), (String)"styledchat", (boolean)true, (nodes, arg, parser) -> new SpoilerNode(nodes));
    public static final String FORMAT_PERMISSION_BASE = "styledchat.format.";
    public static final String FORMAT_PERMISSION_UNSAFE = "styledchat.unsafe_format.";
    public static final TagLikeParser.Format EMOTE_FORMAT = TagLikeParser.Format.of((char)':', (char)':');
    public static final Component EMPTY_TEXT = Component.empty();
    private static final Set<ResourceKey<ChatType>> DECORABLE = Set.of(ChatType.CHAT, ChatType.EMOTE_COMMAND, ChatType.MSG_COMMAND_INCOMING, ChatType.MSG_COMMAND_OUTGOING, ChatType.SAY_COMMAND, ChatType.TEAM_MSG_COMMAND_INCOMING, ChatType.TEAM_MSG_COMMAND_OUTGOING);
    @Deprecated(forRemoval=true)
    public static final TextParserV1.TagNodeBuilder SPOILER_TAG_HANDLER = (tag, data, input, handlers, endAt) -> {
        TextParserV1.NodeList out = TextParserV1.parseNodesWith((String)input, (TextParserV1.TagParserGetter)handlers, (String)endAt);
        return new TextParserV1.TagNodeValue((TextNode)new SpoilerNode(out.nodes()), out.length());
    };
    @Deprecated(forRemoval=true)
    public static final TextParserV1.TextTag SPOILER_TEXT_TAG = TextParserV1.TextTag.of((String)"spoiler", List.of("hide"), (String)"styledchat", (boolean)true, (TextParserV1.TagNodeBuilder)SPOILER_TAG_HANDLER);
    @Deprecated(forRemoval=true)
    public static final Pattern EMOTE_PATTERN = Pattern.compile("(?<!((?<!(\\\\))\\\\))[:](?<id>[^:]+)[:]");

    @Deprecated
    public static TextNode parseText(String input) {
        return !input.isEmpty() ? Placeholders.parseNodes((TextNode)TextParserUtils.formatNodes((String)input)) : EmptyNode.INSTANCE;
    }

    public static NodeParser createParser(CommandSourceStack source) {
        return StyledChatUtils.createParser(PlaceholderContext.of((CommandSourceStack)source));
    }

    public static NodeParser createParser(PlaceholderContext context) {
        Map<String, TextNode> emotes;
        ArrayList<Object> form;
        Config config = ConfigManager.getConfig();
        ParserBuilder builder = NodeParser.builder();
        TagRegistry tags = StyledChatUtils.getTextTagRegistry(context.source());
        if (!tags.getTags().isEmpty()) {
            builder.simplifiedTextFormat();
            builder.quickText();
            builder.customTagRegistry(tags);
        }
        if (config.configData.formatting.parseLinksInChat) {
            builder.add((NodeParser)new LinkParser(ConfigManager.getConfig().getLinkStyle(context)));
        }
        if (config.configData.formatting.parseMentionsInChat) {
            builder.add((NodeParser)new MentionParser(ConfigManager.getConfig().getMentionStyle(context), context));
        }
        if (config.configData.formatting.markdown) {
            form = new ArrayList<Object>();
            if (tags.getTag("bold") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.BOLD);
            }
            if (tags.getTag("italic") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.ITALIC);
            }
            if (tags.getTag("underline") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.UNDERLINE);
            }
            if (tags.getTag("strikethrough") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.STRIKETHROUGH);
            }
            if (tags.getTag(SPOILER_TAG) != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.SPOILER);
            }
            if (tags.getTag("link") != null) {
                form.add(MarkdownLiteParserV1.MarkdownFormat.URL);
            }
            builder.markdown(SpoilerNode::new, MarkdownLiteParserV1::defaultQuoteFormatting, MarkdownLiteParserV1::defaultUrlFormatting, form.toArray(new MarkdownLiteParserV1.MarkdownFormat[0]));
        }
        if (config.configData.formatting.legacyChatFormatting) {
            boolean color;
            form = new ArrayList();
            for (ChatFormatting formatting : ChatFormatting.values()) {
                if (tags.getTag(formatting.getName()) == null) continue;
                form.add(formatting);
            }
            boolean bl = color = tags.getTag("color") != null;
            if (!form.isEmpty() || color) {
                builder.legacy(color, form.toArray(new ChatFormatting[0]));
            }
        }
        if (!(emotes = StyledChatUtils.getEmotes(context)).isEmpty()) {
            builder.placeholders(EMOTE_FORMAT, emotes::get);
        }
        return builder.build();
    }

    public static TagRegistry getTextTagRegistry(CommandSourceStack source) {
        Config config = ConfigManager.getConfig();
        TagRegistry registry = TagRegistry.create();
        Object2BooleanOpenHashMap<String> allowedFormatting = config.getAllowedFormatting(source);
        for (TextTag entry : TagRegistry.DEFAULT.getTags()) {
            if (!allowedFormatting.getBoolean((Object)entry.name()) && !Permissions.check(source, (entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + entry.name(), entry.userSafe() ? 2 : 4) && !Permissions.check(source, (entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + ".type." + entry.type(), entry.userSafe() ? 2 : 4)) continue;
            registry.register(entry);
        }
        if (allowedFormatting.getBoolean((Object)SPOILER_TAG) || Permissions.check(source, "styledchat.format.spoiler", 2)) {
            registry.register(SPOILER_TEXT_TAG_NEW);
        }
        return registry;
    }

    @Deprecated(forRemoval=true)
    public static TextParserV1 createTextParserV1(CommandSourceStack source) {
        TextParserV1 parser = new TextParserV1();
        Config config = ConfigManager.getConfig();
        Object2BooleanOpenHashMap<String> allowedFormatting = config.getAllowedFormatting(source);
        for (TextParserV1.TextTag entry : TextParserV1.DEFAULT.getTags()) {
            if (!allowedFormatting.getBoolean((Object)entry.name()) && !Permissions.check(source, (entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + entry.name(), entry.userSafe() ? 2 : 4) && !Permissions.check(source, (entry.userSafe() ? FORMAT_PERMISSION_BASE : FORMAT_PERMISSION_UNSAFE) + ".type." + entry.type(), entry.userSafe() ? 2 : 4)) continue;
            parser.register(entry);
        }
        if (allowedFormatting.getBoolean((Object)SPOILER_TAG) || Permissions.check(source, "styledchat.format.spoiler", 2)) {
            parser.register(SPOILER_TEXT_TAG);
        }
        return parser;
    }

    public static Map<String, TextNode> getEmotes(PlaceholderContext context) {
        return StyledChatStyles.getEmotes(context.hasPlayer() ? context.player().createCommandSourceStack() : context.server().createCommandSourceStack());
    }

    public static Component formatFor(PlaceholderContext context, String input) {
        NodeParser parser = StyledChatUtils.createParser(context);
        Config config = ConfigManager.getConfig();
        if (StyledChatMod.USE_FABRIC_API) {
            // empty if block
        }
        TextNode value = TextNode.asSingle((TextNode[])parser.parseNodes((TextNode)new LiteralNode(input)));
        if (StyledChatMod.USE_FABRIC_API) {
            // empty if block
        }
        Component text = value.toText(context);
        if (config.configData.formatting.respectColors) {
            try {
                text = context.server().getChatDecorator().decorate(context.player(), text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return text;
    }

    private static String getMarkdownRegex(String base, String sides) {
        return "(" + sides + ")(?<id>[^" + base + "]+)(" + sides + ")";
    }

    public static <T> ChatDecorator getCommandDecorator(String context, CommandSourceStack source, BiFunction<String, Class<?>, Object> argumentGetter) {
        Config config = ConfigManager.getConfig();
        return (player, message) -> {
            Component input = StyledChatUtils.formatFor(player != null ? PlaceholderContext.of((ServerPlayer)player) : PlaceholderContext.of((MinecraftServer)StyledChatMod.server), message.getString());
            return switch (context) {
                case "msg" -> {
                    try {
                        Component var9_9;
                        yield var9_9 = config.getPrivateMessageReceived(source.getDisplayName(), ((ServerPlayer)((EntitySelector)argumentGetter.apply("targets", EntitySelector.class)).findPlayers(source).get(0)).getDisplayName(), input, source);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MutableComponent var9_10 = Component.literal((String)"");
                        yield var9_10;
                    }
                }
                case "teammsg" -> {
                    try {
                        Component var9_11;
                        yield var9_11 = config.getTeamChatReceived((Component)source.getEntity().getTeam().getFormattedDisplayName(), source.getDisplayName(), input, source);
                    }
                    catch (Exception e) {
                        MutableComponent var9_12 = Component.literal((String)"");
                        yield var9_12;
                    }
                }
                case "say" -> {
                    Component var9_13;
                    yield var9_13 = config.getSayCommand(source, input);
                }
                case "me" -> {
                    Component var9_14;
                    yield var9_14 = config.getMeCommand(source, input);
                }
                default -> {
                    Component var9_15;
                    yield var9_15 = input;
                }
            };
        };
    }

    @Deprecated
    public static TextNode additionalParsing(TextNode node, PlaceholderContext context) {
        if (ConfigManager.getConfig().configData.formatting.parseLinksInChat) {
            node = StyledChatUtils.parseLinks(node, context);
        }
        return node;
    }

    @Deprecated
    public static TextNode parseLinks(TextNode node, PlaceholderContext context) {
        return TextNode.asSingle((TextNode[])LinkParser.parse(node, context));
    }

    public static ChatType.Bound removeColor(ChatType.Bound parameters) {
        return new ChatType.Bound(parameters.chatType(), StyledChatUtils.removeColor(parameters.name()), parameters.targetName());
    }

    public static Component removeColor(Component text) {
        return GeneralUtils.cloneTransformText((Component)text, COLOR_CLEARING);
    }

    public static boolean isHandledByMod(ResourceKey<ChatType> typeKey) {
        return DECORABLE.contains(typeKey);
    }

    public static void modifyForSending(PlayerChatMessage message, CommandSourceStack source, ResourceKey<ChatType> type) {
        try {
            ExtSignedMessage.setArg(message, "override", StyledChatUtils.formatMessage(message, source, type));
            ((ExtSignedMessage)message).styledChat_setType(type);
            ((ExtSignedMessage)message).styledChat_setSource(source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Component formatMessage(PlayerChatMessage message, CommandSourceStack source, ResourceKey<ChatType> type) {
        Component input;
        ExtSignedMessage ext = (ExtSignedMessage)message;
        Component baseInput = ext.styledChat_getArg("base_input");
        Component component = input = baseInput != null && baseInput.getContents() != PlainTextContents.EMPTY ? baseInput : StyledChatUtils.maybeFormatFor(source, ext.styledChat_getOriginal(), message.decoratedContent());
        if (baseInput == EMPTY_TEXT) {
            ext.styledChat_setArg("base_input", input);
        }
        return switch (type.location().getPath()) {
            case "msg_command_incoming" -> {
                try {
                    Component var8_8;
                    yield var8_8 = StyledChatStyles.getPrivateMessageReceived(source.getDisplayName(), ext.styledChat_getArg("targets"), input, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MutableComponent var8_9 = Component.empty();
                    yield var8_9;
                }
            }
            case "msg_command_outgoing" -> {
                try {
                    Component var8_10;
                    yield var8_10 = StyledChatStyles.getPrivateMessageSent(source.getDisplayName(), ext.styledChat_getArg("targets"), input, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MutableComponent var8_11 = Component.empty();
                    yield var8_11;
                }
            }
            case "team_msg_command_incoming" -> {
                try {
                    Component var8_12;
                    yield var8_12 = StyledChatStyles.getTeamChatReceived((Component)source.getEntity().getTeam().getFormattedDisplayName(), source.getDisplayName(), input, source);
                }
                catch (Exception e) {
                    MutableComponent var8_13 = Component.literal((String)"");
                    yield var8_13;
                }
            }
            case "team_msg_command_outgoing" -> {
                try {
                    Component var8_14;
                    yield var8_14 = StyledChatStyles.getTeamChatSent((Component)source.getEntity().getTeam().getFormattedDisplayName(), source.getDisplayName(), input, source);
                }
                catch (Exception e) {
                    MutableComponent var8_15 = Component.literal((String)"");
                    yield var8_15;
                }
            }
            case "say_command" -> {
                Component var8_16;
                yield var8_16 = StyledChatStyles.getSayCommand(source, input);
            }
            case "emote_command" -> {
                Component var8_17;
                yield var8_17 = StyledChatStyles.getMeCommand(source, input);
            }
            case "chat" -> {
                Component var8_18;
                yield var8_18 = StyledChatStyles.getChat(source.getPlayer(), input);
            }
            default -> {
                Component var8_19;
                yield var8_19 = StyledChatStyles.getCustom(type.location(), source.getDisplayName(), input, null, source);
            }
        };
    }

    public static Component maybeFormatFor(CommandSourceStack source, String original, Component originalContent) {
        return StyledChatUtils.formatFor(source, original);
    }

    public static Component formatFor(CommandSourceStack source, String original) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return StyledChatUtils.formatFor(PlaceholderContext.of((ServerPlayer)player), original);
        }
        return StyledChatUtils.formatFor(PlaceholderContext.of((MinecraftServer)source.getServer()), original);
    }

    @Deprecated
    public static PlayerChatMessage toEventMessage(PlayerChatMessage message, PlaceholderContext context) {
        Component input;
        ExtSignedMessage ext = (ExtSignedMessage)message;
        Component baseInput = ext.styledChat_getArg("base_input");
        Component component = input = baseInput != EMPTY_TEXT && baseInput.getContents() != PlainTextContents.EMPTY ? baseInput : StyledChatUtils.formatFor(context, ext.styledChat_getOriginal());
        if (baseInput == EMPTY_TEXT) {
            ext.styledChat_setArg("base_input", input);
        }
        return new PlayerChatMessage(message.link(), null, SignedMessageBody.unsigned((String)message.signedContent()), input, null);
    }

    @Deprecated(forRemoval=true)
    public static void sendAutocompliton(ServerPlayer player) {
        StyledChatUtils.sendAutoCompletion(player, ConfigManager.getConfig().allPossibleAutoCompletionKeys);
    }

    public static void sendAutoCompletion(ServerPlayer player, Collection<String> oldAutoCompletion) {
        Config config = ConfigManager.getConfig();
        player.connection.send((Packet)new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.REMOVE, new ArrayList<String>(oldAutoCompletion)));
        HashSet<CallSite> set = new HashSet<CallSite>();
        CommandSourceStack source = player.createCommandSourceStack();
        TagRegistry handler = StyledChatUtils.getTextTagRegistry(source);
        if (config.configData.autoCompletion.tags) {
            for (TextTag tag : handler.getTags()) {
                set.add((CallSite)((Object)("<" + tag.name() + ">")));
                if (!config.configData.autoCompletion.tagAliases || tag.aliases() == null) continue;
                for (String a : tag.aliases()) {
                    set.add((CallSite)((Object)("<" + a + ">")));
                }
            }
        }
        if (config.configData.autoCompletion.emoticons) {
            for (String emote : config.getEmotes(source).keySet()) {
                set.add((CallSite)((Object)(":" + emote + ":")));
            }
        }
        if (!set.isEmpty()) {
            player.connection.send((Packet)new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.ADD, new ArrayList(set)));
        }
    }

    public static ChatStyle getPersonalStyle(ServerPlayer player) {
        if (player.connection != null) {
            return ((ExtPlayNetworkHandler)player.connection).styledChat$getStyle();
        }
        return ChatStyle.EMPTY;
    }

    public static void updateStyle(ServerPlayer player) {
        if (player.connection != null) {
            ((ExtPlayNetworkHandler)player.connection).styledChat$setStyle(StyledChatUtils.createStyleOf(player));
        }
    }

    @Nullable
    public static ChatStyleData getPersonalData(ServerPlayer player) {
        return (ChatStyleData)PlayerDataApi.getCustomDataFor((ServerPlayer)player, PLAYER_DATA);
    }

    public static ChatStyleData getOrCreatePersonalData(ServerPlayer player) {
        VersionedChatStyleData style = (VersionedChatStyleData)PlayerDataApi.getCustomDataFor((ServerPlayer)player, PLAYER_DATA);
        if (style == null) {
            style = new VersionedChatStyleData();
            PlayerDataApi.setCustomDataFor((ServerPlayer)player, PLAYER_DATA, (Object)style);
        }
        return style;
    }

    public static void clearPersonalStyleData(ServerPlayer player) {
        PlayerDataApi.setCustomDataFor((ServerPlayer)player, PLAYER_DATA, (Object)new VersionedChatStyleData());
    }

    public static ChatStyle createStyleOf(ServerPlayer player) {
        VersionedChatStyleData style = (VersionedChatStyleData)PlayerDataApi.getCustomDataFor((ServerPlayer)player, PLAYER_DATA);
        style = style == null ? new VersionedChatStyleData() : (VersionedChatStyleData)style.clone();
        style.fillPermissionOptionProvider(player.createCommandSourceStack());
        return new ChatStyle(style);
    }

    public static ChatType.Bound createParameters(Component override) {
        return ChatType.bind(StyledChatMod.MESSAGE_TYPE_ID, (RegistryAccess)StyledChatMod.server.registryAccess(), (Component)override);
    }
}

