/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.styledchat;

import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.styledchat.StyledChatUtils;
import eu.pb4.styledchat.config.ConfigManager;
import eu.pb4.styledchat.other.GenericModInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="styledchat")
public class StyledChatMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"Styled Chat");
    public static MinecraftServer server = null;
    public static boolean USE_FABRIC_API = true;
    public static ResourceKey<ChatType> MESSAGE_TYPE_ID = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"styled_chat", (String)"generic_hack"));

    public static ChatType getMessageType() {
        return (ChatType)server.registryAccess().registryOrThrow(Registries.CHAT_TYPE).getOrThrow(MESSAGE_TYPE_ID);
    }

    public StyledChatMod(IEventBus modBus, ModContainer container) {
        StyledChatMod.crabboardDetection();
        GenericModInfo.build(container);
        PlayerDataApi.register(StyledChatUtils.PLAYER_DATA);
        Placeholders.registerChangeEvent((id, removed) -> ConfigManager.clearCached());
    }

    public static void serverStarting(MinecraftServer s) {
        StyledChatMod.crabboardDetection();
        ConfigManager.loadConfig((HolderLookup.Provider)s.registryAccess());
        server = s;
    }

    public static void serverStopped(MinecraftServer s) {
        server = null;
    }

    private static void crabboardDetection() {
        if (ModList.get().isLoaded("cardboard")) {
            LOGGER.error("");
            LOGGER.error("Cardboard detected! This mod doesn't work with it!");
            LOGGER.error("You won't get any support as long as it's present!");
            LOGGER.error("");
            LOGGER.error("Read more: https://gist.github.com/Patbox/e44844294c358b614d347d369b0fc3bf");
            LOGGER.error("");
        }
    }
}

