/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.showcaseitem;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ultramega.showcaseitem.ModKeyBindings;
import com.ultramega.showcaseitem.config.Config;
import com.ultramega.showcaseitem.network.ShareItemData;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="showcaseitem", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ShowcaseItemFeature {
    public static float alphaValue = 1.0f;
    private static long lastShadeTimestamp = -1L;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
        if (!Config.renderItemsInChat) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        StringBuilder before = new StringBuilder();
        int halfSpace = mc.font.width(" ") / 2;
        sequence.accept((counter_, style, character) -> {
            String sofar = before.toString();
            if (sofar.endsWith("  ")) {
                ShowcaseItemFeature.render(mc, guiGraphics, sofar.substring(0, sofar.length() - 2), character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                return false;
            }
            before.append((char)character);
            return true;
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void keyboardEvent(ScreenEvent.KeyPressed.Pre event) {
        if (ModKeyBindings.SHOWCASE_ITEM.isUnbound()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)ModKeyBindings.SHOWCASE_ITEM.getKey().getValue()) && ShowcaseItemFeature.keyModifierPressed(mc)) {
            ShowcaseItemFeature.keyPressed();
        }
    }

    public static void keyPressed() {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof AbstractContainerScreen) {
            ItemStack stack;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            List children = gui.children();
            for (GuiEventListener c : children) {
                EditBox tf;
                if (!(c instanceof EditBox) || !(tf = (EditBox)c).isFocused()) continue;
                return;
            }
            Slot slot = gui.getSlotUnderMouse();
            if (slot != null && !(stack = slot.getItem()).isEmpty()) {
                if (mc.level == null || mc.level.getGameTime() - lastShadeTimestamp <= 10L) {
                    return;
                }
                lastShadeTimestamp = mc.level.getGameTime();
                PacketDistributor.sendToServer((CustomPacketPayload)new ShareItemData(slot.getSlotIndex(), gui.getMenu().containerId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void shareItem(ServerPlayer player, int slotIndex, int containerId) {
        if (player.containerMenu.containerId != containerId) {
            return;
        }
        NonNullList slots = player.containerMenu.slots;
        if (slotIndex >= 0 && slots.size() > slotIndex) {
            ItemStack stack;
            if (player.containerMenu instanceof InventoryMenu) {
                stack = player.getInventory().getItem(slotIndex);
            } else {
                Slot slot = (Slot)slots.get(slotIndex);
                stack = slot.getItem();
            }
            if (!stack.isEmpty()) {
                MutableComponent message = Component.translatable((String)"showcaseitem.misc.shared_item", (Object[])new Object[]{player.getName()}).append(stack.getDisplayName());
                player.server.getPlayerList().getPlayers().forEach(p -> p.sendSystemMessage((Component)message));
            }
        }
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!Config.renderItemsInChat) {
            return component;
        }
        Style style = component.getStyle();
        if (stack.getCount() > 64) {
            ItemStack copyStack = stack.copy();
            copyStack.setCount(64);
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(copyStack)));
            component.withStyle(style);
        }
        MutableComponent out = Component.literal((String)"   ");
        out.setStyle(style);
        return out.append((Component)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(Minecraft mc, GuiGraphics graphics, String before, float extraShift, float x, float y, Style style, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        HoverEvent hoverEvent = style.getHoverEvent();
        if (hoverEvent != null && hoverEvent.getAction() == HoverEvent.Action.SHOW_ITEM) {
            LocalPlayer player;
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.getValue(HoverEvent.Action.SHOW_ITEM);
            ItemStack itemStack = stack = contents != null ? contents.getItemStack() : ItemStack.EMPTY;
            if (stack.isEmpty()) {
                stack = new ItemStack((ItemLike)Blocks.BARRIER);
            }
            float shift = (float)mc.font.width(before) + extraShift;
            if (ModList.get().isLoaded("overflowingbars") && (player = Minecraft.getInstance().player) != null) {
                y += player.getAbsorptionAmount() > 10.0f ? 10.0f : 0.0f;
                y += (float)player.getArmorValue() > 0.5f ? 10.0f : 0.0f;
            }
            if (a > 0.0f) {
                alphaValue = a;
                PoseStack pose = graphics.pose();
                pose.pushPose();
                pose.translate(shift + x + (float)mc.font.width("  ") / 2.0f, y, 0.0f);
                pose.scale(0.5f, 0.5f, 0.5f);
                graphics.renderItem(stack, 0, 0);
                pose.popPose();
                RenderSystem.applyModelViewMatrix();
                alphaValue = 1.0f;
            }
        }
    }

    private static boolean keyModifierPressed(Minecraft mc) {
        int keyModifierInt = ShowcaseItemFeature.checkLeftKeyModifier();
        int keyModifierInt2 = ShowcaseItemFeature.checkRightKeyModifier();
        if (keyModifierInt != -1) {
            return InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)keyModifierInt);
        }
        if (keyModifierInt2 != -1) {
            return InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)keyModifierInt2);
        }
        return true;
    }

    private static int checkLeftKeyModifier() {
        KeyModifier keyModifier = ModKeyBindings.SHOWCASE_ITEM.getKeyModifier();
        int keyModifierInt = -1;
        if (keyModifier.equals((Object)KeyModifier.CONTROL)) {
            keyModifierInt = 341;
        } else if (keyModifier.equals((Object)KeyModifier.ALT)) {
            keyModifierInt = 342;
        } else if (keyModifier.equals((Object)KeyModifier.SHIFT)) {
            keyModifierInt = 340;
        }
        return keyModifierInt;
    }

    private static int checkRightKeyModifier() {
        KeyModifier keyModifier = ModKeyBindings.SHOWCASE_ITEM.getKeyModifier();
        int keyModifierInt = -1;
        if (keyModifier.equals((Object)KeyModifier.CONTROL)) {
            keyModifierInt = 345;
        } else if (keyModifier.equals((Object)KeyModifier.ALT)) {
            keyModifierInt = 346;
        } else if (keyModifier.equals((Object)KeyModifier.SHIFT)) {
            keyModifierInt = 344;
        }
        return keyModifierInt;
    }
}

