/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.multiloader.S2CPacket;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrackCouplerClientInfoPacket
implements S2CPacket {
    final BlockPos blockPos;
    final CompoundTag infoTag;

    public TrackCouplerClientInfoPacket(TrackCouplerBlockEntity te) {
        this.blockPos = te.getBlockPos();
        TrackCouplerBlockEntity.ClientInfo info = te.getClientInfo();
        RegistryAccess lookupProvider = te.getLevel() != null ? te.getLevel().registryAccess() : null;
        this.infoTag = info.write((HolderLookup.Provider)(lookupProvider != null ? lookupProvider : HolderLookup.Provider.create(Stream.empty())));
    }

    public TrackCouplerClientInfoPacket(FriendlyByteBuf buf) {
        this.blockPos = buf.readBlockPos();
        this.infoTag = buf.readNbt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.blockPos);
        buffer.writeNbt((Tag)this.infoTag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        BlockEntity te;
        ClientLevel level = mc.level;
        if (level != null && (te = level.getBlockEntity(this.blockPos)) instanceof TrackCouplerBlockEntity) {
            TrackCouplerBlockEntity couplerTile = (TrackCouplerBlockEntity)te;
            RegistryAccess lookupProvider = level.registryAccess();
            TrackCouplerBlockEntity.ClientInfo info = new TrackCouplerBlockEntity.ClientInfo(this.infoTag, (HolderLookup.Provider)lookupProvider);
            couplerTile.setClientInfo(info);
        }
    }
}

