/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class ClientTextUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static Component getComponentWithWidthCutoff(Component component, int maxWidth) {
        Font font = Minecraft.getInstance().font;
        if (font.width((FormattedText)component) > maxWidth) {
            Object substr = font.plainSubstrByWidth(component.getString(), maxWidth);
            substr = ((String)substr).endsWith(" ") ? ((String)substr).substring(0, ((String)substr).length() - 1) + "..." : (String)substr + "...";
            return Component.literal((String)substr);
        }
        return component;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderMultilineDebugText(PoseStack poseStack, MultiBufferSource buffer, int packedLight, double baseY, boolean transparent, String ... lines) {
        double y = baseY + (double)lines.length / 4.0;
        for (String line : lines) {
            ClientTextUtils.renderDebugText(poseStack, buffer, packedLight, y, transparent, line);
            y -= 0.25;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderDebugText(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, double y, boolean transparent, String text) {
        poseStack.pushPose();
        poseStack.translate(0.0, y, 0.0);
        poseStack.mulPose(Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.rotation());
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f2 = -font.width(text) / 2;
        font.drawInBatch(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, pBuffer, transparent ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, pPackedLight);
        if (transparent) {
            font.drawInBatch(text, f2, 0.0f, -1, false, matrix4f, pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
        }
        poseStack.popPose();
    }
}

