/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class TrainInfoCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"train_uuid").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String trainName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            long count = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(trainName)).count();
            Train train = Create.RAILWAYS.trains.values().stream().filter(t -> t.name.getString().equals(trainName)).findFirst().orElse(null);
            if (train == null) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("No Train with name " + trainName + " was found")));
                return 0;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Train '").append(train.name).append("' has UUID: " + String.valueOf(train.id) + ", " + count + ", total trains found.").append((Component)Component.literal((String)" [Copy]").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, train.id.toString())))), true);
            return 1;
        }));
    }
}

