/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRItems;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ConductorDemoCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"conductor_demo").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> {
            ItemStack capStack;
            BlockPos origin = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            BlockPos.MutableBlockPos pos = origin.mutable();
            HashSet<String> customCapNames = new HashSet<String>();
            customCapNames.addAll(CRBlockPartials.CUSTOM_CONDUCTOR_CAPS.keySet());
            customCapNames.addAll(CRBlockPartials.CUSTOM_CONDUCTOR_SKINS.keySet());
            Set<String> customConductorNames = CRBlockPartials.CUSTOM_CONDUCTOR_SKINS_FOR_NAME.keySet();
            int i = 0;
            for (String name : customCapNames) {
                capStack = CRItems.ITEM_CONDUCTOR_CAP.get(DyeColor.values()[i++ % DyeColor.values().length]).asStack();
                capStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
                ConductorDemoCommand.spawnConductor((Level)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, capStack, null);
                pos.move(Direction.NORTH);
            }
            for (String name : customConductorNames) {
                capStack = CRItems.ITEM_CONDUCTOR_CAP.get(DyeColor.values()[i++ % DyeColor.values().length]).asStack();
                ConductorDemoCommand.spawnConductor((Level)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)pos, capStack, name);
                pos.move(Direction.NORTH);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Spawned custom conductors"), true);
            return 1;
        }));
    }

    private static void spawnConductor(Level level, BlockPos pos, ItemStack headStack, @Nullable String name) {
        ConductorEntity conductor = ConductorEntity.spawn(level, pos, headStack);
        if (conductor != null && name != null) {
            conductor.setCustomName((Component)Component.literal((String)name));
            conductor.setCustomNameVisible(true);
        }
    }
}

