/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticleData;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import com.railwayteam.railways.registry.neoforge.CRParticleTypesParticleEntryImpl;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

public enum CRParticleTypes {
    SMOKE(SmokeParticleData::new),
    SMOKE_PUFF_SMALL(PuffSmokeParticleData.Small::new),
    SMOKE_PUFF_MEDIUM(PuffSmokeParticleData.Medium::new),
    CHIMNEYPUSH_SMALL(ChimneyPushParticleData.Small::new),
    CHIMNEYPUSH_MEDIUM(ChimneyPushParticleData.Medium::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> CRParticleTypes(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        String name = Lang.asId((String)this.name());
        this.entry = new ParticleEntry(name, typeFactory);
    }

    public ParticleType<?> get() {
        return this.entry.object;
    }

    public String parameter() {
        return this.entry.name;
    }

    public static void init() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (CRParticleTypes particle : CRParticleTypes.values()) {
            particle.entry.registerFactory(event);
        }
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final ParticleType<D> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = this.typeFactory.get().createType();
            ParticleEntry.register(name, () -> this.object);
        }

        private static void register(String id, Supplier<ParticleType<?>> supplier) {
            CRParticleTypesParticleEntryImpl.register(id, supplier);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(RegisterParticleProvidersEvent event) {
            ParticleEntry.registerFactory(this.object, event, this.typeFactory.get());
        }

        @OnlyIn(value=Dist.CLIENT)
        private static <T extends ParticleOptions> void registerFactory(ParticleType<T> object, RegisterParticleProvidersEvent event, ICustomParticleData<T> customParticleData) {
            CRParticleTypesParticleEntryImpl.registerFactory(object, event, customParticleData);
        }
    }
}

