/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge.events;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.fuel.LiquidFuelManager;
import com.railwayteam.railways.events.CommonEvents;
import com.railwayteam.railways.neoforge.events.ConductorItemHandler;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.neoforge.CRBlockEntitiesImpl;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber
public class CommonEventsForge {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre event) {
        CommonEvents.onWorldTickStart(event.getLevel());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CommonEvents.onPlayerJoin(player2);
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CRBlockEntitiesImpl.FUEL_TANK.get(), (be, side) -> be.getFluidHandler((Direction)side));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CRBlockEntitiesImpl.PORTABLE_FUEL_INTERFACE.get(), (be, side) -> be.getFluidHandler((Direction)side));
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)CREntities.CONDUCTOR.get(), (entity, context) -> new ConductorItemHandler((ConductorEntity)((Object)entity)));
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
            CommonEvents.onTagsUpdated();
        }
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)LiquidFuelManager.ReloadListener.INSTANCE);
    }
}

