/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge.client.track;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;

public class FullShapeDestroyEffects
implements IClientBlockExtensions {
    public static final FullShapeDestroyEffects INSTANCE = new FullShapeDestroyEffects();
    private static final int DESTROY_PARTICLE_COUNT = 64;

    private FullShapeDestroyEffects() {
    }

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
        if (state.getRenderShape() == RenderShape.INVISIBLE) {
            return true;
        }
        FullShapeDestroyEffects.spawnParticlesFromShape(state, level, pos, level.getRandom(), 64);
        return true;
    }

    private static void spawnParticlesFromShape(BlockState state, Level level, BlockPos pos, RandomSource random, int count) {
        VoxelShape shape = state.getShape((BlockGetter)level, pos);
        ArrayList<AABB> aabbs = new ArrayList<AABB>(shape.toAabbs());
        if (aabbs.isEmpty()) {
            aabbs.add(shape.bounds());
        }
        double totalVolume = 0.0;
        double[] cumulative = new double[aabbs.size()];
        for (int i = 0; i < aabbs.size(); ++i) {
            AABB bb = (AABB)aabbs.get(i);
            double v = bb.getXsize() * bb.getYsize() * bb.getZsize();
            v = Math.max(v, 1.0E-6);
            cumulative[i] = totalVolume += v;
        }
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.BLOCK, state);
        for (int i = 0; i < count; ++i) {
            AABB bb = FullShapeDestroyEffects.pickAabbWeighted(aabbs, cumulative, totalVolume, random);
            double x = (double)pos.getX() + Mth.lerp((double)random.nextDouble(), (double)bb.minX, (double)bb.maxX);
            double y = (double)pos.getY() + Mth.lerp((double)random.nextDouble(), (double)bb.minY, (double)bb.maxY);
            double z = (double)pos.getZ() + Mth.lerp((double)random.nextDouble(), (double)bb.minZ, (double)bb.maxZ);
            double vx = (random.nextDouble() - 0.5) * 0.15;
            double vy = (random.nextDouble() - 0.5) * 0.15;
            double vz = (random.nextDouble() - 0.5) * 0.15;
            level.addParticle((ParticleOptions)particle, x, y, z, vx, vy, vz);
        }
    }

    private static AABB pickAabbWeighted(List<AABB> aabbs, double[] cumulative, double totalVolume, RandomSource random) {
        double r = random.nextDouble() * totalVolume;
        int idx = Arrays.binarySearch(cumulative, r);
        if (idx < 0) {
            idx = -idx - 1;
        }
        idx = Mth.clamp((int)idx, (int)0, (int)(aabbs.size() - 1));
        return aabbs.get(idx);
    }
}

