/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.RailwaysClient;
import com.railwayteam.railways.content.conductor.ConductorCapHumanoidLayer;
import com.railwayteam.railways.content.conductor.ConductorRenderer;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerRenderer;
import com.railwayteam.railways.content.fuel.tank.FuelTankRenderer;
import com.railwayteam.railways.content.semaphore.SemaphoreRenderer;
import com.railwayteam.railways.content.switches.TrackSwitchRenderer;
import com.railwayteam.railways.neoforge.RailwaysImpl;
import com.railwayteam.railways.neoforge.client.track.FullShapeDestroyEffects;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.railwayteam.railways.registry.neoforge.CRBlockEntitiesImpl;
import com.simibubi.create.content.contraptions.actors.psi.PSIVisual;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.trains.bogey.BogeyBlockEntityRenderer;
import com.simibubi.create.content.trains.bogey.BogeyBlockEntityVisual;
import com.simibubi.create.content.trains.track.TrackBlock;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import dev.engine_room.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;

@EventBusSubscriber(value={Dist.CLIENT})
public class RailwaysClientImpl {
    private static final Set<Consumer<CommandDispatcher<SharedSuggestionProvider>>> clientCommandConsumers = new HashSet<Consumer<CommandDispatcher<SharedSuggestionProvider>>>();
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> modelLayers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
    private static final List<PackInfo> packs = new ArrayList<PackInfo>();

    public static void init() {
        RailwaysClient.init();
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onModelLayerRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onBuiltinPackRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onParticleProviderRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onRendererRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onAddLayers);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onClientExtensionsRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onBlockColorHandlerRegistration);
        RailwaysImpl.bus.addListener(RailwaysClientImpl::onClientSetup);
    }

    private static void onBlockColorHandlerRegistration(RegisterColorHandlersEvent.Block event) {
        event.register(CopycatBlock.wrappedColor(), new Block[]{(Block)CRBlocks.COPYCAT_HEADSTOCK.get(), (Block)CRBlocks.COPYCAT_HEADSTOCK_BARS.get()});
    }

    private static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model skin : event.getSkins()) {
            EntityRenderer renderer = event.getSkin(skin);
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.addLayer(new ConductorCapHumanoidLayer(playerRenderer));
        }
        EntityRenderer armorStand = event.getRenderer(EntityType.ARMOR_STAND);
        if (armorStand instanceof ArmorStandRenderer) {
            ArmorStandRenderer armorStandRenderer = (ArmorStandRenderer)armorStand;
            armorStandRenderer.addLayer(new ConductorCapHumanoidLayer(armorStandRenderer));
        }
    }

    private static void onClientExtensionsRegistration(RegisterClientExtensionsEvent event) {
        ArrayList blocks = new ArrayList();
        BuiltInRegistries.BLOCK.entrySet().forEach(entry -> {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            Block block = (Block)entry.getValue();
            if ("railways".equals(id.getNamespace()) && block instanceof TrackBlock) {
                blocks.add(block);
            }
        });
        if (!blocks.isEmpty()) {
            event.registerBlock((IClientBlockExtensions)FullShapeDestroyEffects.INSTANCE, (Block[])blocks.toArray(Block[]::new));
        }
    }

    private static void onParticleProviderRegistration(RegisterParticleProvidersEvent event) {
        CRParticleTypes.registerFactories(event);
    }

    private static void onRendererRegistration(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.SEMAPHORE.get(), SemaphoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.ANDESITE_SWITCH.get(), TrackSwitchRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.BRASS_SWITCH.get(), TrackSwitchRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntitiesImpl.FUEL_TANK.get(), FuelTankRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.TRACK_COUPLER.get(), TrackCouplerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.BOGEY.get(), BogeyBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.MONO_BOGEY.get(), BogeyBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.INVISIBLE_BOGEY.get(), BogeyBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)CRBlockEntities.INVISIBLE_MONO_BOGEY.get(), BogeyBlockEntityRenderer::new);
        event.registerEntityRenderer((EntityType)CREntities.CONDUCTOR.get(), ConductorRenderer::new);
        event.registerEntityRenderer((EntityType)CREntities.CART_BLOCK.get(), ctx -> new MinecartRenderer(ctx, ModelLayers.MINECART));
        event.registerEntityRenderer((EntityType)CREntities.CART_JUKEBOX.get(), ctx -> new MinecartRenderer(ctx, ModelLayers.MINECART));
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            SimpleBlockEntityVisualizer visualizer = new SimpleBlockEntityVisualizer(BogeyBlockEntityVisual::new, be -> true);
            VisualizerRegistry.setVisualizer((BlockEntityType)((BlockEntityType)CRBlockEntities.BOGEY.get()), (BlockEntityVisualizer)visualizer);
            VisualizerRegistry.setVisualizer((BlockEntityType)((BlockEntityType)CRBlockEntities.MONO_BOGEY.get()), (BlockEntityVisualizer)visualizer);
            VisualizerRegistry.setVisualizer((BlockEntityType)((BlockEntityType)CRBlockEntities.INVISIBLE_BOGEY.get()), (BlockEntityVisualizer)visualizer);
            VisualizerRegistry.setVisualizer((BlockEntityType)((BlockEntityType)CRBlockEntities.INVISIBLE_MONO_BOGEY.get()), (BlockEntityVisualizer)visualizer);
            SimpleBlockEntityVisualizer psiVisualizer = new SimpleBlockEntityVisualizer((visualizationContext, be, partialTick) -> new PSIVisual(visualizationContext, (PortableStorageInterfaceBlockEntity)be, partialTick), be -> true);
            VisualizerRegistry.setVisualizer((BlockEntityType)((BlockEntityType)CRBlockEntitiesImpl.PORTABLE_FUEL_INTERFACE.get()), (BlockEntityVisualizer)psiVisualizer);
        });
    }

    public static void registerClientCommands(Consumer<CommandDispatcher<SharedSuggestionProvider>> consumer) {
        clientCommandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onClientCommandRegistration(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher;
        CommandDispatcher casted = dispatcher = event.getDispatcher();
        clientCommandConsumers.forEach(consumer -> consumer.accept(casted));
    }

    public static void registerModelLayer(ModelLayerLocation layer, Supplier<LayerDefinition> definition) {
        modelLayers.put(layer, definition);
    }

    public static void onModelLayerRegistration(EntityRenderersEvent.RegisterLayerDefinitions event) {
        modelLayers.forEach((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
        modelLayers.clear();
    }

    public static void registerBuiltinPack(String id, String name) {
        packs.add(new PackInfo(id, name));
    }

    public static void onBuiltinPackRegistration(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        packs.forEach(pack -> {
            try {
                IModFileInfo modFile = ModList.get().getModFileById("railways");
                if (modFile == null) {
                    Railways.LOGGER.error("Could not find mod file for railways");
                    return;
                }
                final Path resourcePath = modFile.getFile().findResource(new String[]{"resourcepacks/" + pack.id});
                event.addRepositorySource(consumer -> {
                    PackSelectionConfig selectionConfig;
                    PackLocationInfo packInfo = new PackLocationInfo(Railways.asResource(pack.id).toString(), (Component)Component.literal((String)pack.name), PackSource.BUILT_IN, Optional.empty());
                    Pack newPack = Pack.readMetaAndCreate((PackLocationInfo)packInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                        public PathPackResources openPrimary(PackLocationInfo info) {
                            return new PathPackResources(info, resourcePath);
                        }

                        public PathPackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                            return new PathPackResources(info, resourcePath);
                        }
                    }, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)(selectionConfig = new PackSelectionConfig(false, Pack.Position.TOP, false)));
                    if (newPack != null) {
                        consumer.accept(newPack);
                    }
                });
            }
            catch (Exception e) {
                Railways.LOGGER.error("Failed to register built-in pack: " + pack.id, (Throwable)e);
            }
        });
        packs.clear();
    }

    private record PackInfo(String id, String name) {
    }
}

