/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPlacement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={TrackPlacement.class}, remap=false)
public class MixinTrackPlacementClient {
    private static final double RAIL_OFFSET_STANDARD = 0.9375;
    private static final double RAIL_OFFSET_WIDE_ADD = 0.5;
    private static final double RAIL_OFFSET_NARROW_SUB = 0.4375;

    @ModifyArg(method={"clientTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;scale(D)Lnet/minecraft/world/phys/Vec3;"), index=0)
    private static double railways$adjustPlacementOverlayRailOffset(double scale) {
        if (Math.abs(scale - 0.9375) > 1.0E-6) {
            return scale;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return scale;
        }
        TrackMaterial material = TrackMaterial.fromItem((Item)player.getMainHandItem().getItem());
        if (material == null) {
            return scale;
        }
        TrackMaterial.TrackType trackType = material.trackType;
        if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
            return scale + 0.5;
        }
        if (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE || trackType == CRTrackMaterials.CRTrackType.UNIVERSAL) {
            return scale - 0.4375;
        }
        return scale;
    }
}

