/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRTags;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import java.util.Map;
import net.createmod.catnip.levelWrappers.SchematicLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackBlockEntity.class}, remap=false)
public abstract class MixinTrackBlockEntity
extends SmartBlockEntity
implements IHasTrackCasing {
    @Shadow
    Map<BlockPos, BezierConnection> connections;
    protected SlabBlock trackCasing;
    protected boolean isAlternateModel;

    protected MixinTrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Nullable
    public SlabBlock getTrackCasing() {
        return this.trackCasing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setTrackCasing(@Nullable SlabBlock trackCasing) {
        if (trackCasing != null && CRTags.AllBlockTags.TRACK_CASING_BLACKLIST.matches((Block)trackCasing)) {
            return;
        }
        this.trackCasing = trackCasing;
        this.notifyUpdate();
        if (this.level == null) return;
        if (this.trackCasing == null) {
            CasingCollisionUtils.manageTracks((TrackBlockEntity)this, true);
            if (this.level.isClientSide) return;
            if (!this.connections.isEmpty() || this.getBlockState().getOptionalValue((Property)TrackBlock.SHAPE).orElse(TrackShape.NONE).isPortal()) {
                return;
            }
            BlockState blockState = this.level.getBlockState(this.worldPosition);
            if (blockState.hasProperty((Property)TrackBlock.HAS_BE)) {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)blockState.setValue((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
            }
            if (this.level instanceof SchematicLevel) return;
        }
        if (trackCasing == null || this.isAlternateModel) return;
        CasingCollisionUtils.manageTracks((TrackBlockEntity)this, false);
    }

    @Override
    public boolean isAlternate() {
        return this.isAlternateModel;
    }

    @Override
    public void setAlternate(boolean alternate) {
        if (((TrackShape)this.getBlockState().getValue((Property)TrackBlock.SHAPE)).getModel().equals("ascending")) {
            alternate = false;
        }
        this.isAlternateModel = alternate;
        if (this.trackCasing != null) {
            CasingCollisionUtils.manageTracks((TrackBlockEntity)this, alternate);
        }
        this.notifyUpdate();
    }

    @Inject(method={"removeConnection"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", remap=true)}, cancellable=true)
    private void preventTileRemoval(BlockPos target, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            this.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"removeInboundConnections"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/blockEntity/RemoveBlockEntityPacket;<init>(Lnet/minecraft/core/BlockPos;)V", remap=true)}, cancellable=true)
    private void preventTileRemoval2(CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            this.notifyUpdate();
            ci.cancel();
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeCasing(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        if (this.getTrackCasing() != null) {
            tag.putString("TrackCasing", BuiltInRegistries.BLOCK.getKey((Object)this.getTrackCasing()).toString());
        }
        tag.putBoolean("AlternateModel", this.isAlternate());
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void readCasing(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        Block casingBlock;
        ResourceLocation casingName;
        if (tag.contains("AlternateModel")) {
            this.setAlternate(tag.getBoolean("AlternateModel"));
        } else {
            this.setAlternate(false);
        }
        if (tag.contains("TrackCasing") && BuiltInRegistries.BLOCK.containsKey(casingName = ResourceLocation.tryParse((String)tag.getString("TrackCasing"))) && (casingBlock = (Block)BuiltInRegistries.BLOCK.get(casingName)) instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)casingBlock;
            this.setTrackCasing(slab);
            return;
        }
        this.setTrackCasing(null);
    }

    @Inject(method={"lazyTick"}, at={@At(value="HEAD")})
    private void manageCasingCollisions(CallbackInfo ci) {
        if (this.trackCasing == null || this.isAlternateModel) {
            return;
        }
        CasingCollisionUtils.manageTracks((TrackBlockEntity)this, false);
    }
}

