/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StationBlock.class}, remap=false)
public abstract class MixinStationBlock {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void autoWhistle(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemInHand = pPlayer.getItemInHand(pHand);
        if (CRBlocks.CONDUCTOR_WHISTLE_FLAG.asStack().getItem().equals(itemInHand.getItem())) {
            BlockEntity blockEntity;
            if (!pLevel.isClientSide && pPlayer instanceof DeployerFakePlayer && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof StationBlockEntity) {
                StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
                cir.setReturnValue((Object)InteractionResult.CONSUME);
                GlobalStation station = stationBe.getStation();
                if (station != null && station.getPresentTrain() == null) {
                    ItemStack scheduleStack;
                    CustomData custom = (CustomData)itemInHand.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
                    CompoundTag stackTag = custom.copyTag();
                    if (stackTag == null || !stackTag.hasUUID("SelectedTrain") || !stackTag.hasUUID("SelectedConductor")) {
                        cir.setReturnValue((Object)InteractionResult.FAIL);
                        return;
                    }
                    BlockPos pos = stationBe.edgePoint.getPos();
                    Level level = pPlayer.level();
                    UUID trainId = stackTag.getUUID("SelectedTrain");
                    UUID conductorId = stackTag.getUUID("SelectedConductor");
                    Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                    if (!Create.RAILWAYS.trains.containsKey(trainId)) {
                        return;
                    }
                    boolean foundConductor = false;
                    Carriage conductorCarriage = null;
                    if (train == null) {
                        return;
                    }
                    for (Object carriage : train.carriages) {
                        if (!((ICarriageConductors)carriage).railways$getControllingConductors().contains(conductorId)) continue;
                        foundConductor = true;
                        conductorCarriage = carriage;
                        break;
                    }
                    if (!foundConductor) {
                        return;
                    }
                    stackTag.put("SelectedPos", NbtUtils.writeBlockPos((BlockPos)pos));
                    stackTag.remove("Bezier");
                    itemInHand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                    if (((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != pPlayer) {
                        stackTag.remove("SelectedPos");
                        itemInHand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                        return;
                    }
                    if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule((HolderLookup.Provider)pLevel.registryAccess())).isEmpty()) {
                        for (CompoundTag passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                            ListTag schedulesList;
                            if (passengerTag.contains("PlayerPassenger") || !passengerTag.contains("id") || !CREntities.CONDUCTOR.getId().equals((Object)ResourceLocation.parse((String)passengerTag.getString("id"))) || !passengerTag.hasUUID("UUID") || !passengerTag.getUUID("UUID").equals(conductorId)) continue;
                            if (!passengerTag.contains("heldSchedules")) {
                                schedulesList = new ListTag();
                                passengerTag.put("heldSchedules", (Tag)schedulesList);
                            } else {
                                schedulesList = passengerTag.getList("heldSchedules", 10);
                            }
                            schedulesList.add((Object)scheduleStack.save((HolderLookup.Provider)pLevel.registryAccess()));
                            scheduleStack.setCount(0);
                            break;
                        }
                        if (!scheduleStack.isEmpty()) {
                            conductorCarriage.forEachPresentEntity(cce -> {
                                if (!scheduleStack.isEmpty()) {
                                    for (Entity passenger : cce.getPassengers()) {
                                        if (!(passenger instanceof ConductorEntity)) continue;
                                        ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                        if (!passenger.getUUID().equals(conductorId)) continue;
                                        conductorEntity.addSchedule(scheduleStack);
                                        scheduleStack.setCount(0);
                                        break;
                                    }
                                }
                            });
                        }
                        if (!scheduleStack.isEmpty() && !pPlayer.addItem(scheduleStack)) {
                            pPlayer.drop(scheduleStack, false);
                        }
                    }
                    Schedule schedule = new Schedule();
                    ScheduleEntry entry = new ScheduleEntry();
                    DestinationInstruction instruction = new DestinationInstruction();
                    ScheduledDelay condition = new ScheduledDelay();
                    condition.getData().putInt("Value", 0);
                    instruction.getData().putString("Text", station.name);
                    entry.instruction = instruction;
                    if (entry.conditions.isEmpty()) {
                        entry.conditions.add(new ArrayList());
                    }
                    ((List)entry.conditions.get(0)).add(condition);
                    schedule.entries.add(entry);
                    schedule.cyclic = false;
                    train.runtime.setSchedule(schedule, true);
                    ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                } else if (station != null && station.getPresentTrain() != null) {
                    UUID trainId = station.getPresentTrain().id;
                    Train train = (Train)Create.RAILWAYS.trains.get(trainId);
                    if (train == null) {
                        return;
                    }
                    AtomicBoolean found = new AtomicBoolean(false);
                    for (Carriage carriage : train.carriages) {
                        carriage.forEachPresentEntity(e -> e.getIndirectPassengers().forEach(p -> {
                            if (p instanceof ConductorEntity) {
                                ConductorEntity conductor = (ConductorEntity)((Object)((Object)p));
                                if (!found.get()) {
                                    CompoundTag stackTag = new CompoundTag();
                                    stackTag.putUUID("SelectedTrain", train.id);
                                    stackTag.putUUID("SelectedConductor", conductor.getUUID());
                                    stackTag.putByte("SelectedColor", ((Byte)conductor.getEntityData().get(ConductorEntity.COLOR)).byteValue());
                                    itemInHand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                                    pPlayer.setItemInHand(pHand, itemInHand);
                                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                                    found.set(true);
                                }
                            }
                        }));
                    }
                }
            }
            if (CRBlocks.CONDUCTOR_WHISTLE_FLAG.isIn(itemInHand)) {
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=true)
    private void deployersAssemble(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!pLevel.isClientSide && pPlayer instanceof DeployerFakePlayer) {
            DeployerFakePlayer deployerFakePlayer = (DeployerFakePlayer)pPlayer;
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof StationBlockEntity) {
                StationBlockEntity stationBe = (StationBlockEntity)blockEntity;
                cir.setReturnValue((Object)InteractionResult.CONSUME);
                GlobalStation station = stationBe.getStation();
                boolean isAssemblyMode = (Boolean)pState.getValue((Property)StationBlock.ASSEMBLING);
                if (station != null && station.getPresentTrain() == null) {
                    if (stationBe.isAssembling() || stationBe.tryEnterAssemblyMode()) {
                        stationBe.assemble(deployerFakePlayer.getUUID());
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        if (isAssemblyMode) {
                            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false)), 3);
                            stationBe.refreshBlockState();
                        }
                    }
                    return;
                }
                BlockState newState = null;
                if (!isAssemblyMode) {
                    newState = (BlockState)pState.setValue((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
                }
                if (this.disassembleAndEnterMode((ServerPlayer)deployerFakePlayer, stationBe)) {
                    if (newState != null) {
                        pLevel.setBlock(pPos, newState, 3);
                        stationBe.refreshBlockState();
                        stationBe.refreshAssemblyInfo();
                    }
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }

    private boolean disassembleAndEnterMode(ServerPlayer sender, StationBlockEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            ItemStack schedule;
            Train train = station.getPresentTrain();
            BlockPos trackPosition = te.edgePoint.getGlobalPosition();
            ItemStack itemStack = schedule = train == null ? ItemStack.EMPTY : train.runtime.returnSchedule((HolderLookup.Provider)te.getLevel().registryAccess());
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.above())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(ServerPlayer sender, StationBlockEntity te, ItemStack schedule) {
        if (schedule.isEmpty()) {
            return;
        }
        if (sender.getMainHandItem().isEmpty()) {
            sender.getInventory().placeItemBackInInventory(schedule);
            return;
        }
        Vec3 v = VecHelper.getCenterOf((Vec3i)te.getBlockPos());
        ItemEntity itemEntity = new ItemEntity(te.getLevel(), v.x, v.y, v.z, schedule);
        itemEntity.setDeltaMovement(Vec3.ZERO);
        te.getLevel().addFreshEntity((Entity)itemEntity);
    }
}

