/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.IConductorHoldingFakePlayer;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockCheckableNavigation;
import com.railwayteam.railways.mixin_interfaces.IBufferBlockedTrain;
import com.railwayteam.railways.mixin_interfaces.ICarriageBufferDistanceTracker;
import com.railwayteam.railways.mixin_interfaces.IDistanceTravelled;
import com.railwayteam.railways.mixin_interfaces.IGenerallySearchableNavigation;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.BlockPosUtils;
import com.railwayteam.railways.util.MixinVariables;
import com.railwayteam.railways.util.packet.SwitchDataUpdatePacket;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarriageContraptionEntity.class}, remap=false)
public abstract class MixinCarriageContraptionEntity
extends OrientedContraptionEntity
implements IDistanceTravelled {
    @Shadow
    private Carriage carriage;
    @Unique
    private boolean railways$fakePlayer = false;
    @Unique
    private double railways$distanceTravelled;
    @Unique
    boolean railways$switchMessage = false;

    private MixinCarriageContraptionEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"control"}, at={@At(value="HEAD")})
    private void recordFakePlayer(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (player.getGameProfile() == ConductorEntity.FAKE_PLAYER_PROFILE) {
            this.railways$fakePlayer = true;
        }
    }

    @WrapOperation(method={"control"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;closerThan(Lnet/minecraft/core/Position;D)Z", remap=true)})
    private boolean railways$closerThan(Vec3 instance, Position pos, double distance, Operation<Boolean> original) {
        if (this.railways$fakePlayer) {
            this.railways$fakePlayer = false;
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, pos, distance});
    }

    @WrapOperation(method={"control"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;throttle:D", opcode=180)})
    private double conductorSpeedControl(Train instance, Operation<Double> original, BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player) {
        IConductorHoldingFakePlayer conductorHolder;
        if (player instanceof IConductorHoldingFakePlayer && (conductorHolder = (IConductorHoldingFakePlayer)player).getConductor() != null) {
            return (double)conductorHolder.getConductor().getForwardSignalStrength() / 15.0;
        }
        return (Double)original.call(new Object[]{instance});
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;maxSpeed()F")})
    private void showSwitchOverlay(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir) {
        Optional targetState;
        Navigation nav = this.carriage.train.navigation;
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)this.contraption.getBlocks().get(controlsLocalPos);
        Direction initialOrientation = this.getInitialOrientation().getCounterClockWise();
        boolean inverted = false;
        if (info != null && info.state().hasProperty((Property)ControlsBlock.FACING)) {
            inverted = !((Direction)info.state().getValue((Property)ControlsBlock.FACING)).equals((Object)initialOrientation);
        }
        int targetSpeed = 0;
        if (heldControls.contains(0)) {
            ++targetSpeed;
        }
        if (heldControls.contains(1)) {
            --targetSpeed;
        }
        if (inverted) {
            targetSpeed *= -1;
        }
        boolean spaceDown = heldControls.contains(4);
        double directedSpeed = targetSpeed != 0 ? (double)targetSpeed : this.carriage.train.speed;
        MixinVariables.temporarilySkipSwitches = true;
        boolean forward = !this.carriage.train.doubleEnded || (directedSpeed != 0.0 ? directedSpeed > 0.0 : !inverted);
        Pair<TrackSwitch, Pair<Boolean, Optional<TrackSwitchBlock.SwitchState>>> lookAheadData = ((IGenerallySearchableNavigation)nav).railways$findNearestApproachableSwitch(forward);
        MixinVariables.temporarilySkipSwitches = false;
        TrackSwitch lookAhead = lookAheadData == null ? null : (TrackSwitch)((Object)lookAheadData.getFirst());
        boolean headOn = lookAheadData != null && (Boolean)((Pair)lookAheadData.getSecond()).getFirst() != false;
        Optional optional = targetState = lookAheadData == null ? Optional.empty() : (Optional)((Pair)lookAheadData.getSecond()).getSecond();
        if (lookAhead != null) {
            if (((Boolean)CRConfigs.server().flipDistantSwitches.get()).booleanValue() && spaceDown && lookAhead.isAutomatic() && !lookAhead.isLocked() && !this.carriage.train.navigation.isActive()) {
                if (headOn) {
                    lookAhead.trySetSwitchState(TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward));
                } else {
                    targetState.ifPresent(lookAhead::trySetSwitchState);
                }
            }
            boolean wrong = headOn ? TrackSwitchBlock.SwitchState.fromSteerDirection(this.carriage.train.manualSteer, forward) != lookAhead.getSwitchState() : targetState.isPresent() && lookAhead.getSwitchState() != targetState.get();
            this.displayApproachSwitchMessage(player, lookAhead, wrong);
        } else {
            this.cleanUpApproachSwitchMessage(player);
        }
    }

    @Inject(method={"control"}, at={@At(value="TAIL")})
    private void railways$handcarHungerDepletion(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir) {
        if (((IHandcarTrain)this.carriage.train).railways$isHandcar() && !player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)AllItems.EXTENDO_GRIP.get())) {
            player.causeFoodExhaustion((float)this.carriage.train.speed * CRConfigs.server().handcarHungerMultiplier.getF());
        }
    }

    @Unique
    private void displayApproachSwitchMessage(Player player, TrackSwitch sw, boolean isWrong) {
        this.sendSwitchInfo(player, sw.getSwitchState(), sw.isAutomatic(), isWrong, sw.isLocked());
        this.railways$switchMessage = true;
    }

    @Unique
    private void cleanUpApproachSwitchMessage(Player player) {
        if (!this.railways$switchMessage) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)SwitchDataUpdatePacket.clear());
        }
        this.railways$switchMessage = false;
    }

    @Unique
    private void sendSwitchInfo(Player player, TrackSwitchBlock.SwitchState state, boolean automatic, boolean isWrong, boolean isLocked) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CRPackets.PACKETS.sendTo(sp, (S2CPacket)new SwitchDataUpdatePacket(state, automatic, isWrong, isLocked));
        }
    }

    @Inject(method={"updateTrackGraph"}, at={@At(value="FIELD", target="Lcom/simibubi/create/content/trains/entity/Train;graph:Lcom/simibubi/create/content/trains/graph/TrackGraph;", opcode=3, ordinal=0)}, cancellable=true)
    private void cancelDerailing(CallbackInfo ci) {
        if (((Boolean)CRConfigs.client().skipClientDerailing.get()).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"tickContraption"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/CarriageContraptionEntity;tickActors()V")})
    private void setupBufferDistanceData(CallbackInfo ci) {
        int leadingDistance;
        ICarriageBufferDistanceTracker distanceTracker = (ICarriageBufferDistanceTracker)this.carriage;
        if (this.level().isClientSide) {
            return;
        }
        if (distanceTracker.railways$getLeadingDistance() != null && distanceTracker.railways$getTrailingDistance() != null) {
            return;
        }
        BlockPos leadingBogeyPos = null;
        BlockPos trailingBogeyPos = null;
        CarriageContraption cc = (CarriageContraption)this.contraption;
        BlockPos maxPos = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        BlockPos minPos = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        for (Map.Entry info : this.contraption.getBlocks().entrySet()) {
            minPos = BlockPosUtils.min(minPos, (BlockPos)info.getKey());
            maxPos = BlockPosUtils.max(maxPos, (BlockPos)info.getKey());
            if (!(((StructureTemplate.StructureBlockInfo)info.getValue()).state().getBlock() instanceof AbstractBogeyBlock)) continue;
            if (leadingBogeyPos == null) {
                leadingBogeyPos = (BlockPos)info.getKey();
                continue;
            }
            if (trailingBogeyPos != null) continue;
            if (BlockPosUtils.normalize(((BlockPos)info.getKey()).subtract((Vec3i)leadingBogeyPos)).equals((Object)cc.getAssemblyDirection().getNormal())) {
                trailingBogeyPos = (BlockPos)info.getKey();
                continue;
            }
            trailingBogeyPos = leadingBogeyPos;
            leadingBogeyPos = (BlockPos)info.getKey();
        }
        Direction.Axis axis = cc.getAssemblyDirection().getAxis();
        boolean forward = cc.getAssemblyDirection().getAxisDirection() == Direction.AxisDirection.POSITIVE;
        int leadingBounds = forward ? minPos.get(axis) : maxPos.get(axis);
        int trailingBounds = forward ? maxPos.get(axis) : minPos.get(axis);
        int n = leadingDistance = leadingBogeyPos == null ? 0 : Math.abs(leadingBounds - leadingBogeyPos.get(axis));
        if (trailingBogeyPos == null) {
            trailingBogeyPos = leadingBogeyPos;
        }
        int trailingDistance = trailingBogeyPos == null ? 0 : Math.abs(trailingBounds - trailingBogeyPos.get(axis));
        distanceTracker.railways$setLeadingDistance(leadingDistance);
        distanceTracker.railways$setTrailingDistance(trailingDistance);
    }

    @Inject(method={"control"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;getCurrentStation()Lcom/simibubi/create/content/trains/station/GlobalStation;")})
    private void noBufferOverrun(BlockPos controlsLocalPos, Collection<Integer> heldControls, Player player, CallbackInfoReturnable<Boolean> cir, @Local(name={"targetSpeed"}) LocalIntRef targetSpeedRef) {
        double blockedSign;
        double targetSpeed = targetSpeedRef.get();
        if (targetSpeed == 0.0) {
            return;
        }
        IBufferBlockedTrain bufferBlockedTrain = (IBufferBlockedTrain)this.carriage.train;
        if (!bufferBlockedTrain.railways$isControlBlocked() && bufferBlockedTrain.railways$getBlockedSign() == 0 && targetSpeed < 0.0) {
            ((IBufferBlockCheckableNavigation)this.carriage.train.navigation).railways$updateControlsBlock(true);
        }
        if (bufferBlockedTrain.railways$isControlBlocked() && ((blockedSign = (double)bufferBlockedTrain.railways$getBlockedSign()) == 0.0 && targetSpeed > 0.0 || blockedSign == (double)Mth.sign((double)targetSpeed))) {
            targetSpeedRef.set(0);
        }
    }

    @Inject(method={"tickContraption"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/data/Couple;getFirst()Ljava/lang/Object;")})
    private void railways$storeDistanceTravelled(CallbackInfo ci, @Local(name={"distanceTo"}, ordinal=0) double distanceTo) {
        this.railways$distanceTravelled = distanceTo;
    }

    @Override
    public double railways$getDistanceTravelled() {
        return this.railways$distanceTravelled;
    }
}

