/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.chimneypush;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.content.smokestack.particles.CustomAnimatedTextureSheetParticle;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ChimneyPushParticle
extends CustomAnimatedTextureSheetParticle {
    protected final boolean leadOnly;
    protected final RandomSource random;
    protected final boolean small;

    protected ChimneyPushParticle(ClientLevel level, double x, double y, double z, RandomSource random, boolean leadOnly, boolean small) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.small = small;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.quadSize = 1.0f;
        this.friction = 0.99f;
        this.random = random;
        this.leadOnly = leadOnly;
        this.setLifetime((int)((double)random.nextIntBetweenInclusive(15, 25) * Math.min(this.getAnimationFactor() * 3.0, 1.0)));
    }

    protected double getAnimationFactor() {
        return this.leadOnly ? (this.small ? 0.3333333333333333 : 0.23076923076923078) : 1.0;
    }

    @Override
    protected int frameHeightFactor() {
        return this.small ? 2 : 1;
    }

    @Override
    protected double getAnimationProgress() {
        int age = Math.min(this.age, this.lifetime - 1);
        double lifeFactor = (double)age / (double)this.lifetime;
        return Mth.clamp((double)lifeFactor, (double)0.0, (double)1.0) * this.getAnimationFactor();
    }

    public void render(@NotNull VertexConsumer buffer, @NotNull Camera renderInfo, float partialTicks) {
        Quaternionf facing;
        Vec3 vec3 = renderInfo.getPosition();
        float quadSize = this.getQuadSize(partialTicks);
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y()) + quadSize / 2.0f;
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        if (this.roll == 0.0f) {
            facing = Axis.YP.rotationDegrees(-renderInfo.getYRot());
        } else {
            facing = new Quaternionf((Quaternionfc)Axis.YP.rotationDegrees(-renderInfo.getYRot()));
            float i = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
            facing.mul((Quaternionfc)Axis.ZP.rotation(i));
        }
        Vector3f[] vertices = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vertex = vertices[i];
            vertex.rotate((Quaternionfc)facing);
            vertex.mul(quadSize);
            if (this.small) {
                vertex.mul(1.0f, 2.0f, 1.0f);
            }
            vertex.add(x, y, z);
        }
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int packedLight = this.getLightColor(partialTicks);
        buffer.addVertex(vertices[0].x(), vertices[0].y(), vertices[0].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
        buffer.addVertex(vertices[1].x(), vertices[1].y(), vertices[1].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
        buffer.addVertex(vertices[2].x(), vertices[2].y(), vertices[2].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
        buffer.addVertex(vertices[3].x(), vertices[3].y(), vertices[3].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    public void setOldPos() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
    }

    public void tick() {
        this.setOldPos();
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory<T extends ChimneyPushParticleData<T>>
    implements ParticleProvider<T> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(@NotNull T type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ChimneyPushParticle particle = new ChimneyPushParticle(level, x, y, z, level.getRandom(), ((ChimneyPushParticleData)type).leadOnly, type instanceof ChimneyPushParticleData.Small);
            int textureCount = 18;
            int idx = 0;
            if (Mth.equal((float)((ChimneyPushParticleData)type).red, (float)-1.0f) && Mth.equal((float)((ChimneyPushParticleData)type).green, (float)-1.0f) && Mth.equal((float)((ChimneyPushParticleData)type).blue, (float)-1.0f)) {
                idx = 1;
            } else if (Mth.equal((float)((ChimneyPushParticleData)type).red, (float)((ChimneyPushParticleData)type).green) && Mth.equal((float)((ChimneyPushParticleData)type).green, (float)((ChimneyPushParticleData)type).blue) && ((ChimneyPushParticleData)type).red < -1.0f && ((ChimneyPushParticleData)type).red >= -17.0f) {
                idx = (int)Math.abs(((ChimneyPushParticleData)type).red);
            }
            particle.setSprite(this.spriteSet.get(idx, textureCount - 1));
            particle.age = level.getRandom().nextInt(5);
            if (idx == 0) {
                particle.rCol = ((ChimneyPushParticleData)type).red;
                particle.gCol = ((ChimneyPushParticleData)type).green;
                particle.bCol = ((ChimneyPushParticleData)type).blue;
            }
            particle.quadSize = ((ChimneyPushParticleData)type).getQuadSize();
            return particle;
        }
    }
}

