/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.SmokeType;
import com.railwayteam.railways.content.smokestack.block.AbstractSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.block.be.SmokeStackBlockEntity;
import com.railwayteam.railways.content.smokestack.particles.legacy.SmokeParticleData;
import com.railwayteam.railways.content.smokestack.particles.puffs.PuffSmokeParticleData;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.util.ShapeWrapper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SmokeStackBlock
extends AbstractSmokeStackBlock<SmokeStackBlockEntity> {
    public final SmokeStackType type;
    public boolean createsStationarySmoke;

    public SmokeStackBlock(BlockBehaviour.Properties properties, SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke, String variant) {
        super(properties, shape, variant);
        this.registerDefaultState(this.makeDefaultState());
        this.type = type;
        this.createsStationarySmoke = createsStationarySmoke;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor color = dyeItem.getDyeColor();
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> te.setColor(color));
            if (!pPlayer.isCreative()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (stack.is(ItemTags.SOUL_FIRE_BASE_BLOCKS)) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> te.setSoul(true));
            if (!pPlayer.isCreative()) {
                stack.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        if (pPlayer.isShiftKeyDown()) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, te -> {
                te.setSoul(false);
                te.setColor(null);
            });
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void makeParticlesStationary(Level level, BlockPos pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0, true);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, false);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary) {
        DyeColor color = null;
        boolean isSoul = false;
        BlockEntity blockEntity = level.getBlockEntity(BlockPos.containing((Position)pos));
        if (blockEntity instanceof SmokeStackBlockEntity) {
            SmokeStackBlockEntity be = (SmokeStackBlockEntity)blockEntity;
            isSoul = be.isSoul();
            color = be.getColor();
        }
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null, isSoul);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, null);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color, @Nullable Boolean small) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, color, small, false);
    }

    public static void makeParticles(Level level, Vec3 pos, boolean isSignalFire, boolean spawnExtraSmoke, Vec3 spawnOffset, Vec3 spawnDelta, double speedMultiplier, boolean stationary, @Nullable DyeColor color, @Nullable Boolean small, boolean isSoul) {
        RandomSource random = level.getRandom();
        SmokeType smokeType = (SmokeType)((Object)CRConfigs.client().smokeType.get());
        if (small == null) {
            small = random.nextDouble() < 0.33;
        }
        switch (smokeType) {
            case VANILLA: {
                SimpleParticleType particleType = isSignalFire ? ParticleTypes.CAMPFIRE_SIGNAL_SMOKE : ParticleTypes.CAMPFIRE_COSY_SMOKE;
                level.addAlwaysVisibleParticle((ParticleOptions)particleType, true, pos.x() + spawnOffset.x + random.nextDouble() * spawnDelta.x * (double)(random.nextBoolean() ? 1 : -1), pos.y() + random.nextDouble() * spawnDelta.y + spawnOffset.y, pos.z() + spawnOffset.z + random.nextDouble() * spawnDelta.z * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07 * speedMultiplier / (stationary ? 1.0 : 25.0), 0.0);
                break;
            }
            case OLD: {
                SmokeParticleData particleType;
                if (color != null) {
                    float[] c = SmokeStackBlock.colorToDiffuse(color);
                    particleType = new SmokeParticleData(stationary, c[0], c[1], c[2]);
                } else {
                    particleType = new SmokeParticleData(stationary);
                }
                level.addAlwaysVisibleParticle((ParticleOptions)particleType, true, pos.x() + spawnOffset.x + random.nextDouble() * spawnDelta.x * (random.nextDouble() * 2.0 - 1.0), pos.y() + random.nextDouble() * spawnDelta.y + spawnOffset.y + 0.5, pos.z() + spawnOffset.z + random.nextDouble() * spawnDelta.z * (random.nextDouble() * 2.0 - 1.0), 0.0, 0.07 * speedMultiplier * (double)(stationary ? 25 : 1), 0.0);
                break;
            }
            case CARTOON: {
                PuffSmokeParticleData<?> particleType = isSoul ? PuffSmokeParticleData.create(small, stationary, -2.0f, -2.0f, -2.0f) : (color != null ? PuffSmokeParticleData.create(small, stationary, color) : PuffSmokeParticleData.create(small, stationary));
                level.addAlwaysVisibleParticle(particleType, true, pos.x() + spawnOffset.x + random.nextDouble() * spawnDelta.x * (random.nextDouble() * 2.0 - 1.0), pos.y() + random.nextDouble() * spawnDelta.y + spawnOffset.y + 0.5, pos.z() + spawnOffset.z + random.nextDouble() * spawnDelta.z * (random.nextDouble() * 2.0 - 1.0), 0.0, Mth.equal((double)speedMultiplier, (double)-1.0) ? 42.0 : 2.1, 0.0);
            }
        }
        if (spawnExtraSmoke && smokeType != SmokeType.CARTOON) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, pos.x() + spawnOffset.x + random.nextDouble() * spawnDelta.x * 0.75 * (double)(random.nextBoolean() ? 1 : -1), pos.y() + spawnOffset.y - 0.1, pos.z() + spawnOffset.z + random.nextDouble() * spawnDelta.z * 0.75 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005 * speedMultiplier, 0.0);
        }
    }

    private static float[] colorToDiffuse(DyeColor color) {
        float[] fArray;
        switch (color) {
            default: {
                throw new MatchException(null, null);
            }
            case WHITE: {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 1.0f;
                break;
            }
            case ORANGE: {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.85f;
                fArray3[1] = 0.5f;
                fArray = fArray3;
                fArray3[2] = 0.2f;
                break;
            }
            case MAGENTA: {
                float[] fArray4 = new float[3];
                fArray4[0] = 0.7f;
                fArray4[1] = 0.3f;
                fArray = fArray4;
                fArray4[2] = 0.85f;
                break;
            }
            case LIGHT_BLUE: {
                float[] fArray5 = new float[3];
                fArray5[0] = 0.4f;
                fArray5[1] = 0.6f;
                fArray = fArray5;
                fArray5[2] = 0.85f;
                break;
            }
            case YELLOW: {
                float[] fArray6 = new float[3];
                fArray6[0] = 0.9f;
                fArray6[1] = 0.9f;
                fArray = fArray6;
                fArray6[2] = 0.2f;
                break;
            }
            case LIME: {
                float[] fArray7 = new float[3];
                fArray7[0] = 0.5f;
                fArray7[1] = 0.8f;
                fArray = fArray7;
                fArray7[2] = 0.1f;
                break;
            }
            case PINK: {
                float[] fArray8 = new float[3];
                fArray8[0] = 0.95f;
                fArray8[1] = 0.5f;
                fArray = fArray8;
                fArray8[2] = 0.65f;
                break;
            }
            case GRAY: {
                float[] fArray9 = new float[3];
                fArray9[0] = 0.3f;
                fArray9[1] = 0.3f;
                fArray = fArray9;
                fArray9[2] = 0.3f;
                break;
            }
            case LIGHT_GRAY: {
                float[] fArray10 = new float[3];
                fArray10[0] = 0.6f;
                fArray10[1] = 0.6f;
                fArray = fArray10;
                fArray10[2] = 0.6f;
                break;
            }
            case CYAN: {
                float[] fArray11 = new float[3];
                fArray11[0] = 0.3f;
                fArray11[1] = 0.5f;
                fArray = fArray11;
                fArray11[2] = 0.6f;
                break;
            }
            case PURPLE: {
                float[] fArray12 = new float[3];
                fArray12[0] = 0.5f;
                fArray12[1] = 0.25f;
                fArray = fArray12;
                fArray12[2] = 0.7f;
                break;
            }
            case BLUE: {
                float[] fArray13 = new float[3];
                fArray13[0] = 0.2f;
                fArray13[1] = 0.3f;
                fArray = fArray13;
                fArray13[2] = 0.7f;
                break;
            }
            case BROWN: {
                float[] fArray14 = new float[3];
                fArray14[0] = 0.4f;
                fArray14[1] = 0.3f;
                fArray = fArray14;
                fArray14[2] = 0.2f;
                break;
            }
            case GREEN: {
                float[] fArray15 = new float[3];
                fArray15[0] = 0.4f;
                fArray15[1] = 0.5f;
                fArray = fArray15;
                fArray15[2] = 0.2f;
                break;
            }
            case RED: {
                float[] fArray16 = new float[3];
                fArray16[0] = 0.6f;
                fArray16[1] = 0.2f;
                fArray = fArray16;
                fArray16[2] = 0.2f;
                break;
            }
            case BLACK: {
                float[] fArray17 = new float[3];
                fArray17[0] = 0.1f;
                fArray17[1] = 0.1f;
                fArray = fArray17;
                fArray17[2] = 0.1f;
            }
        }
        return fArray;
    }

    public void blockEntityAnimateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ENABLED)).booleanValue() && (double)random.nextFloat() < this.type.particleSpawnChance * 1.5 && this.createsStationarySmoke) {
            for (int i = 0; i < random.nextInt(this.type.maxParticles - this.type.minParticles) + this.type.minParticles; ++i) {
                SmokeStackBlock.makeParticlesStationary(level, pos, random.nextBoolean(), true, this.type.getParticleSpawnOffset(), this.type.getParticleSpawnDelta());
            }
        }
    }

    public Class<SmokeStackBlockEntity> getBlockEntityClass() {
        return SmokeStackBlockEntity.class;
    }

    public BlockEntityType<? extends SmokeStackBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.SMOKE_STACK.get();
    }

    public static class SmokeStackType {
        public Vec3 particleSpawnOffset;
        public Vec3 particleSpawnDelta;
        public double particleSpawnChance;
        public int minParticles;
        public int maxParticles;

        public SmokeStackType(double xOffset, double yOffset, double zOffset) {
            this(new Vec3(xOffset, yOffset, zOffset));
        }

        public SmokeStackType(Vec3 particleSpawnOffset) {
            this(particleSpawnOffset, new Vec3(0.3, 2.0, 0.3));
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta) {
            this(particleSpawnOffset, particleSpawnDelta, 2, 4);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles) {
            this(particleSpawnOffset, particleSpawnDelta, minParticles, maxParticles, 1.0);
        }

        public SmokeStackType(Vec3 particleSpawnOffset, Vec3 particleSpawnDelta, int minParticles, int maxParticles, double particleSpawnChance) {
            this.particleSpawnOffset = particleSpawnOffset;
            this.particleSpawnDelta = particleSpawnDelta;
            this.minParticles = minParticles;
            this.maxParticles = maxParticles;
            this.particleSpawnChance = particleSpawnChance;
        }

        public Vec3 getParticleSpawnOffset() {
            return this.particleSpawnOffset;
        }

        public Vec3 getParticleSpawnDelta() {
            return this.particleSpawnDelta;
        }
    }

    public static enum RotationType {
        NONE,
        AXIS,
        FACING;

    }
}

