/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.qol;

import com.railwayteam.railways.content.buffer.TrackBufferBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.SecondaryTrackTargetingBehaviour;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.ArrayList;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class TrackEdgePointHighlighter {
    private static final ArrayList<HolderSet> HOLDERS = new ArrayList();

    public static void clientTick(Minecraft mc) {
        BlockHitResult blockHit;
        BlockPos pos;
        BlockEntity be;
        HitResult hitResult;
        LocalPlayer player = mc.player;
        if (player == null || !EntityUtils.isHoldingItem((Player)player, item -> item instanceof WrenchItem)) {
            return;
        }
        ClientLevel level = mc.level;
        if (level != null && (hitResult = mc.hitResult) instanceof BlockHitResult && !TrackEdgePointHighlighter.showOutlinesFrom(be = level.getBlockEntity(pos = (blockHit = (BlockHitResult)hitResult).getBlockPos()), pos, 0)) {
            TrackBlockOutline.BezierPointSelection bezier;
            BlockState state = level.getBlockState(pos);
            Vec3 lookAngle = player.getLookAngle();
            TrackGraphLocation loc = null;
            Block block = state.getBlock();
            if (block instanceof ITrackBlock) {
                ITrackBlock track = (ITrackBlock)block;
                loc = TrackGraphHelper.getGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)((Direction.AxisDirection)track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond()), (Vec3)((Vec3)track.getTrackAxes((BlockGetter)level, pos, state).get(0)));
            }
            if (loc == null && (bezier = TrackBlockOutline.result) != null) {
                loc = TrackGraphHelper.getBezierGraphLocationAt((Level)level, (BlockPos)bezier.blockEntity().getBlockPos(), (Direction.AxisDirection)(lookAngle.dot(bezier.direction()) < 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE), (BezierTrackPointLocation)bezier.loc());
            }
            if (loc != null) {
                TrackGraph graph = loc.graph;
                TrackNode node1 = graph.locateNode((TrackNodeLocation)loc.edge.getFirst());
                TrackNode node2 = graph.locateNode((TrackNodeLocation)loc.edge.getSecond());
                TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(node1).get(node2);
                if (edge == null) {
                    return;
                }
                TrackGraphLocation finalLoc = loc;
                edge.getEdgeData().getPoints().stream().sorted((a, b) -> {
                    double distA = Math.abs(a.getLocationOn(edge) - finalLoc.position);
                    double distB = Math.abs(b.getLocationOn(edge) - finalLoc.position);
                    return Double.compare(distA, distB);
                }).filter(point -> Math.abs(point.getLocationOn(edge) - finalLoc.position) <= 0.5).limit(1L).forEach(point -> {
                    SingleBlockEntityEdgePoint single;
                    if (point instanceof SingleBlockEntityEdgePoint && (single = (SingleBlockEntityEdgePoint)point).getBlockEntityPos() != null) {
                        TrackEdgePointHighlighter.showOutlinesFrom(mc.level.getBlockEntity(single.getBlockEntityPos()), single.getBlockEntityPos(), 0);
                    } else if (point instanceof SignalBoundary) {
                        SignalBoundary signal = (SignalBoundary)point;
                        MutableInt index = new MutableInt(0);
                        signal.blockEntities.forEach(positions -> positions.keySet().forEach(pos2 -> {
                            if (pos2 != null) {
                                TrackEdgePointHighlighter.showOutlinesFrom(mc.level.getBlockEntity(pos2), pos2, index.getAndAdd(1));
                            }
                        }));
                    }
                });
            }
        }
    }

    private static boolean showOutlinesFrom(BlockEntity be, BlockPos pos, int index) {
        HolderSet holder;
        if (be instanceof TrackBufferBlockEntity) {
            return false;
        }
        if (HOLDERS.size() <= index) {
            holder = new HolderSet();
            HOLDERS.add(holder);
        } else {
            holder = HOLDERS.get(index);
        }
        TrackTargetingBehaviour trackTarget1 = (TrackTargetingBehaviour)TrackTargetingBehaviour.get((BlockEntity)be, (BehaviourType)TrackTargetingBehaviour.TYPE);
        if (trackTarget1 != null) {
            AABB aa = new AABB(pos).inflate(0.03125);
            Outliner.getInstance().chaseAABB(holder.BLOCK_BOX, aa).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            AABB bb = new AABB(trackTarget1.getPositionForMapMarker()).contract(0.0, 0.625, 0.0);
            Outliner.getInstance().chaseAABB(holder.TRACK_BOX, bb).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            Outliner.getInstance().showLine(holder.CONNECTOR, aa.getCenter(), bb.getCenter()).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            SecondaryTrackTargetingBehaviour trackTarget2 = (SecondaryTrackTargetingBehaviour)SecondaryTrackTargetingBehaviour.get((BlockEntity)be, SecondaryTrackTargetingBehaviour.TYPE);
            if (trackTarget2 != null) {
                AABB cc = new AABB(trackTarget2.getGlobalPosition()).contract(0.0, 0.625, 0.0);
                Outliner.getInstance().chaseAABB(holder.TRACK_BOX2, cc).colored(Color.GREEN).lineWidth(0.0625f);
                Outliner.getInstance().showLine(holder.CONNECTOR2, bb.getCenter(), cc.getCenter()).colored(Color.GREEN).lineWidth(0.0625f);
            }
            return true;
        }
        return false;
    }

    private static class HolderSet {
        final Object BLOCK_BOX = new Object();
        final Object CONNECTOR = new Object();
        final Object TRACK_BOX = new Object();
        final Object CONNECTOR2 = new Object();
        final Object TRACK_BOX2 = new Object();

        private HolderSet() {
        }
    }
}

