/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.fluids.FluidStack;

public class FuelTankRenderer
extends SafeBlockEntityRenderer<FuelTankBlockEntity> {
    public FuelTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(FuelTankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.window) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.clamp((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FuelTankBlockEntity.FuelFluidHandler tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        float xMin = tankHullWidth;
        float xMax = (float)be.width - tankHullWidth;
        float yMin = totalHeight - clampedLevel + capHeight + minPuddleHeight / 2.0f;
        float yMax = totalHeight + capHeight + minPuddleHeight / 2.0f;
        float zMin = tankHullWidth;
        float zMax = (float)be.width - tankHullWidth;
        ms.pushPose();
        ms.translate(0.0f, clampedLevel - totalHeight, 0.0f);
        CatnipServices.FLUID_RENDERER.renderFluidBox(fluidStack.getFluid().defaultFluidState(), xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.popPose();
    }

    public boolean shouldRenderOffScreen(FuelTankBlockEntity be) {
        return be.isController();
    }
}

