/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.registry.neoforge.CRBlockEntitiesImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FuelTankBlock
extends Block
implements IWrenchable,
IBE<FuelTankBlockEntity> {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    public static final SoundType SILENCED_METAL = new SoundType(0.1f, 1.5f, SoundEvents.METAL_BREAK, SoundEvents.METAL_STEP, SoundEvents.METAL_PLACE, SoundEvents.METAL_HIT, SoundEvents.METAL_FALL);

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((Level)pLevel, (BlockPos)pPos, (LivingEntity)pPlacer);
    }

    public FuelTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue(SHAPE, (Comparable)((Object)Shape.WINDOW)));
    }

    public static boolean isTank(BlockState state) {
        return state.getBlock() instanceof FuelTankBlock;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, FuelTankBlockEntity::updateConnectivity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, BOTTOM, SHAPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FuelTankBlockEntity tankAt = (FuelTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (tankAt == null) {
            return 0;
        }
        FuelTankBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null || !controllerBE.window) {
            return 0;
        }
        return tankAt.luminosity;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), FuelTankBlockEntity::toggleWindows);
        return InteractionResult.SUCCESS;
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.block();
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        FuelTankBlockEntity controllerBE;
        Fluid fluid;
        boolean onClient = world.isClientSide;
        if (heldItem.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!player.isCreative()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidHelper.FluidExchange exchange = null;
        FuelTankBlockEntity be = (FuelTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (BlockGetter)world, (BlockPos)pos);
        if (be == null) {
            return ItemInteractionResult.FAIL;
        }
        IFluidHandler fluidTank = (IFluidHandler)world.getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), (Object)ray.getDirection());
        if (fluidTank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        FluidStack prevFluidInTank = fluidTank.getFluidInTank(0).copy();
        if (FluidHelper.tryEmptyItemIntoBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((Level)world, (Player)player, (InteractionHand)hand, (ItemStack)heldItem, (SmartBlockEntity)be)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((Level)world, (ItemStack)heldItem) || GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)heldItem)) {
                return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SoundEvent soundevent = null;
        BlockState fluidState = null;
        FluidStack fluidInTank = fluidTank.getFluidInTank(0);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            fluid = fluidInTank.getFluid();
            fluidState = fluid.defaultFluidState().createLegacyBlock();
            soundevent = FluidHelper.getEmptySound((FluidStack)fluidInTank);
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.defaultFluidState().createLegacyBlock();
            soundevent = FluidHelper.getFillSound((FluidStack)prevFluidInTank);
        }
        if (soundevent != null && !onClient) {
            float pitch = Mth.clamp((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FuelTankBlockEntity.getCapacityMultiplier() * 16)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.playSound(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (world.random.nextFloat() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidStackIdentical(prevFluidInTank) && be instanceof FuelTankBlockEntity && (controllerBE = be.getControllerBE()) != null) {
            if (fluidState != null && onClient) {
                BlockParticleOption blockParticleData = new BlockParticleOption(ParticleTypes.BLOCK, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)fluidTank.getTankCapacity(0);
                boolean reversed = fluidInTank.getFluid().getFluidType().isLighterThanAir();
                if (reversed) {
                    level = 1.0f - level;
                }
                Vec3 vec = ray.getLocation();
                vec = new Vec3(vec.x, (double)((float)controllerBE.getBlockPos().getY() + level * ((float)controllerBE.height - 0.5f) + 0.25f), vec.z);
                Vec3 motion = player.position().subtract(vec).scale((double)0.05f);
                vec = vec.add(motion);
                world.addParticle((ParticleOptions)blockParticleData, vec.x, vec.y, vec.z, motion.x, motion.y, motion.z);
                return ItemInteractionResult.sidedSuccess((boolean)true);
            }
            controllerBE.sendDataImmediately();
            controllerBE.setChanged();
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof FuelTankBlockEntity)) {
                return;
            }
            FuelTankBlockEntity tankBE = (FuelTankBlockEntity)be;
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<FuelTankBlockEntity> getBlockEntityClass() {
        return FuelTankBlockEntity.class;
    }

    public BlockEntityType<? extends FuelTankBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntitiesImpl.FUEL_TANK.get();
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        boolean x = mirror == Mirror.FRONT_BACK;
        switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 4: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            }
            case 2: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            }
            case 5: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            }
            case 3: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            }
        }
        return state;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private BlockState rotateOnce(BlockState state) {
        switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            case 4: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            }
            case 2: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            }
            case 5: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            }
            case 3: {
                return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            }
        }
        return state;
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(FuelTankBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }

    public static enum Shape implements StringRepresentable
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        public String getSerializedName() {
            return Lang.asId((String)this.name());
        }
    }
}

