/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.extended_sliding_doors;

import com.railwayteam.railways.registry.CRIcons;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public enum SlidingDoorMode implements INamedIconOptions
{
    NORMAL(CRIcons.I_DOOR_NORMAL),
    MANUAL(CRIcons.I_DOOR_MANUAL){

        @Override
        public boolean canOpenSpecially() {
            return false;
        }
    }
    ,
    SPECIAL(CRIcons.I_DOOR_SPECIAL){

        @Override
        public boolean canOpenManually() {
            return false;
        }
    }
    ,
    SPECIAL_INVERTED(CRIcons.I_DOOR_SPECIAL_INVERTED){

        @Override
        public boolean canOpenManually() {
            return false;
        }
    };

    private final String translationKey;
    private final AllIcons icon;

    private SlidingDoorMode(AllIcons icon) {
        this(icon, false);
    }

    private SlidingDoorMode(AllIcons icon, boolean stationBased) {
        this.icon = icon;
        this.translationKey = "sliding_door.mode." + Lang.asId((String)this.name());
    }

    public boolean canOpenManually() {
        return true;
    }

    public boolean canOpenSpecially() {
        return true;
    }

    public AllIcons getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public static SlidingDoorMode fromNbt(CompoundTag nbt) {
        if (nbt == null) {
            return NORMAL;
        }
        return SlidingDoorMode.values()[Math.min(2, Math.max(0, nbt.getInt("ScrollValue")))];
    }

    public static interface IHasDoorMode {
        public SlidingDoorMode railways$getSlidingDoorMode();
    }

    public static class SlidingDoorValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public SlidingDoorValueBoxTransform() {
            super((state, d) -> {
                Direction facing = (Direction)state.getValue((Property)SlidingDoorBlock.FACING);
                boolean showAtAll = (Boolean)state.getValue((Property)SlidingDoorBlock.VISIBLE) != false && (Boolean)state.getValue((Property)SlidingDoorBlock.OPEN) == false;
                return showAtAll && (d == facing || d == facing.getOpposite());
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)8.0, (double)(state.getValue((Property)SlidingDoorBlock.FACING) == this.direction ? 3.0 : 16.0));
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.verticalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.X);
            return location;
        }
    }
}

