/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.generic_crossing;

import com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlock;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.TrackShapeLookup;
import com.railwayteam.railways.mixin_interfaces.IGenericCrossingTrackBE;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericCrossingBlockEntity
extends SmartBlockEntity
implements IMergeableBE,
IGenericCrossingTrackBE {
    boolean cancelDrops = false;
    private Couple<TrackMaterial> materials = null;

    public GenericCrossingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(100);
    }

    @NotNull
    public TrackMaterial getPrimary() {
        if (this.materials == null) {
            return TrackMaterial.ANDESITE;
        }
        return this.materials.getFirst() == null ? TrackMaterial.ANDESITE : (TrackMaterial)this.materials.getFirst();
    }

    @NotNull
    public TrackMaterial getSecondary() {
        if (this.materials == null) {
            return TrackMaterial.ANDESITE;
        }
        return this.materials.getSecond() == null ? TrackMaterial.ANDESITE : (TrackMaterial)this.materials.getSecond();
    }

    public void accept(BlockEntity other) {
        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void read(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(tag, lookupProvider, clientPacket);
        boolean updateMesh = false;
        TrackMaterial primary = TrackMaterial.deserialize((String)tag.getString("PrimaryMaterial"));
        TrackMaterial secondary = TrackMaterial.deserialize((String)tag.getString("SecondaryMaterial"));
        if (primary != this.getPrimary() || secondary != this.getSecondary()) {
            updateMesh = true;
        }
        this.materials = Couple.create((Object)primary, (Object)secondary);
        if (clientPacket && updateMesh) {
            this.redraw();
        }
    }

    private void redraw() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(tag, lookupProvider, clientPacket);
        tag.putString("PrimaryMaterial", this.getPrimary().id.toString());
        tag.putString("SecondaryMaterial", this.getSecondary().id.toString());
    }

    @Override
    @Nullable
    public Pair<TrackMaterial, TrackShape> railways$getFirstCrossingPiece() {
        TrackMaterial primary = this.getPrimary();
        Couple<TrackShape> unmerged = TrackShapeLookup.getUnmerged((TrackShape)this.getBlockState().getValue(GenericCrossingBlock.SHAPE));
        if (unmerged == null) {
            return null;
        }
        return Pair.of((Object)primary, (Object)((TrackShape)unmerged.getFirst()));
    }

    @Override
    @Nullable
    public Pair<TrackMaterial, TrackShape> railways$getSecondCrossingPiece() {
        TrackMaterial secondary = this.getSecondary();
        Couple<TrackShape> unmerged = TrackShapeLookup.getUnmerged((TrackShape)this.getBlockState().getValue(GenericCrossingBlock.SHAPE));
        if (unmerged == null) {
            return null;
        }
        return Pair.of((Object)secondary, (Object)((TrackShape)unmerged.getSecond()));
    }

    public void initFrom(TrackShapeLookup.GenericCrossingData crossingData) {
        if (this.level.isClientSide) {
            return;
        }
        boolean flip = (Boolean)crossingData.merged().getSecond();
        TrackMaterial primary = flip ? crossingData.overlayMaterial() : crossingData.existingMaterial();
        TrackMaterial secondary = flip ? crossingData.existingMaterial() : crossingData.overlayMaterial();
        this.materials = Couple.create((Object)primary, (Object)secondary);
        this.notifyUpdate();
    }
}

