/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.railwayteam.railways.content.coupling.coupler.SecondaryTrackTargetingBehaviour;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.railwayteam.railways.mixin_interfaces.IOccupiedCouplers;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.TrackCouplerClientInfoPacket;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TrackCouplerBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IHaveGoggleInformation {
    private BlockState cachedTrackState = null;
    private BlockState cachedSecondaryTrackState = null;
    private boolean edgePointsOk = false;
    private boolean lastReportedPower = false;
    private int lastAnalogOutput = 0;
    protected int edgeSpacing = 5;
    private int lastEdgeSpacing = 5;
    private MutableComponent error = null;
    private MutableComponent error2 = null;
    private ClientInfo clientInfo;
    public TrackTargetingBehaviour<TrackCoupler> edgePoint;
    public TrackTargetingBehaviour<TrackCoupler> secondEdgePoint;
    protected ScrollValueBehaviour edgeSpacingScroll;
    private final int lazierTickRate = 6;
    private int lazierTickCounter = 0;

    public TrackCouplerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(tag, lookupProvider, clientPacket);
        tag.putBoolean("EdgePointsOk", this.edgePointsOk);
        tag.putBoolean("Power", this.lastReportedPower);
        tag.putInt("AnalogOutput", this.lastAnalogOutput);
        tag.putInt("EdgeSpacing", this.edgeSpacing);
        tag.putInt("LastEdgeSpacing", this.lastEdgeSpacing);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(tag, lookupProvider, clientPacket);
        this.edgePointsOk = tag.getBoolean("EdgePointsOk");
        this.lastReportedPower = tag.getBoolean("Power");
        this.lastAnalogOutput = tag.getInt("AnalogOutput");
        this.edgeSpacing = tag.getInt("EdgeSpacing");
        this.lastEdgeSpacing = tag.getInt("LastEdgeSpacing");
        this.edgeSpacingScroll.setValue(this.edgeSpacing);
        this.invalidateRenderBoundingBox();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, CREdgePointTypes.COUPLER);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
        this.secondEdgePoint = new SecondaryTrackTargetingBehaviour<TrackCoupler>(this, CREdgePointTypes.COUPLER);
        behaviours.add((BlockEntityBehaviour)this.secondEdgePoint);
        this.edgeSpacingScroll = new ScrollValueBehaviour((Component)Component.translatable((String)"railways.coupler.edge_spacing"), (SmartBlockEntity)this, (ValueBoxTransform)new TrackCouplerValueBoxTransform(true));
        this.edgeSpacingScroll.between(3, 15);
        this.edgeSpacingScroll.withFormatter(i -> String.valueOf(Component.translatable((String)"railways.coupler.edge_spacing.meters")));
        this.edgeSpacingScroll.withFormatter(i -> i + "m");
        this.edgeSpacingScroll.withCallback(i -> {
            this.edgeSpacing = i;
        });
        this.edgeSpacingScroll.requiresWrench();
        behaviours.add((BlockEntityBehaviour)this.edgeSpacingScroll);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        blockState.getOptionalValue((Property)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            if (powered.booleanValue()) {
                this.onPowered();
            } else {
                this.onUnpowered();
            }
            this.notifyUpdate();
        });
        if (this.getTargetAnalogOutput() != this.lastAnalogOutput) {
            this.lastAnalogOutput = this.getTargetAnalogOutput();
            this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    protected void onPowered() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        OperationInfo info = this.getOperationInfo();
        switch (info.mode.ordinal()) {
            case 2: {
                Train train = info.frontCarriage.train;
                int numberOffEnd = train.carriages.size() - train.carriages.indexOf(info.backCarriage);
                TrainUtils.splitTrain(train, numberOffEnd);
                break;
            }
            case 1: {
                Train frontTrain = info.frontCarriage.train;
                Train backTrain = info.backCarriage.train;
                if (frontTrain == backTrain) break;
                TrainUtils.combineTrains(frontTrain, backTrain, this.getBlockPos().above(), this.level, this.getEdgeSpacing());
                break;
            }
        }
    }

    protected void onUnpowered() {
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public int getEdgeSpacing() {
        return this.edgeSpacing;
    }

    private Optional<BlockPos> getDesiredSecondaryEdgePos() {
        BlockState trackState = this.edgePoint.getTrackBlockState();
        if (!trackState.hasProperty((Property)TrackBlock.SHAPE)) {
            return Optional.empty();
        }
        double distance = -this.getEdgeSpacing() * this.edgePoint.getTargetDirection().getStep();
        Vec3 offset = ((Vec3)((TrackShape)trackState.getValue((Property)TrackBlock.SHAPE)).getAxes().get(0)).scale(distance);
        return Optional.of(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().offset(Mth.floor((double)offset.x), Mth.floor((double)offset.y), Mth.floor((double)offset.z)));
    }

    @Nullable
    private BlockState getSecondaryTrackState() {
        return this.getDesiredSecondaryEdgePos().map(pos -> this.edgePoint.getWorld().getBlockState(pos.offset((Vec3i)this.getBlockPos()))).orElse(null);
    }

    private void setError(Component component) {
        this.error = Component.empty().append(component);
    }

    private void setError2(Component component) {
        this.error2 = Component.empty().append(component);
    }

    private void clearErrors() {
        this.error = null;
    }

    private void clearError2() {
        this.error2 = null;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockState trackState = this.edgePoint.getTrackBlockState();
        BlockState secondaryTrackState = this.getSecondaryTrackState();
        if (trackState != this.cachedTrackState || secondaryTrackState != this.cachedSecondaryTrackState || this.edgeSpacing != this.lastEdgeSpacing) {
            BlockPos newPos;
            this.invalidateRenderBoundingBox();
            this.cachedTrackState = trackState;
            this.cachedSecondaryTrackState = secondaryTrackState;
            this.lastEdgeSpacing = this.edgeSpacing;
            BlockPos blockPos = newPos = this.isOkExceptGraph() ? this.getDesiredSecondaryEdgePos().orElse(BlockPos.ZERO) : BlockPos.ZERO;
            if (!newPos.equals((Object)((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack())) {
                TrackGraphLocation location;
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetTrack(newPos);
                TrackCoupler point = (TrackCoupler)this.secondEdgePoint.getEdgePoint();
                if (point != null && this.secondEdgePoint.hasValidTrack() && (location = this.secondEdgePoint.determineGraphLocation()) != null && location.graph != null) {
                    location.graph.removePoint(CREdgePointTypes.COUPLER, point.id);
                    Create.RAILWAYS.trains.forEach((uuid, train) -> {
                        ((IOccupiedCouplers)train).railways$getOccupiedCouplers().remove(point.id);
                        if (uuid == point.getCurrentTrain() || train.graph == location.graph) {
                            train.updateSignalBlocks = true;
                        }
                    });
                }
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setEdgePoint(null);
                if (this.isOkExceptGraph()) {
                    ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetDirection(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetDirection().opposite());
                }
                this.sendData();
            }
        }
        if (this.lazierTickCounter-- <= 0) {
            this.lazierTickCounter = 6;
            this.clearError2();
            this.updateOK();
        }
        this.clientInfo = new ClientInfo(this);
        this.clearErrors();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CRPackets.PACKETS.sendTo(PlayerSelection.tracking(serverLevel, this.getBlockPos()), (S2CPacket)new TrackCouplerClientInfoPacket(this));
        }
    }

    private boolean isOkExceptGraph() {
        return this.cachedTrackState.getBlock() instanceof ITrackBlock && this.cachedSecondaryTrackState.getBlock() instanceof ITrackBlock && this.cachedTrackState.hasProperty((Property)TrackBlock.SHAPE) && this.cachedSecondaryTrackState.hasProperty((Property)TrackBlock.SHAPE) && this.cachedTrackState.getValue((Property)TrackBlock.SHAPE) == this.cachedSecondaryTrackState.getValue((Property)TrackBlock.SHAPE);
    }

    protected void updateOK() {
        if (!this.isOkExceptGraph()) {
            this.setError2((Component)Component.literal((String)"Wrong blocks or track shapes"));
            this.edgePointsOk = false;
            return;
        }
        if (((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack().equals((Object)BlockPos.ZERO) || ((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().equals((Object)BlockPos.ZERO)) {
            this.setError2((Component)Component.literal((String)"Missing edge point(s)"));
            this.edgePointsOk = false;
            return;
        }
        TrackGraphLocation loc1 = this.edgePoint.determineGraphLocation();
        TrackGraphLocation loc2 = this.secondEdgePoint.determineGraphLocation();
        if (loc1 == null || loc2 == null) {
            this.setError2((Component)Component.literal((String)"Edge point(s) missing graph location"));
            this.edgePointsOk = false;
            return;
        }
        if (loc1.graph != loc2.graph) {
            this.setError2((Component)Component.literal((String)"Edge points not on same graph"));
            this.edgePointsOk = false;
            return;
        }
        Couple edgePointLocations = loc1.edge;
        Couple secondEdgePointLocations = loc2.edge;
        if (edgePointLocations == null || secondEdgePointLocations == null) {
            this.setError2((Component)Component.literal((String)"Edge point(s) missing edge location"));
            this.edgePointsOk = false;
            return;
        }
        if (((Boolean)CRConfigs.server().strictCoupler.get()).booleanValue()) {
            boolean bl = this.edgePointsOk = ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getSecond()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getSecond());
            if (!this.edgePointsOk) {
                this.setError2((Component)Component.literal((String)"Edge points not on same or adjacent edges"));
            }
        } else {
            this.edgePointsOk = true;
        }
    }

    public boolean areEdgePointsOk() {
        return this.level != null && this.level.isClientSide && this.clientInfo != null ? this.clientInfo.edgePointsOk : this.edgePointsOk;
    }

    @Nullable
    public TrackCoupler getCoupler() {
        return (TrackCoupler)this.edgePoint.getEdgePoint();
    }

    @Nullable
    public TrackCoupler getSecondaryCoupler() {
        return (TrackCoupler)this.secondEdgePoint.getEdgePoint();
    }

    @Nullable
    protected Carriage getCarriageOnPoint(@NotNull Train train, @NotNull TrackCoupler coupler, @NotNull TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        for (Carriage carriage : train.carriages) {
            if (!this.isCarriageWheelOnPoint(carriage, coupler, edgePoint, leading)) continue;
            return carriage;
        }
        return null;
    }

    protected boolean isCarriageWheelOnPoint(Carriage carriage, TrackCoupler coupler, TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        TravellingPoint relevantPoint = leading ? carriage.leadingBogey().leading() : carriage.trailingBogey().trailing();
        TravellingPoint relevantPoint2 = leading ? carriage.leadingBogey().trailing() : carriage.trailingBogey().leading();
        CarriageBogey relevantBogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        boolean upsideDown = relevantBogey.isUpsideDown();
        double couplerPosition = coupler.getLocationOn(relevantPoint.edge);
        Vec3 wheelPosition = relevantPoint.getPosition(carriage.train.graph).add(relevantPoint2.getPosition(carriage.train.graph)).scale(0.5).add(0.0, upsideDown ? 2.0 : 0.0, 0.0);
        Vec3 couplerSpatialPosition = Vec3.atBottomCenterOf((Vec3i)edgePoint.getGlobalPosition().above());
        return (coupler.isPrimary(relevantPoint.node1) || coupler.isPrimary(relevantPoint.node2) || coupler.isPrimary(relevantPoint2.node1) || coupler.isPrimary(relevantPoint2.node2)) && wheelPosition.distanceToSqr(couplerSpatialPosition) < 0.6400000000000001;
    }

    public AllowedOperationMode getAllowedOperationMode() {
        return (AllowedOperationMode)((Object)this.getBlockState().getValue(TrackCouplerBlock.MODE));
    }

    public OperationInfo getOperationInfo() {
        this.clearErrors();
        OperationInfo info = this.getOperationInfo(false);
        if (info.mode == OperationMode.NONE) {
            MutableComponent backupError = this.error;
            this.clearErrors();
            info = this.getOperationInfo(true);
            if (info.mode == OperationMode.NONE) {
                this.error = backupError;
            }
        }
        if (!info.mode.permitted(this.getAllowedOperationMode())) {
            this.clearErrors();
            this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.mode_not_permitted"));
            return OperationInfo.NONE;
        }
        return info;
    }

    protected OperationInfo getOperationInfo(boolean reversed) {
        TrackTargetingBehaviour<TrackCoupler> edgePoint2;
        TrackCoupler coupler1 = reversed ? this.getSecondaryCoupler() : this.getCoupler();
        TrackCoupler coupler2 = reversed ? this.getCoupler() : this.getSecondaryCoupler();
        TrackTargetingBehaviour<TrackCoupler> edgePoint1 = reversed ? this.secondEdgePoint : this.edgePoint;
        TrackTargetingBehaviour<TrackCoupler> trackTargetingBehaviour = edgePoint2 = reversed ? this.edgePoint : this.secondEdgePoint;
        if (this.level != null && !this.level.isClientSide()) {
            this.refreshCouplerActivation(coupler1, edgePoint1);
            this.refreshCouplerActivation(coupler2, edgePoint2);
        }
        if (coupler1 != null && coupler2 != null && coupler1.isActivated() && coupler2.isActivated()) {
            Train primaryTrain = (Train)Create.RAILWAYS.trains.get(coupler1.getCurrentTrain());
            Train secondaryTrain = (Train)Create.RAILWAYS.trains.get(coupler2.getCurrentTrain());
            if (primaryTrain != null && primaryTrain == secondaryTrain) {
                Carriage frontCarriage = this.getCarriageOnPoint(primaryTrain, coupler2, edgePoint2, false);
                if (frontCarriage == null) {
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
                if (frontCarriage != null && primaryTrain.carriages.indexOf(frontCarriage) < primaryTrain.carriages.size() - 1) {
                    Carriage backCarriage = (Carriage)primaryTrain.carriages.get(primaryTrain.carriages.indexOf(frontCarriage) + 1);
                    if (this.isCarriageWheelOnPoint(backCarriage, coupler1, edgePoint1, true) && Math.abs(primaryTrain.carriages.indexOf(frontCarriage) - primaryTrain.carriages.indexOf(backCarriage)) == 1) {
                        return new OperationInfo(OperationMode.DECOUPLING, frontCarriage, backCarriage);
                    }
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                } else {
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
            } else if (primaryTrain != null && secondaryTrain != null) {
                Carriage primaryCarriage = this.getCarriageOnPoint(primaryTrain, coupler1, edgePoint1, true);
                Carriage secondaryCarriage = this.getCarriageOnPoint(secondaryTrain, coupler2, edgePoint2, false);
                if (primaryCarriage != null && secondaryCarriage != null && primaryTrain.carriages.indexOf(primaryCarriage) == 0 && secondaryTrain.carriages.indexOf(secondaryCarriage) == secondaryTrain.carriages.size() - 1) {
                    double innerLength;
                    double outerLength = secondaryCarriage.getLeadingPoint().getPosition(secondaryTrain.graph).subtract(primaryCarriage.getTrailingPoint().getPosition(primaryTrain.graph)).lengthSqr();
                    if (outerLength < (innerLength = secondaryCarriage.getTrailingPoint().getPosition(secondaryTrain.graph).subtract(primaryCarriage.getLeadingPoint().getPosition(primaryTrain.graph)).lengthSqr())) {
                        return OperationInfo.NONE;
                    }
                    return new OperationInfo(OperationMode.COUPLING, secondaryCarriage, primaryCarriage);
                }
                if (primaryCarriage != null && this.getCarriageOnPoint(secondaryTrain, coupler2, edgePoint2, true) != null) {
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_orientation"));
                } else if (secondaryCarriage != null && this.getCarriageOnPoint(primaryTrain, coupler1, edgePoint1, false) != null) {
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_orientation"));
                } else {
                    this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
            } else {
                this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.missing_train"));
            }
        } else {
            this.setError((Component)Component.translatable((String)"railways.tooltip.coupler.error.missing_train"));
        }
        return OperationInfo.NONE;
    }

    private void refreshCouplerActivation(@Nullable TrackCoupler coupler, TrackTargetingBehaviour<TrackCoupler> edgePoint) {
        if (coupler == null || edgePoint == null || this.level == null || this.level.isClientSide() || coupler.isActivated()) {
            return;
        }
        TrackGraphLocation location = edgePoint.determineGraphLocation();
        if (location == null || location.graph == null) {
            return;
        }
        for (Train train : Create.RAILWAYS.trains.values()) {
            if (train.graph != location.graph || this.getCarriageOnPoint(train, coupler, edgePoint, true) == null && this.getCarriageOnPoint(train, coupler, edgePoint, false) == null) continue;
            ((IOccupiedCouplers)train).railways$getOccupiedCouplers().add(coupler.getId());
            coupler.keepAlive(train);
            break;
        }
    }

    public OperationMode getOperationMode() {
        return this.getOperationInfo().mode;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo != null ? this.clientInfo : ClientInfo.FALLBACK;
    }

    public void setClientInfo(ClientInfo info) {
        this.clientInfo = info;
    }

    public int getTargetAnalogOutput() {
        OperationMode mode;
        int out = 0;
        if (this.getCoupler() != null && this.getCoupler().isActivated()) {
            ++out;
        }
        if (this.getSecondaryCoupler() != null && this.getSecondaryCoupler().isActivated()) {
            out += 2;
        }
        if ((mode = this.getOperationMode()) == OperationMode.DECOUPLING) {
            out += 4;
        } else if (mode == OperationMode.COUPLING) {
            out += 8;
        }
        return out;
    }

    protected AABB createRenderBoundingBox() {
        Vec3 p1 = Vec3.atCenterOf((Vec3i)this.worldPosition);
        Vec3 p2 = Vec3.atCenterOf((Vec3i)this.edgePoint.getGlobalPosition());
        Vec3 p3 = Vec3.atCenterOf((Vec3i)this.worldPosition);
        Vec3 p4 = Vec3.atCenterOf((Vec3i)this.secondEdgePoint.getGlobalPosition());
        return new AABB(p1, p2).minmax(new AABB(p3, p4)).inflate(2.0);
    }

    public void transform(BlockEntity blockEntity, StructureTransform structureTransform) {
        this.edgePoint.transform(blockEntity, structureTransform);
        this.secondEdgePoint.transform(blockEntity, structureTransform);
    }

    private static LangBuilder b() {
        return Lang.builder((String)"railways");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.header", new Object[0]).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.mode", new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("coupler.mode." + this.getAllowedOperationMode().getSerializedName(), new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        String train1 = this.clientInfo == null ? "None" : this.clientInfo.trainName1;
        String train2 = this.clientInfo == null ? "None" : this.clientInfo.trainName2;
        OperationMode operationMode = this.clientInfo == null ? OperationMode.NONE : this.clientInfo.mode;
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.train1", new Object[]{train1}).style(ChatFormatting.GOLD).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.train2", new Object[]{train2}).style(ChatFormatting.GOLD).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.action." + operationMode.name().toLowerCase(Locale.ROOT), new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
        if (this.clientInfo != null) {
            if (this.clientInfo.error != null) {
                TrackCouplerBlockEntity.b().add(this.clientInfo.error).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            }
            if (this.clientInfo.error2 != null && ((Boolean)CRConfigs.client().showExtendedCouplerDebug.get()).booleanValue()) {
                TrackCouplerBlockEntity.b().add(this.clientInfo.error2).style(ChatFormatting.DARK_PURPLE).forGoggles(tooltip);
            }
        }
        return true;
    }

    private static class TrackCouplerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public TrackCouplerValueBoxTransform(boolean vertical) {
            super((state, d) -> d.getAxis().isVertical() == vertical);
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }
    }

    public record OperationInfo(OperationMode mode, Carriage frontCarriage, Carriage backCarriage) {
        public static final OperationInfo NONE = new OperationInfo(OperationMode.NONE, null, null);
    }

    public static enum OperationMode {
        NONE,
        COUPLING,
        DECOUPLING;


        public boolean permitted(AllowedOperationMode allowedMode) {
            return this == NONE || allowedMode == AllowedOperationMode.BOTH || allowedMode == AllowedOperationMode.COUPLING && this == COUPLING || allowedMode == AllowedOperationMode.DECOUPLING && this == DECOUPLING;
        }
    }

    public static class ClientInfo {
        public static final ClientInfo FALLBACK = new ClientInfo(OperationMode.NONE, "??", "??", false, Component.literal((String)"??"), Component.literal((String)"??"));
        public OperationMode mode;
        public String trainName1;
        public String trainName2;
        public boolean edgePointsOk;
        public MutableComponent error;
        public MutableComponent error2;

        private ClientInfo(OperationMode mode, String trainName1, String trainName2, boolean edgePointsOk, MutableComponent error, MutableComponent error2) {
            this.mode = mode;
            this.trainName1 = trainName1;
            this.trainName2 = trainName2;
            this.edgePointsOk = edgePointsOk;
            this.error = error;
            this.error2 = error2;
        }

        protected ClientInfo(TrackCouplerBlockEntity te) {
            UUID trainId;
            Train train;
            this.mode = te.getOperationMode();
            this.trainName1 = "None";
            this.trainName2 = "None";
            if (te.getCoupler() != null && te.getCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getCoupler().getCurrentTrain())) != null) {
                this.trainName1 = train.name.getString();
            }
            if (te.getSecondaryCoupler() != null && te.getSecondaryCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getSecondaryCoupler().getCurrentTrain())) != null) {
                this.trainName2 = train.name.getString();
            }
            this.edgePointsOk = te.edgePointsOk;
            this.error = te.error;
            this.error2 = te.error2;
        }

        public ClientInfo(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.mode = (OperationMode)NBTHelper.readEnum((CompoundTag)tag, (String)"mode", OperationMode.class);
            this.trainName1 = tag.getString("trainName1");
            this.trainName2 = tag.getString("trainName2");
            this.edgePointsOk = tag.getBoolean("edgePointsOk");
            this.error = tag.contains("error") ? Component.Serializer.fromJson((String)tag.getString("error"), (HolderLookup.Provider)lookupProvider) : null;
            this.error2 = tag.contains("error2") ? Component.Serializer.fromJson((String)tag.getString("error2"), (HolderLookup.Provider)lookupProvider) : null;
        }

        public CompoundTag write(HolderLookup.Provider lookupProvider) {
            CompoundTag tag = new CompoundTag();
            NBTHelper.writeEnum((CompoundTag)tag, (String)"mode", (Enum)this.mode);
            tag.putString("trainName1", this.trainName1);
            tag.putString("trainName2", this.trainName2);
            tag.putBoolean("edgePointsOk", this.edgePointsOk);
            if (this.error != null) {
                tag.putString("error", Component.Serializer.toJson((Component)this.error, (HolderLookup.Provider)lookupProvider));
            }
            if (this.error2 != null) {
                tag.putString("error2", Component.Serializer.toJson((Component)this.error2, (HolderLookup.Provider)lookupProvider));
            }
            return tag;
        }
    }

    public static enum AllowedOperationMode implements StringRepresentable
    {
        BOTH(true, true),
        COUPLING(true, false),
        DECOUPLING(false, true);

        public final boolean canCouple;
        public final boolean canDecouple;

        private AllowedOperationMode(boolean canCouple, boolean canDecouple) {
            this.canCouple = canCouple;
            this.canDecouple = canDecouple;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public Component getTranslatedName() {
            return Component.translatable((String)("railways.coupler.mode." + this.getSerializedName()));
        }
    }
}

