/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackCoupler
extends SingleBlockEntityEdgePoint {
    private int activated = 0;
    private UUID currentTrain = null;

    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public int getActivation() {
        return this.activated;
    }

    public void keepAlive(Train train) {
        if (((IHandcarTrain)train).railways$isHandcar()) {
            return;
        }
        this.activated = 8;
        this.currentTrain = train.id;
    }

    public void blockEntityAdded(BlockEntity tile, boolean front) {
        super.blockEntityAdded(tile, front);
        this.notifyTrains(tile.getLevel());
    }

    private void notifyTrains(Level level) {
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    public void read(CompoundTag nbt, HolderLookup.Provider provider, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, provider, migration, dimensions);
        this.activated = nbt.getInt("Activated");
        if (nbt.contains("TrainId")) {
            this.currentTrain = nbt.getUUID("TrainId");
        }
    }

    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
        if (buffer.readBoolean()) {
            this.blockEntityPos = buffer.readBlockPos();
        }
    }

    public void write(CompoundTag nbt, HolderLookup.Provider provider, DimensionPalette dimensions) {
        super.write(nbt, provider, dimensions);
        nbt.putInt("Activated", this.activated);
        if (this.currentTrain != null) {
            nbt.putUUID("TrainId", this.currentTrain);
        }
    }

    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
        buffer.writeBoolean(this.blockEntityPos != null);
        if (this.blockEntityPos != null) {
            buffer.writeBlockPos(this.blockEntityPos);
        }
    }
}

