/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.bogey.StandardBogeyBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public final class VirtualCouplerRendering {
    private VirtualCouplerRendering() {
    }

    public static void renderCoupler(Direction direction, double couplingDistance, boolean front, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, StandardBogeyBlockEntity te) {
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        BlockState air = Blocks.AIR.defaultBlockState();
        Block block = te.getBlockState().getBlock();
        if (block instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogeyBlock = (AbstractBogeyBlock)block;
            Vec3 anchor = bogeyBlock.getConnectorAnchorOffset(false).multiply(front ? -1.0 : 1.0, 1.0, front ? -1.0 : 1.0);
            Vec3 anchor2 = anchor.add(Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).scale(couplingDistance));
            double diffX = anchor2.x - anchor.x;
            double diffY = anchor2.y - anchor.y;
            double diffZ = anchor2.z - anchor.z;
            float yRot = AngleHelper.deg((double)Mth.atan2((double)diffZ, (double)diffX)) + 90.0f;
            float xRot = AngleHelper.deg((double)Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
            ms.pushPose();
            ms.pushPose();
            ms.translate(anchor.x, anchor.y, anchor.z);
            ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.TRAIN_COUPLING_HEAD, (BlockState)air).rotateY(-yRot)).rotateX(xRot)).light(light).renderInto(ms, vb);
            float margin = 0.1875f;
            int couplingSegments = (int)Math.round(couplingDistance * 4.0);
            double stretch = 1.0;
            for (int j = 0; j < couplingSegments; ++j) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.TRAIN_COUPLING_CABLE, (BlockState)air).rotateY(-yRot + 180.0f)).rotateX(-xRot)).translate(0.0f, 0.0f, margin + 0.125f)).scale(1.0f, 1.0f, (float)stretch)).translate(0.0f, 0.0f, (float)j / 4.0f)).light(light).renderInto(ms, vb);
            }
            ms.popPose();
            ms.pushPose();
            ms.translate(anchor2.x, anchor2.y, anchor2.z);
            ((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.TRAIN_COUPLING_HEAD, (BlockState)air).rotateY(-yRot + 180.0f)).rotateX(-xRot)).light(light).renderInto(ms, vb);
            ms.popPose();
            ms.popPose();
        }
    }
}

