/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.whistle;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.mixin.AccessorCarriage;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin_interfaces.ICarriageConductors;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRSounds;
import com.railwayteam.railways.util.TextUtils;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.trains.GlobalRailwayManager;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class ConductorWhistleItem
extends TrackTargetingBlockItem {
    public static final String SPECIAL_MARKER = "<ConductorFlag>";

    public ConductorWhistleItem(Block block, Item.Properties properties) {
        super(block, properties, EdgePointType.STATION);
    }

    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        return false;
    }

    private static InteractionResult fail(Player player, String message) {
        player.displayClientMessage((Component)Component.translatable((String)("railways.whistle.failure." + message)).withStyle(ChatFormatting.RED), true);
        player.displayClientMessage((Component)Component.translatable((String)("railways.whistle.failure." + message)).withStyle(ChatFormatting.RED), false);
        return InteractionResult.FAIL;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag != null && tag.hasUUID("SelectedTrain") && tag.hasUUID("SelectedConductor")) {
            UUID trainId = tag.getUUID("SelectedTrain");
            UUID conductorId = tag.getUUID("SelectedConductor");
            String trainName = "NOT FOUND";
            GlobalRailwayManager railways = Create.RAILWAYS.sided((LevelAccessor)context.level());
            if (railways != null && railways.trains.containsKey(trainId)) {
                trainName = ((Train)railways.trains.get((Object)trainId)).name.getString();
            }
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.bound").withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.conductor_id", conductorId.toString().substring(0, 5)));
            tooltip.add(TextUtils.translateWithFormatting("railways.whistle.tool.train_id", trainName, trainId.toString().substring(0, 5)));
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.bound_usage"));
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.bound_auto_usage"));
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.bound_auto_clear"));
        } else {
            tooltip.add((Component)Component.translatable((String)"railways.whistle.tool.not_bound").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        ConductorEntity conductor;
        Entity entity;
        if (pPlayer.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (pInteractionTarget instanceof ConductorEntity && (entity = (conductor = (ConductorEntity)pInteractionTarget).getVehicle()) instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            Train train = cce.getCarriage().train;
            if (train.owner == pPlayer.getUUID() || !((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue()) {
                CompoundTag stackTag = ((CustomData)pStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                stackTag.putUUID("SelectedTrain", train.id);
                stackTag.putUUID("SelectedConductor", conductor.getUUID());
                stackTag.putByte("SelectedColor", ((Byte)conductor.getEntityData().get(ConductorEntity.COLOR)).byteValue());
                pPlayer.displayClientMessage((Component)Component.translatable((String)"railways.whistle.set"), true);
                pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                pPlayer.setItemInHand(pUsedHand, pStack);
                AllSoundEvents.PECULIAR_BELL_USE.play(pPlayer.level(), null, conductor.getX(), conductor.getY(), conductor.getZ(), 0.5f, 1.1f);
                return InteractionResult.SUCCESS;
            }
            pPlayer.displayClientMessage((Component)Component.translatable((String)"railways.whistle.not_owner").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        return super.interactLivingEntity(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = pContext.getPlayer();
        CompoundTag stackTag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        UUID trainId = null;
        Train train = null;
        if (stackTag.hasUUID("SelectedTrain")) {
            trainId = stackTag.getUUID("SelectedTrain");
            train = (Train)Create.RAILWAYS.trains.get(trainId);
        }
        if (player instanceof DeployerFakePlayer && state.getBlock() instanceof AirBlock && train != null && train.runtime.isAutoSchedule) {
            train.runtime.discardSchedule();
        }
        if (player.isSteppingCarefully() && !stackTag.isEmpty()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"railways.whistle.clear"), true);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()));
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 0.5f);
            return InteractionResult.SUCCESS;
        }
        if (state.getBlock() instanceof StationBlock || state.getBlock() instanceof ITrackBlock) {
            ItemStack scheduleStack;
            level.playSound(null, pos, (SoundEvent)CRSounds.CONDUCTOR_WHISTLE.get(), SoundSource.BLOCKS, 0.3f, 1.0f);
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            Object stationName = "";
            if (!stackTag.hasUUID("SelectedTrain") || !stackTag.hasUUID("SelectedConductor")) {
                return ConductorWhistleItem.fail(player, "not_bound");
            }
            trainId = stackTag.getUUID("SelectedTrain");
            Train boundTrain = (Train)Create.RAILWAYS.trains.get(trainId);
            if (boundTrain == null) {
                return ConductorWhistleItem.fail(player, "train_missing");
            }
            UUID conductorId = stackTag.getUUID("SelectedConductor");
            boolean foundConductor = false;
            Carriage conductorCarriage = null;
            for (Carriage carriage : boundTrain.carriages) {
                if (!((ICarriageConductors)carriage).railways$getControllingConductors().contains(conductorId)) continue;
                foundConductor = true;
                conductorCarriage = carriage;
                break;
            }
            if (!foundConductor) {
                return ConductorWhistleItem.fail(player, "conductor_missing");
            }
            Block block = state.getBlock();
            if (block instanceof ITrackBlock) {
                ITrackBlock track = (ITrackBlock)block;
                lookAngle = player.getLookAngle();
                boolean front = track.getNearestTrackAxis((BlockGetter)level, pos, state, (Vec3)lookAngle).getSecond() == Direction.AxisDirection.POSITIVE;
                stackTag.put("SelectedPos", NbtUtils.writeBlockPos((BlockPos)pos));
                stackTag.putBoolean("SelectedDirection", front);
                stackTag.remove("Bezier");
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                EdgePointType type = this.getType(stack);
                MutableObject result = new MutableObject(null);
                ConductorWhistleItem.withGraphLocation((Level)level, (BlockPos)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
                if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                    player.displayClientMessage((Component)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).withStyle(ChatFormatting.RED), true);
                    AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                    return InteractionResult.FAIL;
                }
                Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
                Direction successDirection = null;
                for (Direction direction : directions) {
                    BlockPos placePos = pos.relative(direction);
                    Vec3 hitPos = new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5).add((double)direction.getStepX() * 0.5, (double)direction.getStepY() * 0.5, (double)direction.getStepZ() * 0.5);
                    BlockPlaceContext ctx = new BlockPlaceContext(player, pContext.getHand(), stack, new BlockHitResult(hitPos, direction.getOpposite(), placePos, false));
                    if (!level.getBlockState(placePos).canBeReplaced(ctx)) continue;
                    successDirection = direction;
                    break;
                }
                if (successDirection == null) {
                    stackTag.remove("SelectedPos");
                    stackTag.remove("SelectedDirection");
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                    return ConductorWhistleItem.fail(player, "no_space");
                }
                BlockPos placePos = pos.relative(successDirection);
                stationName = SPECIAL_MARKER + placePos.toShortString();
                BlockState placeState = CRBlocks.CONDUCTOR_WHISTLE_FLAG.getDefaultState();
                level.setBlock(placePos, placeState, 11);
                CompoundTag teTag = new CompoundTag();
                teTag.putString("Name", (String)stationName);
                teTag.putByte("SelectedColor", stackTag.getByte("SelectedColor"));
                teTag.putBoolean("TargetDirection", stackTag.getBoolean("SelectedDirection"));
                BlockPos selectedPos = NbtUtils.readBlockPos((CompoundTag)stackTag, (String)"SelectedPos").orElse(pos);
                teTag.put("TargetTrack", NbtUtils.writeBlockPos((BlockPos)selectedPos.subtract((Vec3i)placePos)));
                stackTag.put("BlockEntityTag", (Tag)teTag);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                this.updateCustomBlockEntityTag(placePos, level, player, stack, placeState);
                stackTag.remove("SelectedPos");
                stackTag.remove("SelectedDirection");
                stackTag.remove("BlockEntityTag");
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
            } else {
                lookAngle = level.getBlockEntity(pos);
                if (lookAngle instanceof StationBlockEntity) {
                    StationBlockEntity stationBe = (StationBlockEntity)lookAngle;
                    stationName = Objects.requireNonNull(stationBe.getStation()).name;
                }
            }
            if (((Boolean)CRConfigs.server().conductors.whistleRequiresOwning.get()).booleanValue() && train.runtime.getSchedule() != null && !train.runtime.completed && !train.runtime.isAutoSchedule && train.getOwner(level) != player) {
                stackTag.remove("SelectedPos");
                stackTag.remove("SelectedDirection");
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
                return ConductorWhistleItem.fail(player, "not_owner");
            }
            if (train.runtime.getSchedule() != null && !train.runtime.isAutoSchedule && !(scheduleStack = train.runtime.returnSchedule((HolderLookup.Provider)level.registryAccess())).isEmpty()) {
                for (CompoundTag passengerTag : ((AccessorCarriage)conductorCarriage).getSerialisedPassengers().values()) {
                    ListTag schedulesList;
                    if (passengerTag.contains("PlayerPassenger") || !passengerTag.contains("id") || !CREntities.CONDUCTOR.getId().equals((Object)ResourceLocation.parse((String)passengerTag.getString("id"))) || !passengerTag.hasUUID("UUID") || !passengerTag.getUUID("UUID").equals(conductorId)) continue;
                    if (!passengerTag.contains("heldSchedules")) {
                        schedulesList = new ListTag();
                        passengerTag.put("heldSchedules", (Tag)schedulesList);
                    } else {
                        schedulesList = passengerTag.getList("heldSchedules", 10);
                    }
                    schedulesList.add((Object)scheduleStack.save((HolderLookup.Provider)level.registryAccess()));
                    scheduleStack.setCount(0);
                    break;
                }
                if (!scheduleStack.isEmpty()) {
                    conductorCarriage.forEachPresentEntity(cce -> {
                        if (!scheduleStack.isEmpty()) {
                            for (Entity passenger : cce.getPassengers()) {
                                if (!(passenger instanceof ConductorEntity)) continue;
                                ConductorEntity conductorEntity = (ConductorEntity)passenger;
                                if (!passenger.getUUID().equals(conductorId)) continue;
                                conductorEntity.addSchedule(scheduleStack);
                                scheduleStack.setCount(0);
                                break;
                            }
                        }
                    });
                }
                if (!scheduleStack.isEmpty() && !player.addItem(scheduleStack)) {
                    player.drop(scheduleStack, false);
                }
            }
            player.displayClientMessage((Component)Component.translatable((String)"railways.whistle.success"), true);
            AllSoundEvents.CONTROLLER_CLICK.play(level, null, (Vec3i)pos, 1.0f, 1.0f);
            Schedule schedule = new Schedule();
            ScheduleEntry entry = new ScheduleEntry();
            DestinationInstruction instruction = new DestinationInstruction();
            ScheduledDelay condition = new ScheduledDelay();
            condition.getData().putInt("Value", 0);
            instruction.getData().putString("Text", (String)stationName);
            entry.instruction = instruction;
            if (entry.conditions.isEmpty()) {
                entry.conditions.add(new ArrayList());
            }
            ((List)entry.conditions.get(0)).add(condition);
            schedule.entries.add(entry);
            schedule.cyclic = false;
            train.runtime.discardSchedule();
            train.runtime.setSchedule(schedule, true);
            ((AccessorScheduleRuntime)train.runtime).setCooldown(10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        CompoundTag tag;
        ServerLevel serverLevel;
        if (isSelected && level instanceof ServerLevel && ((serverLevel = (ServerLevel)level).getGameTime() + (long)entity.hashCode() + (long)slotId) % (long)((Integer)CRConfigs.server().conductors.whistleRebindRate.get()).intValue() == 0L && (tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()) != null && tag.hasUUID("SelectedTrain") && tag.hasUUID("SelectedConductor")) {
            ConductorEntity conductor;
            Entity entity2;
            UUID trainId = tag.getUUID("SelectedTrain");
            UUID conductorId = tag.getUUID("SelectedConductor");
            Entity entity3 = serverLevel.getEntity(conductorId);
            if (entity3 instanceof ConductorEntity && (entity2 = (conductor = (ConductorEntity)entity3).getVehicle()) instanceof CarriageContraptionEntity) {
                CarriageContraptionEntity cce = (CarriageContraptionEntity)entity2;
                if (!trainId.equals(cce.trainId)) {
                    tag.putUUID("SelectedTrain", cce.trainId);
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                }
            }
        }
    }
}

