/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.vent;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.vent.neoforge.VentBlockImpl;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VentBlock
extends CopycatBlock
implements IWrenchable {
    public static final BooleanProperty CONDUCTOR_VISIBLE = BooleanProperty.create((String)"conductor_visible");
    public static final VoxelShape COLLISION_SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape OUTLINE_SHAPE = CRShapes.BLOCK;

    protected VentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CONDUCTOR_VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{CONDUCTOR_VISIBLE}));
    }

    public static VentBlock create(BlockBehaviour.Properties properties) {
        return VentBlockImpl.create(properties);
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    protected Optional<BlockPos> getTeleportTarget(Level level, BlockPos start, Direction prevDirection) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos end = start.mutable();
        int panic = (Integer)CRConfigs.server().conductors.maxVentLength.get();
        block0: while (true) {
            if (panic-- < 0) {
                return Optional.empty();
            }
            end.move(prevDirection);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.getBlockState((BlockPos)end).getBlock() == this) {
                visited.add(end.immutable());
                continue;
            }
            end.move(prevDirection.getOpposite());
            for (Direction direction : Direction.values()) {
                if (direction == prevDirection || direction == prevDirection.getOpposite()) continue;
                end.move(direction);
                if (visited.contains(end)) {
                    return Optional.empty();
                }
                if (level.getBlockState((BlockPos)end).getBlock() == this) {
                    visited.add(end.immutable());
                    prevDirection = direction;
                    continue block0;
                }
                end.move(direction.getOpposite());
            }
            break;
        }
        end.move(prevDirection);
        if (level.getBlockState((BlockPos)end).isAir()) {
            return Optional.of(end.immutable());
        }
        end.move(prevDirection.getOpposite());
        for (Direction direction : Direction.values()) {
            if (direction == prevDirection || direction == prevDirection.getOpposite()) continue;
            end.move(direction);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.getBlockState((BlockPos)end).isAir()) {
                return Optional.of(end.immutable());
            }
            end.move(direction.getOpposite());
        }
        return Optional.empty();
    }

    protected boolean teleportConductorInternal(Level level, BlockPos start, ConductorEntity conductor, @Nullable Direction prevDirection) {
        Optional<BlockPos> target;
        if (prevDirection == null) {
            BlockPos normal = conductor.blockPosition().subtract((Vec3i)start);
            prevDirection = Direction.fromDelta((int)normal.getX(), (int)normal.getY(), (int)normal.getZ());
            prevDirection = prevDirection == null ? Direction.NORTH : prevDirection.getOpposite();
        }
        if ((target = this.getTeleportTarget(level, start, prevDirection)).isPresent()) {
            BlockPos end = target.get();
            if (!level.getBlockState(end.above()).isAir()) {
                end = end.below();
            }
            conductor.teleportToForce((double)end.getX() + 0.5, (double)end.getY() + 0.0, (double)end.getZ() + 0.5);
            return true;
        }
        return false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                Direction direction;
                Optional<BlockPos> target;
                ServerLevel serverLevel = (ServerLevel)level;
                if (ConductorEntity.isPlayerDisguised(player) && (target = this.getTeleportTarget(level, pos, direction = hit.getDirection().getOpposite())).isPresent()) {
                    BlockPos end = target.get();
                    if (!level.getBlockState(end.above()).isAir()) {
                        end = end.below();
                    }
                    serverPlayer.teleportTo(serverLevel, (double)end.getX() + 0.5, (double)end.getY() + 0.0, (double)end.getZ() + 0.5, serverPlayer.getYRot(), serverPlayer.getXRot());
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        super.entityInside(state, level, pos, entity);
        this.teleportConductor(level, pos, entity, null);
    }

    public void teleportConductor(@NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity, @Nullable Direction direction) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            if (direction != null || conductor.ventCooldown <= 0) {
                this.teleportConductorInternal(level, pos, conductor, direction);
            }
            conductor.ventCooldown = 20;
        }
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).getEntity() instanceof ConductorEntity) {
            return COLLISION_SHAPE;
        }
        return OUTLINE_SHAPE;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        throw new AssertionError();
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        throw new AssertionError();
    }
}

